/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.designer.editors.AnnotationHover;
import org.eclipse.titan.designer.editors.BracketCompletionAutoEditStrategy;
import org.eclipse.titan.designer.editors.ClosingBracketIndentationAutoEditStrategy;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.ContentAssitant;
import org.eclipse.titan.designer.editors.HeuristicalIntervalDetector;
import org.eclipse.titan.designer.editors.IntervallBasedDamagerRepairer;
import org.eclipse.titan.designer.editors.TextHover;
import org.eclipse.titan.designer.editors.actions.IndentationSupport;
import org.eclipse.titan.designer.editors.configeditor.CodeScanner;
import org.eclipse.titan.designer.editors.configeditor.ConfigTextEditor;
import org.eclipse.titan.designer.editors.configeditor.ContentAssistProcessor;
import org.eclipse.titan.designer.editors.configeditor.PartitionScanner;
import org.eclipse.titan.designer.editors.configeditor.ReconcilingStrategy;
import org.eclipse.titan.designer.editors.ttcn3editor.DoubleClickStrategy;
import org.eclipse.titan.designer.editors.ttcn3editor.SmartIndentAfterNewLineAutoEditStrategy;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public final class Configuration
extends TextSourceViewerConfiguration {
    private final ColorManager colorManager;
    private DoubleClickStrategy doubleClickStrategy;
    private final ConfigTextEditor editor;
    private MonoReconciler reconciler;

    public Configuration(ColorManager colorManager, ConfigTextEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return PartitionScanner.PARTITION_TYPES;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning("__config_partitioning");
        IntervallBasedDamagerRepairer dr = new IntervallBasedDamagerRepairer((ITokenScanner)new CodeScanner(this.colorManager));
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssitant assistant = new ContentAssitant();
        ContentAssistProcessor pr = new ContentAssistProcessor(this.editor);
        assistant.setContentAssistProcessor(pr, "__dftl_partition_content_type");
        assistant.setDocumentPartitioning("__config_partitioning");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.setProposalSelectorBackground(Display.getCurrent().getSystemColor(1));
        return assistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return new TextHover(sourceViewer);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.reconciler == null) {
            ReconcilingStrategy strategy = new ReconcilingStrategy();
            strategy.setEditor(this.editor);
            strategy.analyze();
            this.reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            this.reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            IPreferencesService prefs = Platform.getPreferencesService();
            int timeout = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.reconcilerTimeout", 1, null);
            this.reconciler.setDelay(timeout * 1000);
        }
        return this.reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        HeuristicalIntervalDetector detector = new HeuristicalIntervalDetector();
        ClosingBracketIndentationAutoEditStrategy strategy2 = new ClosingBracketIndentationAutoEditStrategy();
        strategy2.setHeuristicIntervalDetector(detector);
        SmartIndentAfterNewLineAutoEditStrategy strategy3 = new SmartIndentAfterNewLineAutoEditStrategy();
        strategy3.setHeuristicIntervalDetector(detector);
        return new IAutoEditStrategy[]{new BracketCompletionAutoEditStrategy(), strategy2, strategy3};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{IndentationSupport.getIndentString()};
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#"};
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }
}

