/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.actions.FirstCharAction;

public final class TITANTemplateContext
extends DocumentTemplateContext {
    public TITANTemplateContext(TemplateContextType type, IDocument document, int offset, int length) {
        super(type, document, offset, length);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        if (this.isReadOnly()) {
            return buffer;
        }
        IDocument document = this.getDocument();
        String prefixString = "";
        String delimeter = null;
        try {
            IRegion lineRegion = document.getLineInformationOfOffset(this.getCompletionOffset());
            int firstCharLocation = FirstCharAction.firstVisibleCharLocation(document, lineRegion);
            if (firstCharLocation != -1) {
                prefixString = document.get(lineRegion.getOffset(), firstCharLocation - lineRegion.getOffset());
            }
            delimeter = document.getLineDelimiter(document.getLineOfOffset(this.getCompletionOffset()));
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        TemplateVariable[] variables = buffer.getVariables();
        Document temporalDocument = new Document(buffer.getString());
        MultiTextEdit edit = new MultiTextEdit(0, temporalDocument.getLength());
        List<RangeMarker> positions = TITANTemplateContext.variablesToPositions(variables);
        for (int i = temporalDocument.getNumberOfLines() - 1; i > 0; --i) {
            edit.addChild((TextEdit)new InsertEdit(temporalDocument.getLineOffset(i), prefixString));
        }
        edit.addChildren(positions.toArray(new TextEdit[positions.size()]));
        String delimeterZero = temporalDocument.getLineDelimiter(0);
        if (delimeter != null && delimeterZero != null && !delimeter.equals(delimeterZero)) {
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter((IDocument)temporalDocument);
            int startOffset = 0;
            IRegion region = adapter.find(startOffset, delimeterZero, true, false, false, false);
            while (region != null) {
                edit.addChild((TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), delimeter));
                startOffset = region.getOffset() + region.getLength();
                region = adapter.find(startOffset, delimeterZero, true, false, false, false);
            }
        }
        edit.apply((IDocument)temporalDocument, 2);
        TITANTemplateContext.positionsToVariables(positions, variables);
        buffer.setContent(temporalDocument.get(), variables);
        return buffer;
    }

    private static List<RangeMarker> variablesToPositions(TemplateVariable[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        for (int i = 0; i != variables.length; ++i) {
            int[] offsets = variables[i].getOffsets();
            for (int j = 0; j != offsets.length; ++j) {
                positions.add(new RangeMarker(offsets[j], 0));
            }
        }
        return positions;
    }

    private static void positionsToVariables(List<RangeMarker> positions, TemplateVariable[] variables) {
        Iterator<RangeMarker> iterator = positions.iterator();
        for (int i = 0; i != variables.length; ++i) {
            TemplateVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            for (int j = 0; j != offsets.length; ++j) {
                offsets[j] = ((TextEdit)iterator.next()).getOffset();
            }
            variable.setOffsets(offsets);
        }
    }
}

