/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.commonFilters;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;

public final class ResourceExclusionHelper {
    public static final QualifiedName EXCLUDED_FILE_QUALIFIER = new QualifiedName("org.eclipse.titan.designer.Properties.File", "excludeFromBuild");
    public static final QualifiedName EXCLUDED_FOLDER_QUALIFIER = new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "excludeFromBuild");
    private List<Matcher> matchers = new ArrayList<Matcher>();

    public ResourceExclusionHelper() {
        String stringList = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.excludedResources", "", null);
        List<String> splittedList = ResourceExclusionHelper.intelligentSplit(stringList, '#', '\\');
        boolean reportedError = false;
        for (String item : splittedList) {
            try {
                Pattern pattern = Pattern.compile(item);
                Matcher matcher = pattern.matcher("");
                this.matchers.add(matcher);
            }
            catch (PatternSyntaxException e) {
                if (reportedError) continue;
                ErrorReporter.logError((String)("At least one of the regular expression used as exclusion filter is not correct. Please visit the `Excluded Resources' Preference page to correct it. \nReason: " + e.getLocalizedMessage()));
                reportedError = true;
            }
        }
    }

    public boolean isExcludedByRegexp(String resourceName) {
        for (Matcher matcher : this.matchers) {
            matcher.reset(resourceName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectlyExcluded(IFolder folder) {
        try {
            return "true".equalsIgnoreCase(folder.getPersistentProperty(EXCLUDED_FOLDER_QUALIFIER));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("Error while checking persistent property of folder: " + folder.getName()), (Throwable)e);
            return false;
        }
    }

    public static boolean isDirectlyExcluded(IFile file) {
        try {
            return "true".equalsIgnoreCase(file.getPersistentProperty(EXCLUDED_FILE_QUALIFIER));
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static boolean isExcluded(IResource resource) {
        if (resource instanceof IFile && ResourceExclusionHelper.isDirectlyExcluded((IFile)resource)) {
            return true;
        }
        if (resource instanceof IFolder && ResourceExclusionHelper.isDirectlyExcluded((IFolder)resource)) {
            return true;
        }
        for (IContainer parent = resource.getParent(); parent != null && parent instanceof IFolder; parent = parent.getParent()) {
            if (!ResourceExclusionHelper.isDirectlyExcluded((IFolder)parent)) continue;
            return true;
        }
        return false;
    }

    public static final List<String> intelligentSplit(String input, char delimiter, char escape) {
        ArrayList<String> results = new ArrayList<String>();
        if (input == null || input.length() == 0) {
            return results;
        }
        StringBuilder tempResult = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (escape == c) {
                tempResult.append(c);
                ++i;
                continue;
            }
            if (delimiter == c) {
                results.add(tempResult.toString());
                tempResult.setLength(0);
                ++i;
                continue;
            }
            tempResult.append(c);
            ++i;
        }
        results.add(tempResult.toString());
        return results;
    }
}

