/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.Testcase_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ExecuteDereferedExpression
extends Expression_Value {
    private static final String OPERANDERROR = "The guard timer operand of the `execute' operation should be a float value";
    private static final String NEGATIVEDURATION = "The testcase guard timer has negative value: `{0}''";
    private static final String FLOATEXPECTED = "{0} can not be used as the testcase quard timer duration";
    private static final String FULLNAMEPART = ".<reference>";
    private static final String FULLNAMEPART2 = ".<parameters>";
    private static final String OPERATIONNAME = "execute()";
    private final Value value;
    private final ParsedActualParameters actualParameterList;
    private final Value timerValue;

    public ExecuteDereferedExpression(Value value, ParsedActualParameters actualParameterList, Value timerValue) {
        this.value = value;
        this.actualParameterList = actualParameterList;
        this.timerValue = timerValue;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (actualParameterList != null) {
            actualParameterList.setFullNameParent(this);
        }
        if (timerValue != null) {
            timerValue.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.EXECUTE_REFERENCED_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("execute(derefers(");
        if (this.value != null) {
            builder.append(this.value.createStringRepresentation());
        }
        builder.append(")(");
        builder.append("...");
        builder.append(')');
        if (this.timerValue != null) {
            builder.append(", ");
            builder.append(this.timerValue.createStringRepresentation());
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setMyScope(scope);
        }
        if (this.timerValue != null) {
            this.timerValue.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(FULLNAMEPART);
        }
        if (this.actualParameterList == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.timerValue == child) {
            return builder.append(".<operand3>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_VERDICT;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IValue last;
        if (this.value != null) {
            IType type;
            this.value.setLoweridToReference(timestamp);
            last = this.value.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_TEMPLATE, referenceChain);
            if (last.getIsErroneous(timestamp)) {
                type = null;
            } else {
                type = last.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
                if (type != null) {
                    type = type.getTypeRefdLast(timestamp);
                }
            }
            if (type == null || type.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
            } else if (IType.Type_type.TYPE_TESTCASE.equals((Object)type.getTypetype())) {
                ActualParameterList tempParameterList;
                FormalParameterList formalParameters = ((Testcase_Type)type).getFormalParameters();
                boolean isErroneous = formalParameters.checkActualParameterList(timestamp, this.actualParameterList, tempParameterList = new ActualParameterList());
                if (isErroneous) {
                    this.setIsErroneous(true);
                }
            } else {
                this.value.getLocation().reportSemanticError(MessageFormat.format("Reference to a value of type testcase was expected in the argument of `derefers()'' instead of `{0}''", type.getTypename()));
                this.setIsErroneous(true);
            }
        }
        if (this.timerValue != null) {
            this.timerValue.setLoweridToReference(timestamp);
            IType.Type_type tempType = this.timerValue.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (tempType) {
                case TYPE_REAL: {
                    last = this.timerValue.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, referenceChain);
                    if (!last.isUnfoldable(timestamp)) {
                        Real_Value real = (Real_Value)last;
                        double i = real.getValue();
                        if (i < 0.0) {
                            this.timerValue.getLocation().reportSemanticError(MessageFormat.format(NEGATIVEDURATION, real.createStringRepresentation()));
                        } else if (real.isPositiveInfinity()) {
                            this.timerValue.getLocation().reportSemanticError(MessageFormat.format(FLOATEXPECTED, real.createStringRepresentation()));
                        }
                    }
                    return;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    return;
                }
            }
            if (!this.isErroneous) {
                this.timerValue.getLocation().reportSemanticError(OPERANDERROR);
                this.setIsErroneous(true);
            }
            return;
        }
        this.checkExpressionDynamicPart(expectedValue, OPERATIONNAME, true, false, false);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.actualParameterList.getLocation());
        }
        if (this.timerValue != null) {
            this.timerValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.timerValue.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.timerValue != null) {
            this.timerValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        if (this.actualParameterList != null && !this.actualParameterList.accept(v)) {
            return false;
        }
        return this.timerValue == null || this.timerValue.accept(v);
    }
}

