/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.Altstep_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ActivateDereferedExpression
extends Expression_Value {
    private static final String ALTSTEPEXPECTED = "A value of type altstep was expected in the argument of `derefers()'' instead of `{0}''";
    private static final String FULLNAMEPART1 = ".<reference>";
    private static final String FULLNAMEPART2 = ".<parameters>";
    private static final String OPERATIONNAME = "activate()";
    private final Value value;
    private final ParsedActualParameters actualParameterList;

    public ActivateDereferedExpression(Value value, ParsedActualParameters actualParameterList) {
        this.value = value;
        this.actualParameterList = actualParameterList;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (actualParameterList != null) {
            actualParameterList.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ACTIVATE_REFERENCED_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("activate(derefers(");
        if (this.value != null) {
            builder.append(this.value.createStringRepresentation());
        }
        builder.append(")(");
        builder.append("...");
        builder.append("))");
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.actualParameterList == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_DEFAULT;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        this.value.setLoweridToReference(timestamp);
        IType type = this.value.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (type != null) {
            type = type.getTypeRefdLast(timestamp);
        }
        if (type == null || type.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return;
        }
        if (!IType.Type_type.TYPE_ALTSTEP.equals((Object)type.getTypetype())) {
            this.value.getLocation().reportSemanticError(MessageFormat.format(ALTSTEPEXPECTED, type.getTypename()));
            this.setIsErroneous(true);
            return;
        }
        ActualParameterList tempActualParameters = new ActualParameterList();
        FormalParameterList formalParameterList = ((Altstep_Type)type).getFormalParameters();
        if (formalParameterList.checkActualParameterList(timestamp, this.actualParameterList, tempActualParameters)) {
            this.setIsErroneous(true);
            return;
        }
        tempActualParameters.setFullNameParent(this);
        tempActualParameters.setMyScope(this.getMyScope());
        if (!formalParameterList.checkActivateArgument(timestamp, tempActualParameters, this.createStringRepresentation())) {
            this.setIsErroneous(true);
        }
        this.checkExpressionDynamicPart(expectedValue, OPERATIONNAME, true, true, false);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.actualParameterList.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.actualParameterList == null || this.actualParameterList.accept(v);
    }
}

