/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.EmptyStringSet;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.FullStringSet;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringSetConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringSubtypeTreeElement;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;

public final class StringSetOperation
extends StringSubtypeTreeElement {
    private final OperationType operationType;
    private StringSubtypeTreeElement a;
    private StringSubtypeTreeElement b;

    public StringSetOperation(StringSubtypeTreeElement.StringType stringType, OperationType operationType, StringSubtypeTreeElement a, StringSubtypeTreeElement b) {
        super(stringType);
        this.operationType = operationType;
        this.a = a;
        this.b = b;
    }

    @Override
    public StringSubtypeTreeElement.ElementType getElementType() {
        return StringSubtypeTreeElement.ElementType.OPERATION;
    }

    @Override
    public SubtypeConstraint complement() {
        StringSetOperation returnValue = new StringSetOperation(this.stringType, OperationType.EXCEPT, new FullStringSet(this.stringType), this);
        return returnValue.evaluate();
    }

    @Override
    public SubtypeConstraint intersection(SubtypeConstraint other) {
        StringSetOperation returnValue = new StringSetOperation(this.stringType, OperationType.INTERSECTION, this, (StringSubtypeTreeElement)other);
        return returnValue.evaluate();
    }

    @Override
    public boolean isElement(Object o) {
        switch (this.operationType) {
            case INHERIT: 
            case INTERSECTION: {
                return this.a.isElement(o) && this.b.isElement(o);
            }
            case UNION: {
                return this.a.isElement(o) || this.b.isElement(o);
            }
            case EXCEPT: {
                return this.a.isElement(o) && !this.b.isElement(o);
            }
        }
        return false;
    }

    @Override
    public TernaryBool isEmpty() {
        switch (this.operationType) {
            case INHERIT: 
            case INTERSECTION: {
                return this.a.isEmpty().or(this.b.isEmpty());
            }
            case UNION: {
                return this.a.isEmpty().and(this.b.isEmpty());
            }
            case EXCEPT: {
                TernaryBool aEmpty = this.a.isEmpty();
                return aEmpty != TernaryBool.TFALSE ? aEmpty : (this.b.isEmpty() == TernaryBool.TTRUE ? TernaryBool.TFALSE : TernaryBool.TUNKNOWN);
            }
        }
        return TernaryBool.TUNKNOWN;
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        return TernaryBool.TUNKNOWN;
    }

    @Override
    public TernaryBool isFull() {
        switch (this.operationType) {
            case INHERIT: 
            case INTERSECTION: {
                return this.a.isFull().and(this.b.isFull());
            }
            case UNION: {
                return this.a.isFull().or(this.b.isFull());
            }
            case EXCEPT: {
                return this.a.isFull().and(this.b.isEmpty());
            }
        }
        return TernaryBool.TUNKNOWN;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('(');
        this.a.toString(sb);
        switch (this.operationType) {
            case INHERIT: {
                sb.append(" intersection ");
                break;
            }
            case INTERSECTION: {
                sb.append(" intersection ");
                break;
            }
            case UNION: {
                sb.append(" union ");
                break;
            }
            case EXCEPT: {
                sb.append(" except ");
                break;
            }
            default: {
                sb.append(" <unknown operation> ");
            }
        }
        this.b.toString(sb);
        sb.append(')');
    }

    @Override
    public SubtypeConstraint union(SubtypeConstraint other) {
        StringSetOperation returnValue = new StringSetOperation(this.stringType, OperationType.UNION, this, (StringSubtypeTreeElement)other);
        return returnValue.evaluate();
    }

    @Override
    public SubtypeConstraint except(SubtypeConstraint other) {
        StringSetOperation returnValue = new StringSetOperation(this.stringType, OperationType.EXCEPT, this, (StringSubtypeTreeElement)other);
        return returnValue.evaluate();
    }

    @Override
    public TernaryBool isSubset(SubtypeConstraint other) {
        return TernaryBool.TUNKNOWN;
    }

    @Override
    public StringSubtypeTreeElement evaluate() {
        this.a = this.a.evaluate();
        this.b = this.b.evaluate();
        if (this.a instanceof EmptyStringSet || this.b instanceof EmptyStringSet) {
            if (this.operationType == OperationType.INHERIT || this.operationType == OperationType.INTERSECTION) {
                return new EmptyStringSet(this.stringType);
            }
            if (this.operationType == OperationType.UNION) {
                return this.a instanceof EmptyStringSet ? this.a : this.b;
            }
        }
        if (this.b instanceof EmptyStringSet && this.operationType == OperationType.EXCEPT) {
            return this.a;
        }
        if (this.a instanceof FullStringSet || this.b instanceof FullStringSet) {
            if (this.operationType == OperationType.INHERIT || this.operationType == OperationType.INTERSECTION) {
                return this.a instanceof FullStringSet ? this.b : this.a;
            }
            if (this.operationType == OperationType.UNION) {
                return this.a instanceof FullStringSet ? this.a : this.b;
            }
        }
        if (this.b instanceof FullStringSet && this.operationType == OperationType.EXCEPT) {
            return new EmptyStringSet(this.stringType);
        }
        if (this.a instanceof StringSetOperation || this.b instanceof StringSetOperation) {
            return this;
        }
        if (this.a instanceof FullStringSet && this.operationType == OperationType.EXCEPT && this.b instanceof StringSetConstraint) {
            switch (((StringSetConstraint)this.b).getType()) {
                case SIZE_CONSTRAINT: 
                case ALPHABET_CONSTRAINT: {
                    return ((StringSetConstraint)this.b.complement()).evaluate();
                }
            }
        }
        switch (this.operationType) {
            case INHERIT: 
            case INTERSECTION: {
                if (this.a instanceof StringSetConstraint && ((StringSetConstraint)this.a).getType() == StringSetConstraint.ConstraintType.VALUE_CONSTRAINT) {
                    this.a = ((StringSetConstraint)this.a).remove(this.b, false);
                    this.a.evaluate();
                    return this.a;
                }
                if (!(this.b instanceof StringSetConstraint) || ((StringSetConstraint)this.b).getType() != StringSetConstraint.ConstraintType.VALUE_CONSTRAINT) break;
                this.b = ((StringSetConstraint)this.b).remove(this.a, false);
                this.b.evaluate();
                return this.b;
            }
            case UNION: {
                if (this.a instanceof StringSetConstraint && ((StringSetConstraint)this.a).getType() == StringSetConstraint.ConstraintType.VALUE_CONSTRAINT) {
                    this.a = ((StringSetConstraint)this.a).remove(this.b, true);
                    this.a.evaluate();
                    break;
                }
                if (!(this.b instanceof StringSetConstraint) || ((StringSetConstraint)this.b).getType() != StringSetConstraint.ConstraintType.VALUE_CONSTRAINT) break;
                this.b = ((StringSetConstraint)this.b).remove(this.a, true);
                this.b.evaluate();
                break;
            }
            case EXCEPT: {
                if (!(this.a instanceof StringSetConstraint) || ((StringSetConstraint)this.a).getType() != StringSetConstraint.ConstraintType.VALUE_CONSTRAINT) break;
                this.a = ((StringSetConstraint)this.a).remove(this.b, true);
                this.a.evaluate();
                return this.a;
            }
        }
        if (this.a.getElementType() == this.b.getElementType()) {
            switch (this.a.getElementType()) {
                case ALL: {
                    if (this.operationType == OperationType.EXCEPT) {
                        return new EmptyStringSet(this.stringType);
                    }
                    return this.a;
                }
                case NONE: {
                    return this.a;
                }
                case CONSTRAINT: {
                    if (((StringSetConstraint)this.a).getType() != ((StringSetConstraint)this.b).getType() || ((StringSetConstraint)this.a).getType() == StringSetConstraint.ConstraintType.PATTERN_CONSTRAINT) break;
                    switch (this.operationType) {
                        case INHERIT: 
                        case INTERSECTION: {
                            return (StringSubtypeTreeElement)this.a.intersection(this.b);
                        }
                        case UNION: {
                            return (StringSubtypeTreeElement)this.a.union(this.b);
                        }
                        case EXCEPT: {
                            return (StringSubtypeTreeElement)this.a.except(this.b);
                        }
                    }
                }
            }
        }
        return this;
    }

    public static enum OperationType {
        INTERSECTION,
        INHERIT,
        UNION,
        EXCEPT;

    }
}

