/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Function_Reference_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Function_Type
extends Type {
    private static final String FUNCTIONREFERENCEVALUEEXPECTED = "Reference to a function or external function was expected";
    private static final String RUNSONLESSEXPECTED = "Type `{0}'' does not have a `runs on'' clause, but {1} runs on `{2}''.";
    private static final String INCOMPATIBLERUNSONTYPESERROR = "Runs on clause mismatch: type `{0}'' expects component type `{1}'', but {2} runs on `{3}''";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `{0}''";
    private static final String FULLNAMEPART1 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART2 = ".<runsOnType>";
    private static final String FULLNAMEPART3 = ".<return_type>";
    private final FormalParameterList formalParList;
    private final Reference runsOnRef;
    private Component_Type runsOnType;
    private final boolean runsOnSelf;
    private final Type returnType;
    private final boolean returnsTemplate;
    private final TemplateRestriction.Restriction_type templateRestriction;
    private boolean isStartable;

    public Function_Type(FormalParameterList formalParList, Reference runsOnRef, boolean runsOnSelf, Type returnType, boolean returnsTemplate, TemplateRestriction.Restriction_type templateRestriction) {
        this.formalParList = formalParList;
        this.runsOnRef = runsOnRef;
        this.runsOnSelf = runsOnSelf;
        this.returnType = returnType;
        this.returnsTemplate = returnsTemplate;
        this.templateRestriction = templateRestriction;
        formalParList.setFullNameParent(this);
        if (runsOnRef != null) {
            runsOnRef.setFullNameParent(this);
        }
        if (returnType != null) {
            returnType.setFullNameParent(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_FUNCTION;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.formalParList == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.runsOnRef == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.returnType == child) {
            return builder.append(FULLNAMEPART3);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.formalParList.setMyScope(scope);
        if (this.runsOnRef != null) {
            this.runsOnRef.setMyScope(scope);
        }
        if (this.returnType != null) {
            this.returnType.setMyScope(scope);
        }
        scope.addSubScope(this.formalParList.getLocation(), this.formalParList);
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_FUNCTION.equals((Object)temp.getTypetype());
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    public boolean returnsTemplate() {
        return this.returnsTemplate;
    }

    public Type getReturnType() {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.returnType;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    public FormalParameterList getFormalParameters() {
        return this.formalParList;
    }

    public Component_Type getRunsOnType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnType;
    }

    public boolean isRunsOnSelf() {
        return this.runsOnSelf;
    }

    public boolean isStartable(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.isStartable;
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        if (this.returnType == null) {
            return "function.gif";
        }
        return "function_return.gif";
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnSelf;
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_FUNCTION;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.runsOnType = null;
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        this.isStartable = true;
        this.parseAttributes(timestamp);
        if (this.runsOnRef != null) {
            this.runsOnType = this.runsOnRef.chkComponentypeReference(timestamp);
            if (this.runsOnType != null) {
                Scope formalParlistPreviosScope = this.formalParList.getParentScope();
                if (formalParlistPreviosScope instanceof RunsOnScope && ((RunsOnScope)formalParlistPreviosScope).getParentScope() == this.myScope) {
                    ((RunsOnScope)formalParlistPreviosScope).setComponentType(this.runsOnType);
                } else {
                    RunsOnScope tempScope = new RunsOnScope(this.runsOnType, this.myScope);
                    this.formalParList.setMyScope(tempScope);
                }
            }
        }
        this.formalParList.reset();
        this.formalParList.check(timestamp, Assignment.Assignment_type.A_FUNCTION);
        this.formalParList.checkNoLazyParams();
        boolean bl = this.isStartable = this.isStartable && this.formalParList.getStartability();
        if (this.returnType != null && this.location != null) {
            IType returnedType = this.returnType.getTypeRefdLast(timestamp);
            if (IType.Type_type.TYPE_PORT.equals((Object)returnedType.getTypetype())) {
                this.location.reportSemanticError("Functions can not return ports");
            }
            this.isStartable = this.isStartable && !IType.Type_type.TYPE_DEFAULT.equals((Object)returnedType.getTypetype());
        }
        this.checkSubtypeRestrictions(timestamp);
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        if (this.runsOnSelf) {
            this.location.reportSemanticError(MessageFormat.format("Function type `{0}'' with `runs on self'' clause cannot be {1}", this.getTypename(), operation));
        }
    }

    public boolean checkStartable(CompilationTimeStamp timestamp, Location errorLocation) {
        this.check(timestamp);
        if (this.isStartable) {
            return true;
        }
        if (this.runsOnRef == null) {
            errorLocation.reportSemanticError(MessageFormat.format("Functions of type `{0}'' cannot be started on a parallel test component because the type does not have `runs on'' clause", this.getTypename()));
        }
        this.formalParList.checkStartability(timestamp, "Functions of type", this, errorLocation);
        if (this.returnType != null && this.returnType.isComponentInternal(timestamp)) {
            HashSet<IType> typeSet = new HashSet<IType>();
            String operation = "the return type or embedded in the return type of function type `" + this.getTypename() + "' if it is started on parallel test component";
            this.returnType.checkComponentInternal(timestamp, typeSet, operation);
        }
        return false;
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        Definition assignment = null;
        switch (last.getValuetype()) {
            case FUNCTION_REFERENCE_VALUE: {
                assignment = ((Function_Reference_Value)last).getReferredFunction();
                if (assignment == null) {
                    value.setIsErroneous(true);
                    return;
                }
                assignment.check(timestamp);
                break;
            }
            case TTCN3_NULL_VALUE: {
                return;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                return;
            }
            default: {
                value.getLocation().reportSemanticError(FUNCTIONREFERENCEVALUEEXPECTED);
                value.setIsErroneous(true);
                return;
            }
        }
        if (assignment instanceof Def_Function) {
            this.formalParList.checkCompatibility(timestamp, ((Def_Function)assignment).getFormalParameterList(), value.getLocation());
            Component_Type tempRunsOnType = ((Def_Function)assignment).getRunsOnType(timestamp);
            if (tempRunsOnType != null) {
                if (this.runsOnSelf) {
                    Scope valueScope = value.getMyScope();
                    if (valueScope == null) {
                        value.setIsErroneous(true);
                        value.setLastTimeChecked(timestamp);
                        return;
                    }
                    RunsOnScope runsOnScope = valueScope.getScopeRunsOn();
                    if (runsOnScope != null) {
                        Component_Type componentType = runsOnScope.getComponentType();
                        if (!tempRunsOnType.isCompatible(timestamp, componentType, null, null, null)) {
                            value.getLocation().reportSemanticError(MessageFormat.format("Runs on clause mismatch: type `{0}'' has a `runs on self'' clause and the current scope expects component type `{1}'', but {2} runs on `{3}''", this.getTypename(), componentType.getTypename(), assignment.getDescription(), tempRunsOnType.getTypename()));
                        }
                    } else if (valueScope instanceof ComponentTypeBody) {
                        ComponentTypeBody body = (ComponentTypeBody)valueScope;
                        if (!tempRunsOnType.isCompatible(timestamp, body.getMyType(), null, null, null)) {
                            value.getLocation().reportSemanticError(MessageFormat.format("Runs on clause mismatch: type `{0}'' has a `runs on self'' clause and the current component definition is of type `{1}'', but {2} runs on `{3}''", this.getTypename(), body.getMyType().getTypename(), assignment.getDescription(), tempRunsOnType.getTypename()));
                        }
                    } else {
                        value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' has a `runs on self'' clause and the current scope does not have a `runs on'' clause, but {1} runs on `{2}''", this.getTypename(), assignment.getDescription(), tempRunsOnType.getTypename()));
                    }
                } else if (this.runsOnRef == null) {
                    value.getLocation().reportSemanticError(MessageFormat.format(RUNSONLESSEXPECTED, this.getTypename(), assignment.getAssignmentName(), tempRunsOnType.getTypename()));
                    value.setIsErroneous(true);
                } else if (this.runsOnType != null && !tempRunsOnType.isCompatible(timestamp, this.runsOnType, null, null, null)) {
                    value.getLocation().reportSemanticError(MessageFormat.format(INCOMPATIBLERUNSONTYPESERROR, this.getTypename(), this.runsOnType.getTypename(), assignment.getAssignmentName(), tempRunsOnType.getTypename()));
                    value.setIsErroneous(true);
                }
            }
        }
        switch (assignment.getAssignmentType()) {
            case A_FUNCTION: 
            case A_EXT_FUNCTION: {
                if (this.returnType == null) break;
                value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' expects a function or external function that returns a {1} of type `{2}'', but {3} does not have a return type", this.getTypename(), this.returnsTemplate ? "template" : "value", this.returnType.getTypename(), assignment.getDescription()));
                break;
            }
            case A_FUNCTION_RTEMP: {
                IType tempReturnType;
                TemplateRestriction.Restriction_type restriction = ((Def_Function)assignment).getTemplateRestriction();
                if (!this.templateRestriction.equals((Object)restriction)) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' expects a function or external function that returns a template with {1} restriction, but {2} returns a template with {3} restriction", this.getTypename(), TemplateRestriction.Restriction_type.TR_NONE.equals((Object)this.templateRestriction) ? "no" : this.templateRestriction.getDisplayName(), assignment.getDescription(), TemplateRestriction.Restriction_type.TR_NONE.equals((Object)restriction) ? "no" : restriction.getDisplayName()));
                }
                if (this.returnType != null) {
                    tempReturnType = assignment.getType(timestamp);
                    if (!this.returnType.isIdentical(timestamp, tempReturnType)) {
                        value.getLocation().reportSemanticError(MessageFormat.format("Return type missmatch: type `{0}'' expects a function or external function that returns a {1} of type `{2}'', but {3} returns a template of type `{3}''", this.getTypename(), this.returnsTemplate ? "template" : "value", this.returnType.getTypename(), assignment.getDescription(), tempReturnType.getTypename()));
                        break;
                    }
                    if (this.returnsTemplate) break;
                    value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' expects a function or external function that returns a value of type `{1}'', but {2} returns a template", this.getTypename(), this.returnType.getTypename(), assignment.getDescription()));
                    break;
                }
                value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' expects a function or external function without return type, but {1} returns a template of type `{2}''", this.getTypename(), assignment.getDescription(), assignment.getType(timestamp).getTypename()));
                break;
            }
            case A_EXT_FUNCTION_RTEMP: {
                IType tempReturnType;
                TemplateRestriction.Restriction_type restriction = ((Def_Extfunction)assignment).getTemplateRestriction();
                if (!this.templateRestriction.equals((Object)restriction)) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' expects a function or external function that returns a template with {1} restriction, but {2} returns a template with {3} restriction", this.getTypename(), TemplateRestriction.Restriction_type.TR_NONE.equals((Object)this.templateRestriction) ? "no" : this.templateRestriction.getDisplayName(), assignment.getDescription(), TemplateRestriction.Restriction_type.TR_NONE.equals((Object)restriction) ? "no" : restriction.getDisplayName()));
                }
                if (this.returnType != null) {
                    tempReturnType = assignment.getType(timestamp);
                    if (!this.returnType.isIdentical(timestamp, tempReturnType)) {
                        value.getLocation().reportSemanticError(MessageFormat.format("Return type missmatch: type `{0}'' expects a function or external function that returns a {1} of type `{2}'', but {3} returns a template of type `{3}''", this.getTypename(), this.returnsTemplate ? "template" : "value", this.returnType.getTypename(), assignment.getDescription(), tempReturnType.getTypename()));
                        break;
                    }
                    if (this.returnsTemplate) break;
                    value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' expects a function or external function that returns a value of type `{1}'', but {2} returns a template", this.getTypename(), this.returnType.getTypename(), assignment.getDescription()));
                    break;
                }
                value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' expects a function or external function without return type, but {1} returns a template of type `{2}''", this.getTypename(), assignment.getDescription(), assignment.getType(timestamp).getTypename()));
                break;
            }
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: {
                if (this.returnType != null) {
                    IType tempReturnType = assignment.getType(timestamp);
                    if (!this.returnType.isIdentical(timestamp, tempReturnType)) {
                        value.getLocation().reportSemanticError(MessageFormat.format("Return type missmatch: type `{0}'' expects a function or external function that returns a {1} of type `{2}'', but {3} returns a value of type `{3}''", this.getTypename(), this.returnsTemplate ? "template" : "value", this.returnType.getTypename(), assignment.getDescription(), tempReturnType.getTypename()));
                        break;
                    }
                    if (!this.returnsTemplate) break;
                    value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' expects a function or external function that returns a template of type `{1}'', but {2} returns a value", this.getTypename(), this.returnType.getTypename(), assignment.getDescription()));
                    break;
                }
                value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' expects a function or external function without return type, but {1} returns a value of type `{2}''", this.getTypename(), assignment.getDescription(), assignment.getType(timestamp).getTypename()));
                break;
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("function type");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() != i + 1 || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        propCollector.addTemplateProposal("apply", new Template("apply( parameters )", "", propCollector.getContextIdentifier(), "apply( ${parameters} )", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.formalParList != null) {
            this.formalParList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParList.getLocation());
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.runsOnRef.getLocation());
        }
        if (this.returnType != null) {
            this.returnType.updateSyntax(reparser, false);
            reparser.updateLocation(this.returnType.getLocation());
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParList != null) {
            this.formalParList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.runsOnType != null) {
            this.runsOnType.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.returnType != null) {
            this.returnType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParList != null && !this.formalParList.accept(v)) {
            return false;
        }
        if (this.runsOnRef != null && !this.runsOnRef.accept(v)) {
            return false;
        }
        if (this.runsOnType != null && !this.runsOnType.accept(v)) {
            return false;
        }
        return this.returnType == null || this.returnType.accept(v);
    }
}

