/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class DefinitionContainer
implements Iterable<Definition> {
    private final List<Definition> definitions = new CopyOnWriteArrayList<Definition>();
    private final Map<String, Definition> definitionMap = new HashMap<String, Definition>();

    public Map<String, Definition> getDefinitionMap() {
        return this.definitionMap;
    }

    public void checkAll(CompilationTimeStamp timestamp) {
        for (Definition def : this.definitions) {
            def.check(timestamp);
        }
    }

    public int size() {
        return this.definitions.size();
    }

    public boolean hasDefinition(String id) {
        return this.definitionMap.containsKey(id);
    }

    public Definition getDefinition(String id) {
        return this.definitionMap.get(id);
    }

    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    public boolean contains(Definition definition) {
        return this.definitions.contains(definition);
    }

    @Override
    public Iterator<Definition> iterator() {
        return this.definitions.iterator();
    }

    public void add(Definition definition) {
        this.definitions.add(definition);
        String definitionName = definition.getIdentifier().getName();
        if (this.definitionMap.containsKey(definitionName)) {
            this.definitionMap.get(definitionName).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format("Duplicate field name `{0}'' was first declared here", definition.getIdentifier().getDisplayName()));
            definition.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Duplicate field name `{0}'' was declared here again", definition.getIdentifier().getDisplayName()));
        } else {
            this.definitionMap.put(definitionName, definition);
        }
    }

    public void checkUniqueness() {
        this.definitionMap.clear();
        for (Definition definition : this.definitions) {
            String definitionName = definition.getIdentifier().getName();
            if (this.definitionMap.containsKey(definitionName)) {
                this.definitionMap.get(definitionName).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format("Duplicate field name `{0}'' was first declared here", definition.getIdentifier().getDisplayName()));
                definition.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Duplicate field name `{0}'' was declared here again", definition.getIdentifier().getDisplayName()));
                continue;
            }
            this.definitionMap.put(definitionName, definition);
        }
    }

    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }
}

