/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SelectCases
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".select_case_";
    private final List<SelectCase> select_cases = new ArrayList<SelectCase>();

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            if (this.select_cases.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i + 1));
        }
        return builder;
    }

    public void addSelectCase(SelectCase selectCase) {
        this.select_cases.add(selectCase);
        selectCase.setFullNameParent(this);
    }

    @Override
    public void setMyScope(Scope scope) {
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            this.select_cases.get(i).setMyScope(scope);
        }
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            this.select_cases.get(i).setMyStatementBlock(statementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            this.select_cases.get(i).setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            this.select_cases.get(i).setMyAltguards(altGuards);
        }
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        StatementBlock.ReturnStatus_type result = StatementBlock.ReturnStatus_type.RS_MAYBE;
        boolean hasElse = false;
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            SelectCase selectCase = this.select_cases.get(i);
            switch (selectCase.hasReturn(timestamp)) {
                case RS_NO: {
                    if (result == StatementBlock.ReturnStatus_type.RS_YES) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_NO;
                    break;
                }
                case RS_YES: {
                    if (result == StatementBlock.ReturnStatus_type.RS_NO) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_YES;
                    break;
                }
                default: {
                    return StatementBlock.ReturnStatus_type.RS_MAYBE;
                }
            }
            if (!selectCase.hasElse()) continue;
            hasElse = true;
            break;
        }
        if (!hasElse && result == StatementBlock.ReturnStatus_type.RS_YES) {
            return StatementBlock.ReturnStatus_type.RS_MAYBE;
        }
        return result;
    }

    public void check(CompilationTimeStamp timestamp, IType governor) {
        boolean unrechable = false;
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            unrechable = this.select_cases.get(i).check(timestamp, governor, unrechable);
        }
    }

    public void checkAllowedInterleave() {
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            this.select_cases.get(i).checkAllowedInterleave();
        }
    }

    public void postCheck() {
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            this.select_cases.get(i).postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            SelectCase branch = this.select_cases.get(i);
            branch.updateSyntax(reparser, false);
            reparser.updateLocation(branch.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.select_cases == null) {
            return;
        }
        for (SelectCase sc : this.select_cases) {
            sc.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.select_cases != null) {
            for (SelectCase sc : this.select_cases) {
                if (sc.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public List<SelectCase> getSelectCaseArray() {
        return this.select_cases;
    }
}

