/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Def_Var
extends Definition {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<initial_value>";
    public static final String PORTNOTALLOWED = "Variable can not be defined for port type `{0}''";
    public static final String SIGNATURENOTALLOWED = "Variable can not be defined for signature `{0}''";
    private static final String KIND = " variable definition";
    private final Type type;
    private final Value initialValue;
    private boolean wasAssigned;

    public Def_Var(Identifier identifier, Type type, Value initialValue) {
        super(identifier);
        this.type = type;
        this.initialValue = initialValue;
        if (type != null) {
            type.setFullNameParent(this);
        }
        if (initialValue != null) {
            initialValue.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_VAR;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.initialValue == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.initialValue != null) {
            this.initialValue.setMyScope(scope);
        }
    }

    @Override
    public String getAssignmentName() {
        return "variable";
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAssignmentName()).append(" `");
        if (this.isLocal()) {
            builder.append(this.identifier.getDisplayName());
        } else {
            builder.append(this.getFullName());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "variable.gif";
    }

    @Override
    public int category() {
        int result = super.category();
        if (this.type != null) {
            result += this.type.category();
        }
        return result;
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    public Value getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setWithAttributes(MultipleWithAttributes attributes) {
    }

    @Override
    public void setAttributeParentPath(WithAttributesPath parent) {
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isUsed = false;
        this.wasAssigned = false;
        if (this.getMyScope() instanceof ComponentTypeBody) {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionComponentVariable", this.identifier, this);
        } else {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionLocalVariable", this.identifier, this);
        }
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.type == null) {
            return;
        }
        this.type.check(timestamp);
        this.lastTimeChecked = timestamp;
        IType lastType = this.type.getTypeRefdLast(timestamp);
        switch (lastType.getTypetype()) {
            case TYPE_PORT: {
                this.location.reportSemanticError(MessageFormat.format(PORTNOTALLOWED, lastType.getFullName()));
                break;
            }
            case TYPE_SIGNATURE: {
                this.location.reportSemanticError(MessageFormat.format(SIGNATURENOTALLOWED, lastType.getFullName()));
                break;
            }
        }
        if (this.initialValue != null) {
            this.initialValue.setMyGovernor(this.type);
            IValue temporalValue = this.type.checkThisValueRef(timestamp, this.initialValue);
            if (this.isLocal()) {
                this.type.checkThisValue(timestamp, temporalValue, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, true, false, true, false, false));
            } else {
                this.type.checkThisValue(timestamp, temporalValue, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_STATIC_VALUE, true, false, true, false, false));
            }
        }
    }

    @Override
    public void postCheck() {
        super.postCheck();
        if (!(this.wasAssigned || this.initialValue == null || this.initialValue.getIsErroneous(this.lastTimeChecked) || this.initialValue.isUnfoldable(this.lastTimeChecked))) {
            String message = MessageFormat.format("The {0} seems to be never written, maybe it could be a constant", this.getDescription());
            String option = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportReadOnly", "warning", null);
            this.location.reportConfigurableSemanticProblem(option, message);
        }
    }

    public void setWritten() {
        this.wasAssigned = true;
    }

    @Override
    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        this.check(timestamp);
        definition.check(timestamp);
        if (!Assignment.Assignment_type.A_VAR.equals(definition.getAssignmentType())) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a variable, but the definition inherited from component type `{1}'' is a {2}", this.identifier.getDisplayName(), definition.getMyScope().getFullName(), definition.getAssignmentName()));
            return false;
        }
        Def_Var otherVariable = (Def_Var)definition;
        if (!this.type.isIdentical(timestamp, otherVariable.type)) {
            String message = MessageFormat.format("Local variable `{0}'' has type `{1}'', but the variable inherited from component type `{2}'' has type `{3}''", this.identifier.getDisplayName(), this.type.getTypename(), otherVariable.getMyScope().getFullName(), otherVariable.type.getTypename());
            this.type.getLocation().reportSemanticError(message);
            return false;
        }
        if (this.initialValue != null) {
            if (otherVariable.initialValue != null) {
                if (!(this.initialValue.isUnfoldable(timestamp) || otherVariable.initialValue.isUnfoldable(timestamp) || this.initialValue.checkEquality(timestamp, otherVariable.initialValue))) {
                    String message = MessageFormat.format("Local variable `{0}'' and the variable inherited from component type `{1}'' have different values", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName());
                    this.initialValue.getLocation().reportSemanticWarning(message);
                }
            } else {
                this.initialValue.getLocation().reportSemanticWarning(MessageFormat.format("Local variable `{0}'' has initial value, but the variable inherited from component type `{1}'' does not", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName()));
            }
        } else if (otherVariable.initialValue != null) {
            this.location.reportSemanticWarning(MessageFormat.format("Local variable `{0}'' does not have initial value, but the variable inherited from component type `{1}'' has", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName()));
        }
        return true;
    }

    @Override
    public String getProposalKind() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            this.type.getProposalDescription(builder);
        }
        builder.append(KIND);
        return builder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            super.addProposal(propCollector, i);
        } else if (subrefs.size() > i + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.type.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > i && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            if (subrefs.size() > i + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, i + 1);
            } else if (subrefs.size() == i + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        List<Integer> result = super.getPossibleExtensionStarterTokens();
        if (this.initialValue == null) {
            result.add(218);
        }
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            int result = 1;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    this.type.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.type.getLocation());
                }
            }
            if (this.initialValue != null) {
                if (enveloped) {
                    this.initialValue.updateSyntax(reparser, false);
                    reparser.updateLocation(this.initialValue.getLocation());
                } else if (reparser.envelopsDamage(this.initialValue.getLocation())) {
                    this.initialValue.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.initialValue.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.initialValue != null) {
            this.initialValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.initialValue.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.initialValue != null) {
            this.initialValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.initialValue == null || this.initialValue.accept(v);
    }

    public boolean getWritten() {
        return this.wasAssigned;
    }
}

