/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PrototypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.T3Doc;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Def_Function
extends Definition
implements IParameterisedAssignment {
    private static final String FULLNAMEPART1 = ".<runs_on_type>";
    private static final String FULLNAMEPART2 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART3 = ".<type>";
    private static final String FULLNAMEPART4 = ".<statement_block>";
    public static final String PORTRETURNNOTALLOWED = "Functions can not return ports";
    private static final String DASHALLOWEDONLYFORTEMPLATES = "Using not used symbol (`-') as the default parameter is allowed only for modified templates";
    private static final String KIND = "function";
    private final Assignment.Assignment_type assignmentType;
    private final FormalParameterList formalParList;
    private final Reference runsOnRef;
    private Component_Type runsOnType = null;
    private final Type returnType;
    private final boolean returnsTemplate;
    private final TemplateRestriction.Restriction_type templateRestriction;
    private final StatementBlock block;
    private EncodingPrototype_type prototype;
    private Type inputType;
    private Type outputType;
    private boolean isStartable;
    private NamedBridgeScope bridgeScope = null;

    public static String getKind() {
        return KIND;
    }

    public Def_Function(Identifier identifier, FormalParameterList formalParameters, Reference runsOnRef, Type returnType, boolean returnsTemplate, TemplateRestriction.Restriction_type templateRestriction, StatementBlock block) {
        super(identifier);
        this.assignmentType = returnType == null ? Assignment.Assignment_type.A_FUNCTION : (returnsTemplate ? Assignment.Assignment_type.A_FUNCTION_RTEMP : Assignment.Assignment_type.A_FUNCTION_RVAL);
        this.formalParList = formalParameters;
        if (this.formalParList != null) {
            this.formalParList.setMyDefinition(this);
            this.formalParList.setFullNameParent(this);
        }
        this.runsOnRef = runsOnRef;
        this.returnType = returnType;
        this.returnsTemplate = returnsTemplate;
        this.templateRestriction = templateRestriction;
        this.block = block;
        this.prototype = EncodingPrototype_type.NONE;
        this.inputType = null;
        this.outputType = null;
        if (block != null) {
            block.setMyDefinition(this);
            block.setFullNameParent(this);
        }
        if (runsOnRef != null) {
            runsOnRef.setFullNameParent(this);
        }
        if (returnType != null) {
            returnType.setFullNameParent(this);
        }
    }

    public boolean isStartable() {
        return this.isStartable;
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return this.assignmentType;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.runsOnRef == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.formalParList == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.returnType == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.block == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public FormalParameterList getFormalParameterList() {
        return this.formalParList;
    }

    public EncodingPrototype_type getPrototype() {
        return this.prototype;
    }

    public Type getInputType() {
        return this.inputType;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getOutlineIcon() {
        if (this.returnType == null) {
            return "function.gif";
        }
        return "function_return.gif";
    }

    @Override
    public String getProposalDescription() {
        StringBuilder nameBuilder = new StringBuilder(this.identifier.getDisplayName());
        nameBuilder.append('(');
        this.formalParList.getAsProposalDesriptionPart(nameBuilder);
        nameBuilder.append(')');
        return nameBuilder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.bridgeScope != null && this.bridgeScope.getParentScope() == scope) {
            return;
        }
        this.bridgeScope = new NamedBridgeScope();
        this.bridgeScope.setParentScope(scope);
        scope.addSubScope(this.getLocation(), this.bridgeScope);
        this.bridgeScope.setScopeMacroName(this.identifier.getDisplayName());
        super.setMyScope(this.bridgeScope);
        if (this.runsOnRef != null) {
            this.runsOnRef.setMyScope(this.bridgeScope);
        }
        this.formalParList.setMyScope(this.bridgeScope);
        if (this.returnType != null) {
            this.returnType.setMyScope(this.bridgeScope);
        }
        if (this.block != null) {
            this.block.setMyScope(this.formalParList);
        }
        if (this.block != null) {
            this.bridgeScope.addSubScope(this.block.getLocation(), this.block);
        }
        this.bridgeScope.addSubScope(this.formalParList.getLocation(), this.formalParList);
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.returnType;
    }

    public Component_Type getRunsOnType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnType;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        T3Doc.check(this.getCommentLocation(), KIND);
        this.isUsed = false;
        this.runsOnType = null;
        this.lastTimeChecked = timestamp;
        this.isStartable = false;
        if (this.runsOnRef != null) {
            this.runsOnType = this.runsOnRef.chkComponentypeReference(timestamp);
            if (this.runsOnType != null) {
                Scope formalParlistPreviosScope = this.formalParList.getParentScope();
                if (formalParlistPreviosScope instanceof RunsOnScope && ((RunsOnScope)formalParlistPreviosScope).getParentScope() == this.myScope) {
                    ((RunsOnScope)formalParlistPreviosScope).setComponentType(this.runsOnType);
                } else {
                    RunsOnScope tempScope = new RunsOnScope(this.runsOnType, this.myScope);
                    this.formalParList.setMyScope(tempScope);
                }
            }
        }
        boolean canSkip = false;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            canSkip = true;
        }
        if (!canSkip) {
            this.formalParList.reset();
        }
        this.formalParList.check(timestamp, this.getAssignmentType());
        if (this.returnType != null) {
            this.returnType.check(timestamp);
            IType returnedType = this.returnType.getTypeRefdLast(timestamp);
            if (IType.Type_type.TYPE_PORT.equals((Object)returnedType.getTypetype()) && this.returnType.getLocation() != null) {
                this.returnType.getLocation().reportSemanticError(PORTRETURNNOTALLOWED);
            }
        }
        if (this.formalParList.hasNotusedDefaultValue()) {
            this.formalParList.getLocation().reportSemanticError(DASHALLOWEDONLYFORTEMPLATES);
            return;
        }
        this.isStartable = this.runsOnRef != null;
        this.isStartable &= this.formalParList.getStartability();
        if (this.isStartable && this.returnType != null && this.returnType.isComponentInternal(timestamp)) {
            this.isStartable = false;
        }
        if (canSkip) {
            return;
        }
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionFunction", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.block != null) {
            this.block.check(timestamp);
            if (this.returnType != null) {
                switch (this.block.hasReturn(timestamp)) {
                    case RS_NO: {
                        this.identifier.getLocation().reportSemanticError("The function has a return type, but it does not have any return statement");
                        break;
                    }
                    case RS_MAYBE: {
                        this.identifier.getLocation().reportSemanticError("The function has return type, but control might leave it without reaching a return statement");
                        break;
                    }
                }
            }
            this.block.postCheck();
            if (!EditorTracker.containsKey((IFile)this.getLocation().getFile())) {
                this.block.free();
            }
        }
        this.prototype = EncodingPrototype_type.NONE;
        this.inputType = null;
        this.outputType = null;
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
            this.analyzeExtensionAttributes(timestamp);
            this.checkPrototype(timestamp);
        }
    }

    public boolean checkStartable(CompilationTimeStamp timestamp, Location errorLocation) {
        this.check(timestamp);
        if (this.isStartable) {
            return true;
        }
        if (this.runsOnRef == null) {
            errorLocation.reportSemanticError(MessageFormat.format("Function `{0}'' cannot be started on parallel test component because it does not have a `runs on'' clause", this.getFullName()));
        }
        this.formalParList.checkStartability(timestamp, "Function", this, errorLocation);
        if (this.returnType != null && this.returnType.isComponentInternal(timestamp)) {
            HashSet<IType> typeSet = new HashSet<IType>();
            String errorMessage = "the return type or embedded in the return type of function `" + this.getFullName() + "' if it is started on a parallel test component";
            this.returnType.checkComponentInternal(timestamp, typeSet, errorMessage);
        }
        return false;
    }

    public void analyzeExtensionAttributes(CompilationTimeStamp timestamp) {
        int i;
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        int size = realAttributes.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Qualifiers qualifiers;
            SingleWithAttribute attribute = realAttributes.get(i2);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            specifications.add(attribute.getAttributeSpecification());
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        int size2 = specifications.size();
        for (i = 0; i < size2; ++i) {
            AttributeSpecification specification = (AttributeSpecification)specifications.get(i);
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        size2 = attributes.size();
        for (i = 0; i < size2; ++i) {
            ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributes.get(i);
            if (!ExtensionAttribute.ExtensionAttribute_type.PROTOTYPE.equals((Object)extensionAttribute.getAttributeType())) continue;
            PrototypeAttribute realAttribute = (PrototypeAttribute)extensionAttribute;
            if (EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
                this.prototype = realAttribute.getPrototypeType();
                continue;
            }
            realAttribute.getLocation().reportSingularSemanticError("Duplicate attribute `prototype'");
        }
    }

    public void checkPrototype(CompilationTimeStamp timestamp) {
        if (EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
            return;
        }
        if (EncodingPrototype_type.CONVERT.equals((Object)this.prototype)) {
            if (this.formalParList.getNofParameters() == 1) {
                FormalParameter parameter = this.formalParList.getParameterByIndex(0);
                Assignment.Assignment_type assignmentType = parameter.getRealAssignmentType();
                if (Assignment.Assignment_type.A_PAR_VAL_IN.equals(assignmentType) || Assignment.Assignment_type.A_PAR_VAL.equals(assignmentType)) {
                    this.inputType = parameter.getType(timestamp);
                } else {
                    parameter.getLocation().reportSemanticError(MessageFormat.format("The parameter must be an `in'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), parameter.getAssignmentName()));
                }
            } else {
                this.formalParList.getLocation().reportSemanticError(MessageFormat.format("The function must have one parameter instead of {0} for attribute `prototype({1})''", this.formalParList.getNofParameters(), this.prototype.getName()));
            }
        } else if (this.formalParList.getNofParameters() == 2) {
            FormalParameter firstParameter = this.formalParList.getParameterByIndex(0);
            if (EncodingPrototype_type.SLIDING.equals((Object)this.prototype)) {
                if (Assignment.Assignment_type.A_PAR_VAL_INOUT.equals(firstParameter.getRealAssignmentType())) {
                    Type firstParameterType = firstParameter.getType(timestamp);
                    IType last = firstParameterType.getTypeRefdLast(timestamp);
                    if (last.getIsErroneous(timestamp)) {
                        this.inputType = firstParameterType;
                    } else {
                        switch (last.getTypetypeTtcn3()) {
                            case TYPE_OCTETSTRING: 
                            case TYPE_CHARSTRING: {
                                this.inputType = firstParameterType;
                                break;
                            }
                            default: {
                                firstParameter.getLocation().reportSemanticError(MessageFormat.format("The type of the first parameter must be `octetstring'' or `charstring'' for attribute `prototype({0})''", this.prototype.getName()));
                            }
                        }
                    }
                } else {
                    firstParameter.getLocation().reportSemanticError(MessageFormat.format("The first parameter must be an `inout'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), firstParameter.getAssignmentName()));
                }
            } else {
                Assignment.Assignment_type assignmentType = firstParameter.getRealAssignmentType();
                if (Assignment.Assignment_type.A_PAR_VAL_IN.equals(assignmentType) || Assignment.Assignment_type.A_PAR_VAL.equals(assignmentType)) {
                    this.inputType = firstParameter.getType(timestamp);
                } else {
                    firstParameter.getLocation().reportSemanticError(MessageFormat.format("The first parameter must be an `in'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), firstParameter.getAssignmentName()));
                }
            }
            FormalParameter secondParameter = this.formalParList.getParameterByIndex(1);
            if (Assignment.Assignment_type.A_PAR_VAL_OUT.equals(secondParameter.getRealAssignmentType())) {
                this.outputType = secondParameter.getType(timestamp);
            } else {
                secondParameter.getLocation().reportSemanticError(MessageFormat.format("The second parameter must be an `out'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), secondParameter.getAssignmentName()));
            }
        } else {
            this.formalParList.getLocation().reportSemanticError(MessageFormat.format("The function must have two parameters for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), this.formalParList.getNofParameters()));
        }
        if (EncodingPrototype_type.FAST.equals((Object)this.prototype)) {
            if (this.returnType != null) {
                this.returnType.getLocation().reportSemanticError(MessageFormat.format("The function cannot have return type for attribute `prototype({0})''", this.prototype.getName()));
            }
        } else if (this.returnType == null) {
            this.location.reportSemanticError(MessageFormat.format("The function must have a return type for attribute `prototype({0})''", this.prototype.getName()));
        } else {
            if (Assignment.Assignment_type.A_FUNCTION_RTEMP.equals(this.assignmentType)) {
                this.returnType.getLocation().reportSemanticError(MessageFormat.format("The function must return a value instead of a template for attribute `prototype({0})''", this.prototype.getName()));
            }
            if (EncodingPrototype_type.CONVERT.equals((Object)this.prototype)) {
                this.outputType = this.returnType;
            } else {
                IType last = this.returnType.getTypeRefdLast(timestamp);
                if (!last.getIsErroneous(timestamp) && !IType.Type_type.TYPE_INTEGER.equals((Object)last.getTypetypeTtcn3())) {
                    this.returnType.getLocation().reportSemanticError(MessageFormat.format("The return type of the function must be `integer'' instead of `{0}'' for attribute `prototype({1})''", this.returnType.getTypename(), this.prototype.getName()));
                }
            }
        }
        if (this.runsOnType != null && this.runsOnRef != null) {
            this.runsOnRef.getLocation().reportSemanticError(MessageFormat.format("The function cannot have `runs on'' clause for attribute `prototype({0})''", this.prototype.getName()));
        }
    }

    @Override
    public void postCheck() {
        Module module;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        super.postCheck();
        this.postCheckPrivateness();
        this.formalParList.postCheck();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            StringBuilder patternBuilder = new StringBuilder(this.identifier.getDisplayName());
            patternBuilder.append('(');
            this.formalParList.getAsProposalPart(patternBuilder);
            patternBuilder.append(')');
            propCollector.addTemplateProposal(this.identifier.getDisplayName(), new Template(this.getProposalDescription(), "", propCollector.getContextIdentifier(), patternBuilder.toString(), false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            super.addProposal(propCollector, i);
        } else if (subrefs.size() > i + 1 && this.returnType != null && ISubReference.Subreference_type.parameterisedSubReference.equals((Object)subrefs.get(i).getReferenceType()) && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.returnType.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        if (this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            if (subrefs.size() > i + 1 && this.returnType != null) {
                this.returnType.addDeclaration(declarationCollector, i + 1);
            } else {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public String getOutlineText() {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        StringBuilder text = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParList == null) {
            return text.toString();
        }
        text.append('(');
        for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
            FormalParameter parameter;
            if (i != 0) {
                text.append(", ");
            }
            if (Assignment.Assignment_type.A_PAR_TIMER.equals((parameter = this.formalParList.getParameterByIndex(i)).getRealAssignmentType())) {
                text.append("timer");
                continue;
            }
            Type type = parameter.getType(this.lastTimeChecked);
            if (type == null) {
                text.append("Unknown type");
                continue;
            }
            text.append(type.getTypename());
        }
        text.append(')');
        return text.toString();
    }

    @Override
    public TemplateRestriction.Restriction_type getTemplateRestriction() {
        return this.templateRestriction;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    this.removeBridge();
                    throw new ReParseException(result);
                }
            }
            if (this.formalParList != null) {
                if (enveloped) {
                    this.formalParList.updateSyntax(reparser, false);
                    reparser.updateLocation(this.formalParList.getLocation());
                } else if (reparser.envelopsDamage(this.formalParList.getLocation())) {
                    try {
                        this.formalParList.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.formalParList.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.runsOnRef != null) {
                if (enveloped) {
                    this.runsOnRef.updateSyntax(reparser, false);
                    reparser.updateLocation(this.runsOnRef.getLocation());
                } else if (reparser.envelopsDamage(this.runsOnRef.getLocation())) {
                    try {
                        this.runsOnRef.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.runsOnRef.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.returnType != null) {
                if (enveloped) {
                    this.returnType.updateSyntax(reparser, false);
                    reparser.updateLocation(this.returnType.getLocation());
                } else if (reparser.envelopsDamage(this.returnType.getLocation())) {
                    try {
                        this.returnType.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.returnType.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.block != null) {
                if (enveloped) {
                    this.block.updateSyntax(reparser, false);
                    reparser.updateLocation(this.block.getLocation());
                } else if (reparser.envelopsDamage(this.block.getLocation())) {
                    try {
                        this.block.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.block.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    try {
                        this.withAttributesPath.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.withAttributesPath.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (!enveloped) {
                this.removeBridge();
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.formalParList != null) {
            this.formalParList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParList.getLocation());
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.runsOnRef.getLocation());
        }
        if (this.returnType != null) {
            this.returnType.updateSyntax(reparser, false);
            reparser.updateLocation(this.returnType.getLocation());
        }
        if (this.block != null) {
            this.block.updateSyntax(reparser, false);
            reparser.updateLocation(this.block.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private void removeBridge() {
        if (this.bridgeScope != null) {
            this.bridgeScope.remove();
            this.bridgeScope = null;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParList != null) {
            this.formalParList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.returnType != null) {
            this.returnType.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.block != null) {
            this.block.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParList != null && !this.formalParList.accept(v)) {
            return false;
        }
        if (this.returnType != null && !this.returnType.accept(v)) {
            return false;
        }
        if (this.runsOnRef != null && !this.runsOnRef.accept(v)) {
            return false;
        }
        return this.block == null || this.block.accept(v);
    }

    public static enum EncodingPrototype_type {
        NONE("<no prototype>"),
        BACKTRACK("backtrack"),
        CONVERT("convert"),
        FAST("fast"),
        SLIDING("sliding");

        private String name;

        private EncodingPrototype_type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

