/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IIdentifierContainer;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class WithAttributesPath
implements ILocateableNode,
IIncrementallyUpdateable,
IIdentifierContainer,
IVisitableNode {
    private MultipleWithAttributes attributes;
    private WeakReference<WithAttributesPath> attributeParent;
    private CompilationTimeStamp lastTimeGlobalChecked;
    private CompilationTimeStamp lastTimeChecked;
    private CompilationTimeStamp lastTimeRealAttributesCalculated;
    private List<SingleWithAttribute> realAttributeCache = new ArrayList<SingleWithAttribute>();
    private boolean steppedOverEncode = false;

    public void setWithAttributes(MultipleWithAttributes attributes) {
        this.attributes = attributes;
    }

    public MultipleWithAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributeParent(WithAttributesPath parent) {
        this.attributeParent = new WeakReference<WithAttributesPath>(parent);
    }

    public WithAttributesPath getAttributeParent() {
        if (this.attributeParent == null) {
            return null;
        }
        return (WithAttributesPath)this.attributeParent.get();
    }

    @Override
    public Location getLocation() {
        if (this.attributes == null) {
            return NULL_Location.INSTANCE;
        }
        return new Location(this.attributes.getLocation());
    }

    @Override
    public void setLocation(Location location) {
    }

    public void checkGlobalAttributes(CompilationTimeStamp timestamp, boolean erroneousAllowed) {
        int i;
        SingleWithAttribute tempAttribute;
        if (this.lastTimeGlobalChecked != null && !this.lastTimeGlobalChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeGlobalChecked = timestamp;
        if (this.attributes == null) {
            return;
        }
        if (!erroneousAllowed) {
            int size = this.attributes.getNofElements();
            for (int i2 = 0; i2 < size; ++i2) {
                tempAttribute = this.attributes.getAttribute(i2);
                if (tempAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Erroneous_Attribute) continue;
                tempAttribute.getLocation().reportSemanticError("The `erroneous' attribute can be used only on template and constant definitions");
            }
        }
        boolean hasEncode = false;
        boolean hasOverrideVariant = false;
        boolean hasOverrideDisplay = false;
        boolean hasOverrideExtension = false;
        boolean hasOverrideOptional = false;
        block11: for (i = this.attributes.getNofElements() - 1; i >= 0; --i) {
            tempAttribute = this.attributes.getAttribute(i);
            switch (tempAttribute.getAttributeType()) {
                case Encode_Attribute: {
                    if (hasEncode) {
                        tempAttribute.getLocation().reportSemanticError("Only the last encode of the with statement will have effect");
                        continue block11;
                    }
                    hasEncode = true;
                    continue block11;
                }
                case Erroneous_Attribute: {
                    if (!tempAttribute.hasOverride()) continue block11;
                    tempAttribute.getLocation().reportSemanticError("Override cannot be used with erroneous");
                    continue block11;
                }
            }
        }
        int size = this.attributes.getNofElements();
        block12: for (i = 0; i < size; ++i) {
            tempAttribute = this.attributes.getAttribute(i);
            switch (tempAttribute.getAttributeType()) {
                case Variant_Attribute: {
                    if (hasOverrideVariant) {
                        tempAttribute.getLocation().reportSemanticWarning("Only the first override variant of the with statement will have effect");
                        continue block12;
                    }
                    if (!tempAttribute.hasOverride()) continue block12;
                    hasOverrideVariant = true;
                    continue block12;
                }
                case Display_Attribute: {
                    if (hasOverrideDisplay) {
                        tempAttribute.getLocation().reportSemanticWarning("Only the first override display of the with statement will have effect");
                        continue block12;
                    }
                    if (!tempAttribute.hasOverride()) continue block12;
                    hasOverrideDisplay = true;
                    continue block12;
                }
                case Extension_Attribute: {
                    if (hasOverrideExtension) {
                        tempAttribute.getLocation().reportSemanticWarning("Only the first override extension of the with statement will have effect");
                        continue block12;
                    }
                    if (!tempAttribute.hasOverride()) continue block12;
                    hasOverrideExtension = true;
                    continue block12;
                }
                case Optional_Attribute: {
                    AttributeSpecification attributeSpecification = tempAttribute.getAttributeSpecification();
                    String tempSpecification = attributeSpecification.getSpecification();
                    if (!"implicit omit".equals(tempSpecification) && !"explicit omit".equals(tempSpecification)) {
                        String message = MessageFormat.format("The specification of an optional attribute can only be \"implicit omit\" or \"explicit omit\", not \"{0}\"", tempSpecification);
                        attributeSpecification.getLocation().reportSemanticError(message);
                    }
                    if (hasOverrideOptional) {
                        tempAttribute.getLocation().reportSemanticWarning("Only the first override optional of the with statement will have effect");
                        continue block12;
                    }
                    if (!tempAttribute.hasOverride()) continue block12;
                    hasOverrideOptional = true;
                    continue block12;
                }
            }
        }
    }

    public void checkAttributes(CompilationTimeStamp timestamp, IType.Type_type type) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.attributes == null) {
            return;
        }
        switch (type) {
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SET: 
            case TYPE_ASN1_SET: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: {
                return;
            }
        }
        int size = this.attributes.getNofElements();
        for (int i = 0; i < size; ++i) {
            SingleWithAttribute tempAttribute = this.attributes.getAttribute(i);
            Qualifiers qualifiers = tempAttribute.getQualifiers();
            if (qualifiers == null || qualifiers.getNofQualifiers() == 0) continue;
            tempAttribute.getLocation().reportSemanticError("Field qualifiers are only allowed for record, set and union types");
        }
    }

    public void checkAttributes(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.attributes == null) {
            return;
        }
        int size = this.attributes.getNofElements();
        for (int i = 0; i < size; ++i) {
            SingleWithAttribute tempAttribute = this.attributes.getAttribute(i);
            Qualifiers qualifiers = tempAttribute.getQualifiers();
            if (qualifiers == null || qualifiers.getNofQualifiers() == 0) continue;
            tempAttribute.getLocation().reportSemanticError("Field qualifiers are only allowed for record, set and union types");
        }
    }

    private boolean hasSteppedOverEncode() {
        return this.steppedOverEncode;
    }

    private List<SingleWithAttribute> qualifierlessAttributeProcessor(CompilationTimeStamp timestamp) {
        int i;
        Qualifiers actualQualifiers;
        SingleWithAttribute actualSingleAttribute;
        if (this.lastTimeRealAttributesCalculated != null && !this.lastTimeRealAttributesCalculated.isLess(timestamp)) {
            return this.realAttributeCache;
        }
        this.lastTimeRealAttributesCalculated = timestamp;
        this.realAttributeCache = new ArrayList<SingleWithAttribute>();
        if (this.attributeParent != null) {
            WithAttributesPath parentPath = (WithAttributesPath)this.attributeParent.get();
            if (parentPath != null) {
                List<SingleWithAttribute> temp = parentPath.qualifierlessAttributeProcessor(timestamp);
                this.realAttributeCache.addAll(temp);
                this.steppedOverEncode = parentPath.hasSteppedOverEncode();
            } else {
                this.steppedOverEncode = false;
            }
        } else {
            this.steppedOverEncode = false;
        }
        if (this.attributes == null || this.attributes.getNofElements() == 0) {
            return this.realAttributeCache;
        }
        int selfEncodeIndex = -1;
        boolean selfHasVariant = false;
        int size = this.attributes.getNofElements();
        block22: for (int i2 = 0; i2 < size; ++i2) {
            actualSingleAttribute = this.attributes.getAttribute(i2);
            actualQualifiers = actualSingleAttribute.getQualifiers();
            if (actualQualifiers != null && actualQualifiers.getNofQualifiers() != 0) continue;
            switch (actualSingleAttribute.getAttributeType()) {
                case Encode_Attribute: {
                    selfEncodeIndex = i2;
                    continue block22;
                }
                case Variant_Attribute: {
                    selfHasVariant = true;
                    continue block22;
                }
            }
        }
        boolean parentHasEncode = false;
        boolean parentHasOverrideEncode = false;
        boolean newLocalEncodeContext = false;
        boolean parentHasOverrideVariant = false;
        boolean parentHasOverrideDisplay = false;
        boolean parentHasOverrideExtension = false;
        boolean parentHasOverrideOptional = false;
        int size2 = this.realAttributeCache.size();
        block23: for (i = 0; i < size2; ++i) {
            actualSingleAttribute = this.realAttributeCache.get(i);
            switch (actualSingleAttribute.getAttributeType()) {
                case Encode_Attribute: {
                    String selfSpecification;
                    parentHasEncode = true;
                    parentHasOverrideEncode |= actualSingleAttribute.hasOverride();
                    if (selfEncodeIndex == -1) continue block23;
                    String actualSpecification = actualSingleAttribute.getAttributeSpecification().getSpecification();
                    newLocalEncodeContext = !actualSpecification.equals(selfSpecification = this.attributes.getAttribute(selfEncodeIndex).getAttributeSpecification().getSpecification());
                    continue block23;
                }
                case Variant_Attribute: {
                    parentHasOverrideVariant |= actualSingleAttribute.hasOverride();
                    continue block23;
                }
                case Display_Attribute: {
                    parentHasOverrideDisplay |= actualSingleAttribute.hasOverride();
                    continue block23;
                }
                case Extension_Attribute: {
                    parentHasOverrideExtension |= actualSingleAttribute.hasOverride();
                    continue block23;
                }
                case Optional_Attribute: {
                    parentHasOverrideOptional |= actualSingleAttribute.hasOverride();
                    continue block23;
                }
            }
        }
        if (!parentHasEncode && selfEncodeIndex == -1 && selfHasVariant) {
            size2 = this.attributes.getNofElements();
            for (i = 0; i < size2; ++i) {
                actualSingleAttribute = this.attributes.getAttribute(i);
                if (!SingleWithAttribute.Attribute_Type.Variant_Attribute.equals((Object)actualSingleAttribute.getAttributeType())) continue;
                actualSingleAttribute.getLocation().reportSemanticWarning("This variant does not belong to an encode");
            }
        }
        block25: for (i = this.realAttributeCache.size() - 1; i >= 0; --i) {
            switch (this.realAttributeCache.get(i).getAttributeType()) {
                case Encode_Attribute: {
                    if (selfEncodeIndex == -1 || parentHasOverrideEncode || !newLocalEncodeContext) continue block25;
                    this.realAttributeCache.remove(i);
                    continue block25;
                }
                case Variant_Attribute: {
                    if (selfEncodeIndex == -1 || !newLocalEncodeContext || (!parentHasEncode || parentHasOverrideEncode) && parentHasEncode) continue block25;
                    this.realAttributeCache.remove(i);
                    continue block25;
                }
            }
        }
        size2 = this.attributes.getNofElements();
        block26: for (i = 0; i < size2; ++i) {
            actualSingleAttribute = this.attributes.getAttribute(i);
            actualQualifiers = actualSingleAttribute.getQualifiers();
            if (actualQualifiers != null && actualQualifiers.getNofQualifiers() != 0) continue;
            switch (actualSingleAttribute.getAttributeType()) {
                case Encode_Attribute: {
                    if (parentHasEncode && !parentHasOverrideEncode && newLocalEncodeContext || !parentHasEncode) {
                        this.realAttributeCache.add(0, actualSingleAttribute);
                        this.steppedOverEncode = false;
                        continue block26;
                    }
                    if (newLocalEncodeContext) {
                        this.steppedOverEncode = true;
                        continue block26;
                    }
                    this.steppedOverEncode = false;
                    continue block26;
                }
                case Variant_Attribute: {
                    boolean localEncodeOverwritesParent;
                    boolean parentHasNothing = !parentHasEncode && !parentHasOverrideVariant;
                    boolean noParentButLocalEncode = !parentHasEncode && selfEncodeIndex != -1;
                    boolean newLocalEncode = parentHasEncode && selfEncodeIndex != -1 && !this.steppedOverEncode && !parentHasOverrideVariant;
                    boolean bl = localEncodeOverwritesParent = parentHasEncode && selfEncodeIndex != -1 && !parentHasOverrideEncode && !parentHasOverrideVariant;
                    if (!parentHasNothing && !noParentButLocalEncode && !newLocalEncode && !localEncodeOverwritesParent) continue block26;
                    this.realAttributeCache.add(actualSingleAttribute);
                    continue block26;
                }
                case Display_Attribute: {
                    if (parentHasOverrideDisplay) continue block26;
                    this.realAttributeCache.add(actualSingleAttribute);
                    continue block26;
                }
                case Extension_Attribute: {
                    if (parentHasOverrideExtension) continue block26;
                    this.realAttributeCache.add(actualSingleAttribute);
                    continue block26;
                }
                case Optional_Attribute: {
                    if (parentHasOverrideOptional) continue block26;
                    this.realAttributeCache.add(actualSingleAttribute);
                    continue block26;
                }
            }
        }
        return this.realAttributeCache;
    }

    public List<SingleWithAttribute> getRealAttributes(CompilationTimeStamp timestamp) {
        return this.qualifierlessAttributeProcessor(timestamp);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.attributes != null) {
            this.attributes.updateSyntax(reparser, false);
            reparser.updateLocation(this.attributes.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.attributes != null && !this.attributes.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }
}

