/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.EncodeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorList;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class EncodeTypeMappingTarget
extends TypeMappingTarget {
    private static final String FULLNAMEPART1 = ".<target_type>";
    private static final String FULLNAMEPART2 = ".<errorbehavior>";
    private final Type targetType;
    private final EncodeAttribute encodeAttribute;
    private final ErrorBehaviorAttribute errorBehaviorAttribute;

    public EncodeTypeMappingTarget(Type targetType, ExtensionAttribute encodeAttribute, ErrorBehaviorAttribute errorBehaviorAttribute) {
        this.targetType = targetType;
        this.encodeAttribute = encodeAttribute instanceof EncodeAttribute ? (EncodeAttribute)encodeAttribute : null;
        this.errorBehaviorAttribute = errorBehaviorAttribute;
    }

    @Override
    public TypeMappingTarget.TypeMapping_type getTypeMappingType() {
        return TypeMappingTarget.TypeMapping_type.ENCODE;
    }

    @Override
    public String getMappingName() {
        return "encode";
    }

    @Override
    public Type getTargetType() {
        return this.targetType;
    }

    public IType.Encoding_type getCodingType() {
        if (this.encodeAttribute != null) {
            return this.encodeAttribute.getEncodingType();
        }
        return IType.Encoding_type.UNDEFINED;
    }

    public boolean hasCodingOptions() {
        if (this.encodeAttribute != null) {
            return this.encodeAttribute.getOptions() != null;
        }
        return false;
    }

    public String getCodingOptions() {
        if (this.encodeAttribute != null) {
            return this.encodeAttribute.getOptions();
        }
        return "UNDEFINED";
    }

    public ErrorBehaviorList getErrrorBehaviorList() {
        return this.errorBehaviorAttribute.getErrrorBehaviorList();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.targetType == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.errorBehaviorAttribute == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.targetType != null) {
            this.targetType.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Type source) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.targetType != null) {
            this.targetType.check(timestamp);
        }
        if (this.errorBehaviorAttribute != null) {
            this.errorBehaviorAttribute.getErrrorBehaviorList().check(timestamp);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.targetType != null) {
            this.targetType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.targetType != null && !this.targetType.accept(v)) {
            return false;
        }
        if (this.encodeAttribute != null && !this.encodeAttribute.accept(v)) {
            return false;
        }
        return this.errorBehaviorAttribute == null || this.errorBehaviorAttribute.accept(v);
    }
}

