/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class Assignment
extends ASTNode
implements IOutlineElement,
ILocateableNode,
IReferenceChainElement,
IReferencingElement {
    protected static final String GLOBALLY_UNUSED = "The {0} seems to be never used globally";
    protected static final String LOCALLY_UNUSED = "The {0} seems to be never used locally";
    protected Identifier identifier;
    protected Location location;
    protected Group parentGroup;
    protected CompilationTimeStamp lastTimeChecked;
    protected boolean isErroneous;
    protected boolean isUsed;
    private boolean canBeCheckRoot = true;

    public Assignment(Identifier identifier) {
        this.identifier = identifier;
        this.isErroneous = false;
        this.isUsed = false;
        this.location = NULL_Location.INSTANCE;
    }

    public final CompilationTimeStamp getLastTimeChecked() {
        return this.lastTimeChecked;
    }

    public final boolean isCheckRoot() {
        return this.canBeCheckRoot;
    }

    public final void checkRoot() {
        this.canBeCheckRoot = true;
    }

    public final void notCheckRoot() {
        this.canBeCheckRoot = false;
    }

    public final boolean getIsErroneous() {
        return this.isErroneous;
    }

    @Override
    public final void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    @Override
    public final Location getChainLocation() {
        return this.location;
    }

    @Override
    public final String chainedDescription() {
        return this.getFullName();
    }

    public final void setUsed() {
        this.isUsed = true;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public boolean isLocal() {
        return false;
    }

    public final void setParentGroup(Group parentGroup) {
        this.parentGroup = parentGroup;
    }

    public final Group getParentGroup() {
        return this.parentGroup;
    }

    public abstract Assignment_type getAssignmentType();

    @Override
    public final Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public Object[] getOutlineChildren() {
        return new Object[0];
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    @Override
    public int category() {
        return this.getAssignmentType().ordinal() * IType.Type_type.values().length;
    }

    public abstract String getAssignmentName();

    public String getProposalDescription() {
        return "basic assignment";
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder(this.getAssignmentName());
        builder.append(" `").append(this.getFullName()).append('\'');
        return builder.toString();
    }

    public ISetting getSetting(CompilationTimeStamp timestamp) {
        return null;
    }

    public IType getType(CompilationTimeStamp timestamp) {
        return null;
    }

    public abstract void check(CompilationTimeStamp var1);

    public abstract void check(CompilationTimeStamp var1, IReferenceChain var2);

    public void postCheck() {
        if (!this.isUsed) {
            this.location.reportConfigurableSemanticProblem(Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnusedGlobalDefinition", "warning", null), MessageFormat.format(GLOBALLY_UNUSED, this.getDescription()));
        }
    }

    public abstract void addProposal(ProposalCollector var1, int var2);

    public abstract void addDeclaration(DeclarationCollector var1, int var2);

    public abstract boolean shouldMarkOccurrences();

    @Override
    public Declaration getDeclaration() {
        return Declaration.createInstance(this);
    }

    public static enum Assignment_type {
        A_TYPE,
        A_ALTSTEP,
        A_CONST,
        A_EXT_CONST,
        A_FUNCTION,
        A_FUNCTION_RVAL,
        A_FUNCTION_RTEMP,
        A_EXT_FUNCTION,
        A_EXT_FUNCTION_RVAL,
        A_EXT_FUNCTION_RTEMP,
        A_MODULEPAR,
        A_MODULEPAR_TEMPLATE,
        A_PORT,
        A_VAR,
        A_TEMPLATE,
        A_VAR_TEMPLATE,
        A_TIMER,
        A_TESTCASE,
        A_PAR_VAL,
        A_PAR_VAL_IN,
        A_PAR_VAL_OUT,
        A_PAR_VAL_INOUT,
        A_PAR_TEMP_IN,
        A_PAR_TEMP_OUT,
        A_PAR_TEMP_INOUT,
        A_PAR_TIMER,
        A_PAR_PORT,
        A_UNDEF,
        A_VS,
        A_OC,
        A_OBJECT,
        A_OS;


        public final boolean equals(Assignment_type other) {
            if (this == A_PAR_VAL || this == A_PAR_VAL_IN) {
                return other == A_PAR_VAL || other == A_PAR_VAL_IN;
            }
            return this == other;
        }
    }
}

