/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.OmitValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Set_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ASN1_Set_Type
extends ASN1_Set_Seq_Choice_BaseType {
    private static final String NONEMPTYEXPECTED = "A non-empty value was expected for type `{0}''";
    private static final String VALUELISTNOTATIONERRORASN1 = "Value list notation cannot be used for SET type `{0}''";
    private static final String SETVALUEXPECTEDASN1 = "SET value was expected for type `{0}''";
    private static final String NONEXISTENTFIELDASN1 = "Reference to a non-existent component `{0}'' of SET type `{1}''";
    private static final String DUPLICATEFIELDFIRSTASN1 = "Component `{0}'' is already given here";
    private static final String DUPLICATEFIELDAGAINASN1 = "Duplicated SET component `{0}''";
    private static final String MISSINGFIELDASN1 = "Mandatory component `{0}'' is missing from SET value";
    private static final String VALUELISTNOTATIONERRORTTCN3 = "Value list notation cannot be used for set type `{0}''";
    private static final String SETVALUEXPECTEDTTCN3 = "set value was expected for type `{0}''";
    private static final String NONEXISTENTFIELDTTCN3 = "Reference to a non-existent field `{0}'' in set value for type `{1}''";
    private static final String DUPLICATEFIELDFIRSTTTCN3 = "Field `{0}'' is already given here";
    private static final String DUPLICATEFIELDAGAINTTCN3 = "Duplicated set field `{0}''";
    private static final String MISSINGFIELDTTCN3 = "Field `{0}'' is missing from set value";
    private static final String VALUELISTNOTATIONNOTALLOWED = "Value list notation is not allowed for set type `{0}''";
    private static final String NONEMPTYSETTEMPLATEEXPECTED = "A non-empty set template was expected for type `{0}''";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for record type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for record type `{0}''";
    private static final String DUPLICATETEMPLATEFIELDFIRST = "Duplicate field `{0}'' in template";
    private static final String DUPLICATETEMPLATEFIELDAGAIN = "Field `{0}'' is already given here";
    private static final String NONEXISTENTTEMPLATEFIELDREFERENCE = "Reference to non-existing field `{0}'' in record template for type `{1}''";
    private static final String MISSINGTEMPLATEFIELD = "Field `{0}'' is missing from template for record type `{1}''";
    private static final String NOFFIELDSDONTMATCH = "The number of fields in set/SET types must be the same";
    private static final String BADOPTIONALITY = "The optionality of fields in set/SET types must be the same";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";
    private CompilationTimeStamp trCompsofTimestamp;
    private static boolean defaultAsOptional = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.defaultAsOptional", false, null);
    private static boolean strictConstantCheckingSeverity;

    public ASN1_Set_Type(Block aBlock) {
        this.mBlock = aBlock;
    }

    @Override
    public IASN1Type newInstance() {
        return new ASN1_Set_Type(this.mBlock);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ASN1_SET;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_SET;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.components) {
            this.components.setMyScope(scope);
        }
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_SET: {
                ASN1_Set_Type tempType = (ASN1_Set_Type)temp;
                if (this == tempType) {
                    return true;
                }
                if (this.getNofComponents(timestamp) != tempType.getNofComponents(timestamp)) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents(timestamp);
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    CompField tempTypeCompField = tempType.getComponentByIndex(i);
                    IType compFieldType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCompFieldType = tempTypeCompField.getType().getTypeRefdLast(timestamp);
                    if (cf.isOptional() != tempTypeCompField.isOptional()) {
                        String compFieldName = cf.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName);
                        info.appendOp2Ref("." + tempTypeCompFieldName);
                        info.setOp1Type(compFieldType);
                        info.setOp2Type(tempTypeCompFieldType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(tempTypeCompFieldType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, tempTypeCompFieldType, false);
                    if (!(compFieldType.equals(tempTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, tempTypeCompFieldType, infoTemp, lChain, rChain))) {
                        String compFieldName = cf.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCompFieldName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SET: {
                TTCN3_Set_Type tempType = (TTCN3_Set_Type)temp;
                if (this.getNofComponents(timestamp) != tempType.getNofComponents()) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents(timestamp);
                for (int i = 0; i < size; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    CompField tempTypeCompField = tempType.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCompFieldType = tempTypeCompField.getType().getTypeRefdLast(timestamp);
                    if (compField.isOptional() != tempTypeCompField.isOptional()) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName);
                        info.appendOp2Ref("." + tempTypeCompFieldName);
                        info.setOp1Type(compFieldType);
                        info.setOp2Type(tempTypeCompFieldType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(tempTypeCompFieldType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, tempTypeCompFieldType, false);
                    if (!(compFieldType.equals(tempTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, tempTypeCompFieldType, infoTemp, lChain, rChain))) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCompFieldName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SET_OF: {
                SetOf_Type tempType = (SetOf_Type)temp;
                if (!tempType.isSubtypeCompatible(timestamp, this)) {
                    info.setErrorStr("Incompatible set of/SET OF subtypes");
                    return false;
                }
                int nofComps = this.getNofComponents(timestamp);
                if (nofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < nofComps; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType temporalTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(temporalTypeOfType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, temporalTypeOfType, false);
                    if (!(compFieldType.equals(temporalTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, temporalTypeOfType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref("." + compField.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                        if (infoTemp.getOp2RefStr().length() > 0) {
                            info.appendOp2Ref("[]");
                        }
                        info.appendOp2Ref(infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public String getOutlineIcon() {
        return "set.gif";
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("set");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.components == null) {
            return;
        }
        if (referenceChain.add(this)) {
            int size = this.components.getNofComps();
            for (int i = 0; i < size; ++i) {
                CompField field = this.components.getCompByIndex(i);
                Type t = field.getType();
                if (field.isOptional() || t == null) continue;
                referenceChain.markState();
                t.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.components != null && this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            this.lastTimeChecked = timestamp;
            return;
        }
        this.isErroneous = false;
        if (this.components == null) {
            this.parseBlockSet();
        }
        if (this.isErroneous || this.components == null) {
            return;
        }
        this.trCompsof(timestamp, null);
        this.components.check(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                if (last.isAsn()) {
                    this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SEQUENCEOF_VALUE: {
                if (((SequenceOf_Value)last).isIndexed()) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Indexed assignment notation cannot be used for SET type `{0}''", this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                SequenceOf_Value temporalValue = (SequenceOf_Value)last;
                if (temporalValue.getNofComponents() == 0) {
                    if (this.getNofComponents(timestamp) == 0) {
                        last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                        break;
                    }
                    value.getLocation().reportSemanticError(MessageFormat.format(NONEMPTYEXPECTED, this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                value.getLocation().reportSemanticError(MessageFormat.format(last.isAsn() ? VALUELISTNOTATIONERRORASN1 : VALUELISTNOTATIONERRORTTCN3, this.getFullName()));
                value.setIsErroneous(true);
                break;
            }
            case SET_VALUE: {
                if (last.isAsn()) {
                    this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                this.checkThisValueSet(timestamp, (Set_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(last.isAsn() ? SETVALUEXPECTEDASN1 : SETVALUEXPECTEDTTCN3, this.getFullName()));
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    private void checkThisValueSet(CompilationTimeStamp timestamp, Set_Value value, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        value.removeGeneratedValues();
        boolean isAsn = value.isAsn();
        int nofValueComponents = value.getNofComponents();
        for (int i = 0; i < nofValueComponents; ++i) {
            NamedValue namedValue = value.getSequenceValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!this.hasComponentWithName(valueId)) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? NONEXISTENTFIELDASN1 : NONEXISTENTFIELDTTCN3, namedValue.getName().getDisplayName(), this.getTypename()));
                continue;
            }
            if (componentMap.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? DUPLICATEFIELDAGAINASN1 : DUPLICATEFIELDAGAINTTCN3, valueId.getDisplayName()));
                ((NamedValue)componentMap.get(valueId.getName())).getLocation().reportSingularSemanticError(MessageFormat.format(isAsn ? DUPLICATEFIELDFIRSTASN1 : "Field `{0}'' is already given here", valueId.getDisplayName()));
            } else {
                componentMap.put(valueId.getName(), namedValue);
            }
            CompField componentField = this.getComponentByName(valueId);
            Type type = componentField.getType();
            IValue componentValue = namedValue.getValue();
            if (componentValue == null) continue;
            componentValue.setMyGovernor(type);
            IValue temporalValue = type.checkThisValueRef(timestamp, componentValue);
            boolean isOptional = componentField.isOptional();
            if (!isOptional && componentField.hasDefault() && defaultAsOptional) {
                isOptional = true;
            }
            type.checkThisValue(timestamp, temporalValue, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, isOptional, true, implicitOmit, strElem));
        }
        if (!incompleteAllowed || strictConstantCheckingSeverity) {
            int nofTypeComponents = this.getNofComponents(timestamp);
            for (int i = 0; i < nofTypeComponents; ++i) {
                CompField field = this.getComponentByIndex(i);
                Identifier id = field.getIdentifier();
                if (componentMap.containsKey(id.getName())) continue;
                if (field.isOptional() && implicitOmit) {
                    value.addNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_TTCN, id.getDisplayName()), new Omit_Value(), false));
                    continue;
                }
                value.getLocation().reportSemanticError(MessageFormat.format(isAsn ? MISSINGFIELDASN1 : MISSINGFIELDTTCN3, id.getDisplayName()));
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case TEMPLATE_LIST: {
                if (((Template_List)template).getNofTemplates() > 0) {
                    template.getLocation().reportSemanticError(MessageFormat.format(VALUELISTNOTATIONNOTALLOWED, this.getFullName()));
                    break;
                }
                if (this.getNofComponents(timestamp) > 0) {
                    template.getLocation().reportSemanticError(MessageFormat.format(NONEMPTYSETTEMPLATEEXPECTED, this.getFullName()));
                    break;
                }
                ITTCN3Template transformed = template.setTemplatetype(timestamp, ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST);
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)transformed, isModified, implicitOmit);
                break;
            }
            case NAMED_TEMPLATE_LIST: {
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)template, isModified, implicitOmit);
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
    }

    private void checkThisNamedTemplateList(CompilationTimeStamp timestamp, Named_Template_List templateList, boolean isModified, boolean implicitOmit) {
        int i;
        templateList.removeGeneratedValues();
        HashMap<String, NamedTemplate> componentMap = new HashMap<String, NamedTemplate>();
        int nofTypeComponents = this.getNofComponents(timestamp);
        int nofTemplateComponents = templateList.getNofTemplates();
        for (i = 0; i < nofTemplateComponents; ++i) {
            NamedTemplate namedTemplate = templateList.getTemplateByIndex(i);
            Identifier identifier = namedTemplate.getName();
            String templateName = identifier.getName();
            if (this.hasComponentWithName(identifier)) {
                if (componentMap.containsKey(templateName)) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format(DUPLICATETEMPLATEFIELDFIRST, identifier.getDisplayName()));
                    ((NamedTemplate)componentMap.get(templateName)).getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is already given here", identifier.getDisplayName()));
                } else {
                    componentMap.put(templateName, namedTemplate);
                }
                CompField componentField = this.getComponentByName(identifier);
                Type type = componentField.getType();
                if (type == null || type.getIsErroneous(timestamp)) continue;
                ITTCN3Template componentTemplate = namedTemplate.getTemplate();
                componentTemplate.setMyGovernor(type);
                componentTemplate = type.checkThisTemplateRef(timestamp, componentTemplate);
                boolean isOptional = componentField.isOptional();
                if (!isOptional && componentField.hasDefault() && defaultAsOptional) {
                    isOptional = true;
                }
                componentTemplate.checkThisTemplateGeneric(timestamp, type, isModified, isOptional, isOptional, true, implicitOmit);
                continue;
            }
            namedTemplate.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTTEMPLATEFIELDREFERENCE, identifier.getDisplayName(), this.getTypename()));
        }
        if (!isModified && strictConstantCheckingSeverity) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier identifier = this.getComponentIdentifierByIndex(i);
                if (componentMap.containsKey(identifier.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    templateList.addNamedValue(new NamedTemplate(new Identifier(Identifier.Identifier_type.ID_TTCN, identifier.getDisplayName()), new OmitValue_Template(), false));
                    continue;
                }
                templateList.getLocation().reportSemanticError(MessageFormat.format(MISSINGTEMPLATEFIELD, identifier.getDisplayName(), this.getTypename()));
            }
        }
    }

    private void parseBlockSet() {
        if (null == this.mBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return;
        }
        this.components = parser.pr_special_ComponentTypeLists().list;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            this.components = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (this.components == null) {
            this.isErroneous = true;
            return;
        }
        this.components.setFullNameParent(this);
        this.components.setMyScope(this.getMyScope());
        this.components.setMyType(this);
    }

    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.trCompsofTimestamp != null && !this.trCompsofTimestamp.isLess(timestamp)) {
            return;
        }
        if (referenceChain != null) {
            this.components.trCompsof(timestamp, referenceChain, false);
        } else {
            ReferenceChain temporalReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            this.components.trCompsof(timestamp, temporalReferenceChain, false);
            temporalReferenceChain.release();
        }
        this.trCompsofTimestamp = timestamp;
        this.components.trCompsof(timestamp, null, true);
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                if (interruptIfOptional && compField.isOptional()) {
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return compField.getType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return false;
                }
                int fieldIndex = this.components.components.indexOf(compField);
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                subrefsArray.add(fieldIndex);
                typeArray.add(this);
                return fieldType.getSubrefsAsArray(timestamp, reference, actualSubReference + 1, subrefsArray, typeArray);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return false;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return false;
    }

    static {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.defaultAsOptional".equals(property)) {
                        defaultAsOptional = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.defaultAsOptional", false, null);
                    }
                }
            });
        }
        strictConstantCheckingSeverity = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", false, null);
        activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.reportStrictConstants".equals(property)) {
                        strictConstantCheckingSeverity = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", false, null);
                    }
                }
            });
        }
    }
}

