/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser.media;

import com.steadystate.css.dom.Property;
import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.format.CSSFormatable;
import com.steadystate.css.parser.LocatableImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaQuery
extends LocatableImpl
implements CSSFormatable,
Serializable {
    private static final long serialVersionUID = 456776383828897471L;
    private String media_;
    private List<Property> properties_;
    private boolean isOnly_;
    private boolean isNot_;

    public MediaQuery(String media) {
        this(media, false, false);
    }

    public MediaQuery(String media, boolean isOnly, boolean isNot) {
        this.setMedia(media);
        this.properties_ = new ArrayList<Property>(10);
        this.isOnly_ = isOnly;
        this.isNot_ = isNot;
    }

    public String getMedia() {
        return this.media_;
    }

    public void setMedia(String media) {
        this.media_ = media;
    }

    public List<Property> getProperties() {
        return this.properties_;
    }

    public void addMediaProperty(Property mp) {
        this.properties_.add(mp);
    }

    public boolean isOnly() {
        return this.isOnly_;
    }

    public boolean isNot() {
        return this.isNot_;
    }

    @Override
    public String getCssText(CSSFormat format) {
        StringBuilder sb = new StringBuilder();
        if (this.isOnly_) {
            sb.append("only ");
        }
        if (this.isNot_) {
            sb.append("not ");
        }
        sb.append(this.getMedia());
        for (Property prop : this.properties_) {
            sb.append(" and (").append(prop.getCssText(format)).append(')');
        }
        return sb.toString();
    }

    public String toString() {
        return this.getCssText(null);
    }
}

