/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPBind;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPConnection;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPConstraints;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPRebind;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPSearchConstraints
extends LDAPConstraints {
    private static final long serialVersionUID = -487551577157782460L;
    private int batchSize = 1;
    private int derefPolicy = LDAPConnection.DEREF_NEVER;
    private int sizeLimit = 1000;
    private int timeLimit = 0;

    public LDAPSearchConstraints() {
    }

    public LDAPSearchConstraints(int msLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPRebind rebindProc, int hopLimit) {
        this();
        this.derefPolicy = dereference;
        this.sizeLimit = maxResults;
        this.batchSize = batchSize;
        this.setTimeLimit(msLimit);
        this.setReferrals(doReferrals);
        this.setRebindProc(rebindProc);
        this.setHopLimit(hopLimit);
    }

    public LDAPSearchConstraints(int msLimit, int timeLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPRebind rebindProc, int hopLimit) {
        this();
        this.derefPolicy = dereference;
        this.sizeLimit = maxResults;
        this.timeLimit = timeLimit;
        this.batchSize = batchSize;
        this.setTimeLimit(msLimit);
        this.setReferrals(doReferrals);
        this.setRebindProc(rebindProc);
        this.setHopLimit(hopLimit);
    }

    public LDAPSearchConstraints(int msLimit, int timeLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPBind bindProc, int hopLimit) {
        this();
        this.derefPolicy = dereference;
        this.sizeLimit = maxResults;
        this.timeLimit = timeLimit;
        this.batchSize = batchSize;
        this.setTimeLimit(msLimit);
        this.setReferrals(doReferrals);
        this.setBindProc(bindProc);
        this.setHopLimit(hopLimit);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize < 1 ? 1 : batchSize;
    }

    public int getDereference() {
        return this.derefPolicy;
    }

    public void setDereference(int dereference) {
        this.derefPolicy = dereference;
    }

    public int getMaxResults() {
        return this.sizeLimit;
    }

    public void setMaxResults(int maxResults) {
        this.sizeLimit = maxResults < 0 ? 0 : maxResults;
    }

    public int getServerTimeLimit() {
        return this.timeLimit;
    }

    public void setServerTimeLimit(int limit) {
        this.timeLimit = limit < 0 ? 0 : limit;
    }

    @Override
    public LDAPSearchConstraints duplicate() {
        LDAPSearchConstraints c = new LDAPSearchConstraints();
        c.batchSize = this.batchSize;
        c.derefPolicy = this.derefPolicy;
        c.sizeLimit = this.sizeLimit;
        c.timeLimit = this.timeLimit;
        c.setBindProc(this.getBindProc());
        c.setClientControls(this.getClientControls());
        c.setReferrals(this.getReferrals());
        c.setHopLimit(this.getHopLimit());
        c.setRebindProc(this.getRebindProc());
        c.setServerControls(this.getServerControls());
        c.setTimeLimit(this.getTimeLimit());
        return c;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("LDAPSearchConstraints(constraints=");
        buffer.append(super.toString());
        buffer.append(", batchSize=");
        buffer.append(this.batchSize);
        buffer.append(", derefPolicy=");
        buffer.append(this.derefPolicy);
        buffer.append(", maxResults=");
        buffer.append(this.sizeLimit);
        buffer.append(", serverTimeLimit=");
        buffer.append(this.timeLimit);
        buffer.append(')');
        return buffer.toString();
    }
}

