/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool.jthelp;

import com.sun.javatest.ProductInfo;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import com.sun.javatest.tool.jthelp.HelpBroker;
import com.sun.javatest.tool.jthelp.HelpSet;
import com.sun.javatest.tool.jthelp.JTHelpProgressBar;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;

public class JTHelpBroker
implements HelpBroker {
    private static final String HELP_DIR_NAME = "jthelp";
    private static final String HELP_VERSION_NAME = "version";
    private static final String HELP_FILE_PREFIX = "/com/sun/javatest/help/default/";
    private static final String HELP_FILE_NAME = "map.xml";
    private HashMap<String, String> helpMap;

    public JTHelpBroker() {
        this(HelpBroker.class.getResource("/com/sun/javatest/help/default/map.xml"));
    }

    private JTHelpBroker(URL url) {
        this.helpMap = HelpSet.readHelpMap(url);
    }

    @Override
    public void enableHelpKey(final Component component, String helpID) {
        if (component instanceof JComponent) {
            KeyStroke keystroke = KeyStroke.getKeyStroke(112, 0, false);
            ((JComponent)component).registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTHelpBroker.this.displayCurrentID(ContextHelpManager.getHelpIDString(component));
                }
            }, keystroke, 1);
        }
        ContextHelpManager.setHelpIDString(component, helpID);
    }

    private boolean isHelpUpToDate() {
        File helpDir = new File(Preferences.getPrefsDir(), HELP_DIR_NAME);
        if (!helpDir.exists()) {
            return false;
        }
        File helpVersion = new File(helpDir, HELP_VERSION_NAME);
        try {
            Scanner scanner = new Scanner(helpVersion, StandardCharsets.UTF_8.name());
            String version = scanner.nextLine();
            if (version == null || !version.equals(ProductInfo.getVersion() + ProductInfo.getBuildNumber())) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void unpackHelpIfNeeded() {
        if (this.isHelpUpToDate()) {
            return;
        }
        JTHelpProgressBar jtHelpProgressBar = new JTHelpProgressBar(new ProgressTask());
        jtHelpProgressBar.createAndShowGUI();
    }

    @Override
    public void displayCurrentID(String helpID) {
        this.unpackHelpIfNeeded();
        try {
            File helpDir = new File(Preferences.getPrefsDir(), HELP_DIR_NAME);
            String helpPage = this.helpMap.get(helpID) != null ? this.helpMap.get(helpID) : "jthelp.html";
            StringBuilder address = new StringBuilder();
            address.append("file:").append(helpDir.getAbsolutePath()).append(HELP_FILE_PREFIX).append(helpPage);
            URL url = new URL(address.toString());
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (Exception e) {
            System.err.println("Cannot open JavaTest help file:");
            System.err.println(e.getMessage());
        }
    }

    class ProgressTask
    extends SwingWorker<Void, Void> {
        ProgressTask() {
        }

        @Override
        public Void doInBackground() {
            try {
                File jarFile = new File(HelpBroker.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                File destDir = new File(Preferences.getPrefsDir(), JTHelpBroker.HELP_DIR_NAME);
                File helpVersion = new File(destDir, JTHelpBroker.HELP_VERSION_NAME);
                JarFile jar = new JarFile(jarFile);
                Enumeration<JarEntry> enumEntries = jar.entries();
                int total = 0;
                while (enumEntries.hasMoreElements()) {
                    JarEntry file = enumEntries.nextElement();
                    if (!this.isHelpFile(file)) continue;
                    ++total;
                }
                if (destDir.exists()) {
                    destDir.delete();
                }
                destDir.mkdir();
                int progress = 0;
                this.setProgress((int)((double)progress * 100.0 / (double)total));
                enumEntries = jar.entries();
                while (enumEntries.hasMoreElements()) {
                    JarEntry file = enumEntries.nextElement();
                    File f = new File(destDir + File.separator + file.getName());
                    if (!this.isHelpFile(file)) continue;
                    f.getParentFile().mkdirs();
                    InputStream is = jar.getInputStream(file);
                    FileOutputStream fos = new FileOutputStream(f);
                    while (is.available() > 0) {
                        fos.write(is.read());
                    }
                    fos.close();
                    is.close();
                    this.setProgress((int)((double)(++progress) * 100.0 / (double)total));
                }
                try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(helpVersion), StandardCharsets.UTF_8));){
                    out.println(ProductInfo.getVersion() + ProductInfo.getBuildNumber());
                }
            }
            catch (Exception e) {
                System.err.println("Cannot unpack JavaTest help files");
                System.err.println(e.getMessage());
            }
            return null;
        }

        private boolean isHelpFile(JarEntry file) {
            return file.getName().endsWith(".html") || file.getName().endsWith(".gif") || file.getName().endsWith(".css");
        }
    }
}

