/*
 * Copyright (c) 2007, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jpa.core.callback.listener;

import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusIF;
import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusImpl;
import com.sun.ts.tests.jpa.core.callback.common.ListenerB;
import com.sun.ts.tests.jpa.core.callback.common.ListenerC;

import javax.persistence.*;

@Entity
@Table(name = "PRODUCT_TABLE")
@EntityListeners({ ListenerB.class, ListenerC.class })
public class Product extends CallbackStatusImpl
    implements java.io.Serializable, CallbackStatusIF {
  private String id;

  private String name;

  private double price;

  private int quantity;

  private long partNumber;

  public Product() {
    super();
  }

  public Product(String id, String name, double price, int quantity,
      long partNumber) {
    this.id = id;
    this.name = name;
    this.price = price;
    this.quantity = quantity;
    this.partNumber = partNumber;
  }

  @Id
  @Column(name = "ID")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @Column(name = "NAME")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Column(name = "PRICE")
  public double getPrice() {
    return price;
  }

  public void setPrice(double price) {
    this.price = price;
  }

  @Column(name = "QUANTITY")
  public int getQuantity() {
    return quantity;
  }

  public void setQuantity(int v) {
    this.quantity = v;
  }

  @Column(name = "PNUM")
  public long getPartNumber() {
    return partNumber;
  }

  public void setPartNumber(long v) {
    this.partNumber = v;
  }
}
