/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.util;

import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatchFileParser {
    private BatchFileParser() {
    }

    public static String[] processParameters(String[] args) throws CommandLineParserException {
        int filePos = -1;
        if (args == null) {
            return args;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].startsWith("@")) continue;
            filePos = i;
            break;
        }
        if (filePos == -1) {
            return args;
        }
        String fName = args[filePos].substring(1).trim();
        LineNumberReader r = null;
        try {
            String currLine;
            r = new LineNumberReader(SwissKnife.approveFileReader(fName));
            Properties props = new Properties();
            ArrayList<String> options = new ArrayList<String>();
            if (filePos > 0) {
                options.addAll(Arrays.asList(args).subList(0, filePos));
            }
            Pattern setPattern = Pattern.compile("Set\\s+(.+)=(.+)", 2);
            Pattern nameAndValue = Pattern.compile("(.+)=(.+)");
            Pattern nameOnly = Pattern.compile("([^=]+)");
            while ((currLine = r.readLine()) != null) {
                currLine = currLine.trim();
                Matcher m = setPattern.matcher(currLine);
                if (currLine.startsWith("#") || "".equals(currLine)) continue;
                if (m.find()) {
                    props.put(m.group(1), m.group(2));
                    continue;
                }
                Matcher nv = nameAndValue.matcher(currLine);
                if (nv.find()) {
                    String name = nv.group(1).trim();
                    String val = nv.group(2).trim();
                    if (!name.startsWith("-")) {
                        name = "-" + name;
                    }
                    options.add(name);
                    options.add(val);
                    continue;
                }
                Matcher no = nameOnly.matcher(currLine);
                if (!no.find()) continue;
                String name = no.group(1).trim();
                if (!name.startsWith("-")) {
                    name = "-" + name;
                }
                options.add(name);
            }
            options.addAll(Arrays.asList(args).subList(filePos + 1, args.length));
            BatchFileParser.resolveParams(options, props);
            String[] stringArray = options.toArray(new String[0]);
            return stringArray;
        }
        catch (FileNotFoundException ex) {
            throw new CommandLineParserException("File " + fName + " not found", ex);
        }
        catch (IOException ex) {
            throw new CommandLineParserException("Can't read file " + fName, ex);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                SwissKnife.reportThrowable(ex);
            }
        }
    }

    private static void resolveParams(ArrayList options, Properties props) throws CommandLineParserException {
        boolean resolved;
        boolean subst;
        Pattern macro = Pattern.compile("(\\$\\{(.+?)\\})");
        do {
            subst = false;
            resolved = true;
            Iterator<Object> keys = props.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = props.getProperty(key);
                Matcher m = macro.matcher(val);
                if (!m.find()) continue;
                subst = true;
                String keyToFind = m.group(2);
                String newVal = props.getProperty(keyToFind);
                if (macro.matcher(newVal).find()) {
                    resolved = false;
                    continue;
                }
                if (newVal != null) {
                    val = m.replaceFirst(newVal);
                    props.put(key, val);
                    if (!macro.matcher(val).find()) continue;
                    resolved = false;
                    continue;
                }
                throw new CommandLineParserException("Can't resolve ${" + keyToFind + "} property");
            }
        } while (subst && !resolved);
        for (int i = 0; i < options.size(); ++i) {
            String o = (String)options.get(i);
            Matcher m = macro.matcher(o);
            if (!m.find()) continue;
            String newVal = props.getProperty(m.group(2));
            if (newVal != null) {
                options.set(i, newVal);
                continue;
            }
            throw new CommandLineParserException("Can't resolve " + o + " property");
        }
    }
}

