/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.AgentRemoteClassData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

class AgentClassLoader
extends ClassLoader {
    private Agent.Task parent;

    AgentClassLoader(Agent.Task parent) {
        this.parent = parent;
    }

    public synchronized Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(className);
        if (c == null) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                c = cl != null ? cl.loadClass(className) : this.findSystemClass(className);
            }
            catch (ClassNotFoundException e) {
                AgentRemoteClassData data = this.parent.getClassData(className);
                c = this.defineClass(className, data.getByteData(), 0, data.getByteData().length);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public synchronized InputStream getResourceAsStream(String resourceName) {
        InputStream in = this.getClass().getResourceAsStream(resourceName);
        if (in == null) {
            try {
                byte[] data = this.parent.getResourceData(resourceName);
                in = new ByteArrayInputStream(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return in;
    }
}

