/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.TSBuildListener;
import com.sun.ant.TSLogger;
import com.sun.ant.taskdefs.common.DescriptorHandler;
import com.sun.ant.taskdefs.common.GenericDeploymentTool;
import com.sun.ts.lib.harness.VehicleVerifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Replace;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class SunRITool
extends GenericDeploymentTool {
    public static String PUBLICID_EJB20 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static String PUBLICID_APP_CLIENT = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN";
    public static String PUBLICID_WEB = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    protected static String DEFAULT_SUNRI13_EJB20_DTD_LOCATION = "ejb-jar_2_0.dtd";
    protected static String DEFAULT_SUNRI13_APP_CLIENT_DTD_LOCATION = "application-client_1_3.dtd";
    protected static String DEFAULT_SUNRI13_WEB_DTD_LOCATION = "web-app_2_3.dtd";
    protected String descriptorXmlFileName = "";
    protected String descriptorRuntimeXmlFileName = "";
    protected static String sLastFilesAdded = "";
    private boolean replace;

    public boolean invokePackager(File jarFile, String args) {
        return this.invokePackager(jarFile, args, true);
    }

    public boolean invokePackager(File jarFile, String args, boolean postWrite) {
        boolean retval = false;
        String systemClassPath = System.getProperty("java.class.path");
        String execClassPath = Project.translatePath((String)(systemClassPath + ":" + this.classpath));
        Java packager = (Java)this.project.createTask("java");
        packager.setTaskName("packager");
        packager.setFork(true);
        packager.setFailonerror(false);
        packager.setClassname("com.sun.enterprise.tools.packager.Main");
        Commandline.Argument arguments = packager.createArg();
        arguments.setLine(args);
        Environment.Variable var = null;
        String endorsedDir = this.project.getProperty("ri.java.endorsed.dirs");
        String use23 = this.project.getProperty("use.web.23");
        if (use23 != null) {
            Environment.Variable eVar = new Environment.Variable();
            eVar.setKey("use.web.23");
            eVar.setValue("true");
            packager.addSysproperty(eVar);
        }
        if (endorsedDir == null) {
            endorsedDir = this.project.getProperty("java.endorsed.dirs");
        }
        if (endorsedDir == null) {
            endorsedDir = System.getProperty("java.endorsed.dirs");
        }
        if (endorsedDir != null) {
            this.log("passing java.endorsed.dirs to packager: " + endorsedDir, 3);
            var = new Environment.Variable();
            var.setKey("java.endorsed.dirs");
            var.setValue(endorsedDir);
            packager.addSysproperty(var);
        }
        if (TSBuildListener.j2eeHomeRi != null) {
            Environment.Variable var2 = new Environment.Variable();
            var2.setKey("com.sun.enterprise.home");
            var2.setValue(TSBuildListener.j2eeHomeRi);
            packager.addSysproperty(var2);
        } else {
            if (TSBuildListener.getDtdDir(this.project) != null) {
                Environment.Variable var3 = new Environment.Variable();
                var3.setKey("alt.dtd.dir");
                var3.setValue(TSBuildListener.getDtdDir(this.project));
                packager.addSysproperty(var3);
            }
            if (TSBuildListener.getSchemaDir(this.project) != null) {
                Environment.Variable var4 = new Environment.Variable();
                var4.setKey("alt.schema.dir");
                var4.setValue(TSBuildListener.getSchemaDir(this.project));
                packager.addSysproperty(var4);
            }
        }
        Environment.Variable var5 = new Environment.Variable();
        var5.setKey("sun.application.prefix");
        var5.setValue(this.normalizeFile(jarFile));
        packager.addSysproperty(var5);
        packager.setClasspath(new Path(this.project, execClassPath));
        packager.setMaxmemory("96m");
        if (packager.executeJava() != 0) {
            TSLogger.addFailedDir(jarFile.getParent());
        } else if (postWrite) {
            this.postWrite(jarFile);
            retval = true;
        } else {
            retval = true;
        }
        return retval;
    }

    private String normalizeFile(File jarFile) {
        String result = jarFile.getPath();
        int DIST_LENGTH = 4;
        if (!this.isVehicleTest(jarFile)) {
            int index = result.lastIndexOf("dist");
            String baseDir = result.substring(0, index);
            String extDir = result.substring(index + 4);
            result = baseDir + "src" + extDir;
        }
        return result;
    }

    private boolean isVehicleTest(File file) {
        boolean containsFrom = file.getName().indexOf("_vehicle.ear") != -1;
        VehicleVerifier vehicleVerifier = VehicleVerifier.getInstance((File)file);
        String[] vehicles = vehicleVerifier.getVehicleSet();
        boolean result = vehicles != null && vehicles.length > 0 && containsFrom;
        return result;
    }

    public void postWrite(File archive) {
        Manifest manifest = null;
        if (this.config.manifest != null) {
            if (!this.config.manifest.exists()) {
                throw new BuildException("manifest file does not exist:" + this.config.manifest.getPath());
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.config.manifest);
                manifest = new Manifest(in);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException((Throwable)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        manifest = new Manifest();
        Attributes mainAttrs = manifest.getMainAttributes();
        mainAttrs.putValue("Manifest-Version", "1.0");
        File newManifest = this.addAttributes(manifest, archive);
        this.addManifest(archive, newManifest);
        boolean result = newManifest.delete();
        if (result) {
            // empty if block
        }
    }

    private File addAttributes(Manifest manifest, File archiveFile) {
        String archive = archiveFile.getName();
        String archivePath = archiveFile.getPath();
        int indexCompat = archivePath.indexOf("tests" + File.separator + "compat1");
        int index = archive.indexOf("_component");
        if ((archive.endsWith(".ear") || archive.endsWith(".rar") || index != -1) && indexCompat == -1) {
            Attributes mainAttrs = manifest.getMainAttributes();
            String extListValue = mainAttrs.getValue(Attributes.Name.EXTENSION_LIST);
            String extList = "cts tsharness";
            if (extListValue != null) {
                extList = this.addExtList(extListValue);
            }
            mainAttrs.putValue(Attributes.Name.EXTENSION_LIST.toString(), extList);
            mainAttrs.putValue("cts-" + Attributes.Name.EXTENSION_NAME.toString(), "cts");
            mainAttrs.putValue("cts-" + Attributes.Name.SPECIFICATION_VERSION.toString(), "1.4");
            mainAttrs.putValue("cts-" + Attributes.Name.IMPLEMENTATION_VERSION.toString(), "1.4");
            mainAttrs.putValue("cts-" + Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString(), "com.sun");
            mainAttrs.putValue("tsharness-" + Attributes.Name.EXTENSION_NAME.toString(), "tsharness");
            mainAttrs.putValue("tsharness-" + Attributes.Name.SPECIFICATION_VERSION.toString(), "1.4");
            mainAttrs.putValue("tsharness-" + Attributes.Name.IMPLEMENTATION_VERSION.toString(), "1.4");
            mainAttrs.putValue("tsharness-" + Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString(), "com.sun");
        }
        File outFile = null;
        FileOutputStream out = null;
        try {
            outFile = File.createTempFile("ts-manifest", ".mf");
            out = new FileOutputStream(outFile);
            manifest.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        return outFile;
    }

    private String addExtList(String list) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(list);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equalsIgnoreCase("cts") || token.equalsIgnoreCase("tsharness")) continue;
            buf.append(token + " ");
        }
        buf.append("cts tsharness");
        return buf.toString();
    }

    private void addManifest(File archive, File manifest) {
        ExecTask jar = new ExecTask();
        jar.setProject(this.project);
        jar.init();
        jar.setTaskName("jar");
        jar.setDir(manifest.getParentFile());
        jar.setExecutable("jar");
        jar.setFailonerror(true);
        Commandline.Argument args = jar.createArg();
        args.setLine("umf " + manifest.getName() + " " + archive.getPath());
        jar.perform();
    }

    public void setReplace(boolean b) {
        this.replace = b;
    }

    public boolean getReplace() {
        return this.replace;
    }

    public void replace4ServiceTest(String ddd) {
        String name = this.config.name;
        File dirToSet = new File(ddd);
        if (name.indexOf("ejb_vehicle") != -1) {
            String[][] oldNew = new String[][]{{"jndi-name>com_sun_ts_tests_common_vehicle_ejb_EJBVehicle", "jndi-name>" + name}, {"display-name>ejb_vehicle_client", "display-name>" + name + "_client"}};
            this.doReplace(oldNew, name, dirToSet);
        } else if (name.indexOf("jsp_vehicle") != -1) {
            String[][] oldNew = new String[][]{{"context-root>jsp_vehicle", "context-root>" + name}, {"display-name>jsp_vehicle", "display-name>" + name}};
            this.doReplace(oldNew, name, dirToSet);
        } else if (name.indexOf("servlet_vehicle") != -1) {
            String[][] oldNew = new String[][]{{"context-root>servlet_vehicle", "context-root>" + name}, {"display-name>servlet_vehicle", "display-name>" + name}};
            this.doReplace(oldNew, name, dirToSet);
        } else if (name.indexOf("appclient_vehicle") != -1) {
            String[][] oldNew = new String[][]{{"display-name>appclient_vehicle_client", "display-name>" + name + "_client"}};
            this.doReplace(oldNew, name, dirToSet);
        }
    }

    private void doReplace(String[][] oldNew, String name, File dirToSet) {
        for (int i = 0; i < oldNew.length; ++i) {
            Replace replacer = new Replace();
            replacer.setProject(this.project);
            replacer.setDir(dirToSet);
            replacer.setDefaultexcludes(true);
            replacer.setIncludes(name + "*.xml");
            replacer.setExcludes("*.java, build.xml, *.jsp, *props*, Makefile");
            replacer.setSummary(true);
            replacer.setToken(oldNew[i][0]);
            replacer.setValue(oldNew[i][1]);
            replacer.perform();
        }
    }

    protected void registerKnownDTDs(DescriptorHandler handler) {
        handler.registerDTD(PUBLICID_EJB20, TSBuildListener.getDtdDir(this.getTask().getProject()) + File.separator + DEFAULT_SUNRI13_EJB20_DTD_LOCATION);
        handler.registerDTD(PUBLICID_APP_CLIENT, TSBuildListener.getDtdDir(this.getTask().getProject()) + File.separator + DEFAULT_SUNRI13_APP_CLIENT_DTD_LOCATION);
        handler.registerDTD(PUBLICID_WEB, TSBuildListener.getDtdDir(this.getTask().getProject()) + File.separator + DEFAULT_SUNRI13_WEB_DTD_LOCATION);
    }
}

