/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util;

import com.sun.ts.lib.util.SigLogIntf;
import com.sun.ts.lib.util.TestUtil;

public class SigLogAdapter
implements SigLogIntf {
    private static final String NL = System.getProperty("line.separator", "\n");
    private boolean dumpMessagesToStdErr;

    public SigLogAdapter() {
        String useStdErr = System.getProperty("dump.api.check.stderr", "false");
        if (useStdErr.equalsIgnoreCase("true")) {
            this.dumpMessagesToStdErr = true;
        }
    }

    @Override
    public void println(String msg) {
        this.print(msg + NL);
    }

    @Override
    public void println(Object obj) {
        this.print(obj.toString() + NL);
    }

    @Override
    public void println(char c) {
        this.print(c);
        this.println();
    }

    @Override
    public void println() {
        this.print(NL);
    }

    @Override
    public void print(String msg) {
        if (this.dumpMessagesToStdErr) {
            System.err.println(msg);
        } else {
            TestUtil.logMsg(msg);
        }
    }

    @Override
    public void print(Object obj) {
        this.print(obj.toString());
    }

    @Override
    public void print(char c) {
        char[] chars = new char[]{c};
        this.print(new String(chars));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

