/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TrustAllTrustManager
implements X509TrustManager,
Serializable {
    private static final long serialVersionUID = -1295254056169520318L;
    private final boolean examineValidityDates;

    public TrustAllTrustManager() {
        this.examineValidityDates = false;
    }

    public TrustAllTrustManager(boolean examineValidityDates) {
        this.examineValidityDates = examineValidityDates;
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.examineValidityDates) {
            Date currentDate = new Date();
            for (X509Certificate c : chain) {
                c.checkValidity(currentDate);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.examineValidityDates) {
            Date currentDate = new Date();
            for (X509Certificate c : chain) {
                c.checkValidity(currentDate);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

