/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.basic.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import java.util.logging.Level;

public class GlobalJNDITest {
    private GlobalJNDITest() {
    }

    public static String getGlobalJNDIName(String moduleName, String beanName) {
        return GlobalJNDITest.getGlobalJNDIName(null, moduleName, beanName, null);
    }

    public static String getGlobalJNDIName(String moduleName, String beanName, Class<?> interfaceClass) {
        return GlobalJNDITest.getGlobalJNDIName(null, moduleName, beanName, interfaceClass);
    }

    public static String getGlobalJNDIName(String appName, String moduleName, String beanName) {
        return GlobalJNDITest.getGlobalJNDIName(appName, moduleName, beanName, null);
    }

    public static String getGlobalJNDIName(String appName, String moduleName, String beanName, Class<?> interfaceClass) {
        Helper.getLogger().logp(Level.FINE, "GlobalJNDITest", "getGlobalJNDIName", "appName=" + appName + ", moduleName=" + moduleName + ", beanName=" + beanName + ", interfaceClass=" + interfaceClass);
        if (moduleName == null || moduleName.length() == 0) {
            throw new IllegalArgumentException("invalid moduleName:" + moduleName);
        }
        if (beanName == null || beanName.length() == 0) {
            throw new IllegalArgumentException("invalid beanName:" + beanName);
        }
        String result = "java:global";
        if (appName != null && appName.length() > 0) {
            result = result + "/" + appName;
        }
        result = result + "/" + moduleName + "/" + beanName;
        if (interfaceClass != null) {
            result = result + "!" + interfaceClass.getName();
        }
        return result;
    }

    public static String getAppJNDIName(String moduleName, String beanName) {
        return GlobalJNDITest.getAppJNDIName(moduleName, beanName, null);
    }

    public static String getAppJNDIName(String moduleName, String beanName, Class<?> interfaceClass) {
        String result = "java:app";
        if (moduleName != null && moduleName.length() > 0) {
            result = result + "/" + moduleName;
        }
        if (beanName == null || beanName.length() == 0) {
            throw new RuntimeException("Invalid beanName " + beanName);
        }
        result = result + "/" + beanName;
        if (interfaceClass != null) {
            result = result + "!" + interfaceClass.getName();
        }
        return result;
    }

    public static String getModuleJNDIName(String beanName) {
        return GlobalJNDITest.getModuleJNDIName(beanName, null);
    }

    public static String getModuleJNDIName(String beanName, Class<?> interfaceClass) {
        if (beanName == null || beanName.length() == 0) {
            throw new RuntimeException("Invalid beanName " + beanName);
        }
        String result = "java:module/" + beanName;
        if (interfaceClass != null) {
            result = result + "!" + interfaceClass.getName();
        }
        return result;
    }
}

