/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R0007;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.sharedwebservices.faultservice.WSIConstants;
import com.sun.ts.tests.jaxrpc.wsi.constants.SOAPConstants;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R0007.W2JRLR0007ClientOne;
import com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R0007.W2JRLR0007ClientTwo;
import java.util.Properties;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Client
extends ServiceEETest
implements SOAPConstants,
WSIConstants,
SOAPRequests {
    private static final String STRING_2 = "R0007-2";
    private W2JRLR0007ClientOne client1;
    private W2JRLR0007ClientTwo client2;

    public static void main(String[] args) {
        Client client = new Client();
        Status status = client.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client1 = (W2JRLR0007ClientOne)ClientFactory.getClient(W2JRLR0007ClientOne.class, properties);
        this.client2 = (W2JRLR0007ClientTwo)ClientFactory.getClient(W2JRLR0007ClientTwo.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testResponseClaims() throws EETest.Fault {
        SOAPBody body;
        SOAPMessage response;
        try {
            response = this.client1.makeSaajRequest("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<env:Envelope\n\txmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n\txmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"\n\txmlns:ns0=\"http://w2jrlr0007testservice.org/W2JRLR0007TestService.wsdl\"\n\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n\t<env:Body>\n\t\t<ns0:echoString>\n\t\t\t<str>\n\t\t\t\t<ans1:p1 xmlns:ans1=\"http://w2jrlr0007testservice.org/xsd\">R0007-1</ans1:p1>\n\t\t\t</str>\n\t\t</ns0:echoString>\n\t</env:Body>\n</env:Envelope>\n");
        }
        catch (Exception e) {
            throw new EETest.Fault("Unable to invoke echoString operation (BP-R0007):", e);
        }
        try {
            body = response.getSOAPPart().getEnvelope().getBody();
        }
        catch (SOAPException e) {
            throw new EETest.Fault("Invalid SOAP message returned (BP-R0007)", e);
        }
        NodeList list = body.getElementsByTagNameNS("http://ws-i.org/schemas/conformanceClaim/", "Claim");
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            Element element = (Element)list.item(i);
            Attr attr = element.getAttributeNodeNS("http://schemas.xmlsoap.org/wsdl/soap/", "mustUnderstand");
            if (attr == null || !(value = attr.getValue().trim()).equals("1")) continue;
            throw new EETest.Fault("wsi:Claim element with soap:mustUnderstand=\"1\" encountered (BP-R0007)");
        }
    }

    public void testRequestClaims() throws EETest.Fault {
        String result;
        try {
            result = this.client2.echoString(STRING_2);
            System.out.println("result=" + result);
        }
        catch (Exception e) {
            throw new EETest.Fault("Unable to invoke echoString operation (BP-R0007):", e);
        }
        if (!result.equals("OK")) {
            if (result.equals("EXCEPTION")) {
                throw new EETest.Fault("Endpoint unable to process request (BP-R0007)");
            }
            throw new EETest.Fault("wsi:Claim element with soap:mustUnderstand=\"1\" encountered (BP-R007)");
        }
    }
}

