/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompleteEstablishContextEntry
extends Entry {
    private long clientContextID;
    private boolean contextStateful;
    private byte[] finalContextToken;

    public CompleteEstablishContextEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("complete-establish-context")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("client-context-id")) {
                this.clientContextID = Long.parseLong(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("context-stateful")) {
                this.contextStateful = this.getText(node).equals("true");
                continue;
            }
            if (!node.getNodeName().equals("final-context-token")) continue;
            this.finalContextToken = CompleteEstablishContextEntry.parseBinHex(this.getText(node));
        }
    }

    public long getClientContextID() {
        return this.clientContextID;
    }

    public boolean isContextStateful() {
        return this.contextStateful;
    }

    public byte[] getFinalContextToken() {
        return this.finalContextToken;
    }

    public String toString() {
        String result = "<complete-establish-context>\n";
        result = result + "<client-context-id>" + this.clientContextID + "</client-context-id>\n";
        result = result + "<context-stateful>" + this.contextStateful + "</context-stateful>\n";
        result = result + "<final-context-token>" + CompleteEstablishContextEntry.binHex(this.finalContextToken) + "</final-context-token>\n";
        result = result + "</complete-establish-context>\n";
        return result;
    }
}

