/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.mapkeyclass;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.mapkeyclass.Course;
import com.sun.ts.tests.jpa.core.annotations.mapkeyclass.Semester;
import com.sun.ts.tests.jpa.core.annotations.mapkeyclass.Student;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityManager;

public class Client
extends PMClientBase {
    private Map<Course, Semester> student2EnrollmentMap;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void mapKeyClass() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.createEntities();
            this.getEntityManager().flush();
            this.clearCache();
            this.clearCache();
            Student student = (Student)this.getEntityManager().find(Student.class, (Object)2);
            Set courses = student.getCourses();
            if (courses != null) {
                if (courses.containsAll(this.student2EnrollmentMap.keySet()) && this.student2EnrollmentMap.keySet().containsAll(courses) && courses.size() == this.student2EnrollmentMap.keySet().size()) {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"getCourses() returned null value");
            }
            this.clearCache();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("mapKeyClass Failed");
        }
    }

    public void createEntities() {
        Student student1 = new Student(1, "Neo");
        Student student2 = new Student(2, "Vivek");
        Semester semester1 = new Semester(1);
        Semester semester2 = new Semester(2);
        Semester semester3 = new Semester(3);
        Course appliedMath = new Course(101, "AppliedMathematics");
        Course physics = new Course(102, "Physics");
        Course operationResearch = new Course(103, "OperationResearch");
        Course statistics = new Course(201, "Statistics");
        Hashtable<Course, Semester> student1EnrollmentMap = new Hashtable<Course, Semester>();
        student1EnrollmentMap.put(appliedMath, semester1);
        student1EnrollmentMap.put(physics, semester1);
        student1EnrollmentMap.put(statistics, semester2);
        student1.setEnrollment(student1EnrollmentMap);
        this.student2EnrollmentMap = new Hashtable<Course, Semester>();
        this.student2EnrollmentMap.put(appliedMath, semester1);
        this.student2EnrollmentMap.put(physics, semester1);
        this.student2EnrollmentMap.put(operationResearch, semester3);
        this.student2EnrollmentMap.put(statistics, semester3);
        student2.setEnrollment(this.student2EnrollmentMap);
        EntityManager entityManager = this.getEntityManager();
        entityManager.persist((Object)student1);
        entityManager.persist((Object)student2);
        TestUtil.logTrace((String)"persisted 2 students");
        entityManager.persist((Object)semester1);
        entityManager.persist((Object)semester2);
        entityManager.persist((Object)semester3);
        TestUtil.logTrace((String)"persisted 4 semesters");
        entityManager.persist((Object)appliedMath);
        entityManager.persist((Object)physics);
        entityManager.persist((Object)operationResearch);
        entityManager.persist((Object)statistics);
        TestUtil.logTrace((String)"persisted 4 Courses");
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from ENROLLMENTS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from SEMESTER").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from STUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COURSE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in RemoveSchemaData:", (Throwable)re);
            }
        }
    }
}

