/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.localTx.compat;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class compatClient1
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con = null;
    private String whitebox_tx = null;
    private String whitebox_tx_param = null;
    private TSDataSource ds1 = null;
    private TSDataSource ds2 = null;
    private String uname = null;
    private String password = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        compatClient1 theTests = new compatClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.whitebox_tx = p.getProperty("oldwhitebox-tx");
        this.whitebox_tx_param = p.getProperty("oldwhitebox-tx-param");
        this.logMsg("Using: " + this.whitebox_tx);
        this.logMsg("Using: " + this.whitebox_tx_param);
        this.uname = p.getProperty("rauser1");
        this.password = p.getProperty("rapassword1");
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"###", (Throwable)e);
            throw new EETest.Fault("Exception constructing DBSupport object: " + e.getMessage());
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds1 = (TSDataSource)this.nctx.lookup(this.whitebox_tx);
            this.ds2 = (TSDataSource)this.nctx.lookup(this.whitebox_tx_param);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"####", (Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testGetConnection1() throws EETest.Fault {
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logMsg((String)"Got connection from the DataSource.");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught on creating connection.", (Throwable)e);
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"###", (Throwable)e);
            throw new EETest.Fault(e.getMessage());
        }
        TestUtil.logMsg((String)"Checking for Connection Validity.");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logErr((String)"Exception inserting into table.", (Throwable)sqle);
            TestUtil.printStackTrace((Throwable)sqle);
            throw new EETest.Fault(sqle.getMessage());
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logErr((String)"Exception dropping table.", (Throwable)sqle);
            TestUtil.printStackTrace((Throwable)sqle);
            throw new EETest.Fault(sqle.getMessage());
        }
    }

    public void testgetConnectionWithParameter1() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds2.setLogFlag(true);
            this.con = this.ds2.getConnection(this.uname, this.password);
            this.ds2.setLogFlag(false);
            log = this.ds2.getLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new EETest.Fault(sqle.getMessage());
        }
        String toCheck1 = "LocalTxMCF";
        String toCheck2 = "TSManagedConnection";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || !b2) {
            throw new EETest.Fault("Failed: couldn't find...");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new EETest.Fault(sqle.getMessage());
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new EETest.Fault(sqle.getMessage());
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"Cleanup");
        try {
            this.con.close();
        }
        catch (Exception sqle) {
            TestUtil.printStackTrace((Throwable)sqle);
            TestUtil.logErr((String)("Exception on cleanup: " + sqle.getMessage()));
        }
    }
}

