/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.Service;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");
    JAXR_Util util = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        if (this.debug != null) {
            TestUtil.logTrace((String)this.debug.toString());
        }
    }

    public void service_setProvidingOrganization_Test() throws EETest.Fault {
        String testName = "service_setProvidingOrganization_Test";
        String name = "setProvidingOrganization_TestService";
        String serviceName = "testService";
        try {
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, name));
            Service service = this.blm.createService(serviceName);
            service.setProvidingOrganization(org);
            if (!service.getProvidingOrganization().getName().getValue(this.tsLocale).equals(name)) {
                throw new EETest.Fault(testName + "Error: organization name does not match");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void service_addGetServiceBindingTest() throws EETest.Fault {
        String testName = "service_addGetServiceBindingTest";
        boolean pass = true;
        String serviceName = "testService";
        try {
            Service service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            ServiceBinding sb = this.blm.createServiceBinding();
            service.addServiceBinding(sb);
            Collection c = service.getServiceBindings();
            for (ServiceBinding retBinding : c) {
                if (retBinding.getService().getName().getValue(this.tsLocale).equals(serviceName)) continue;
                throw new EETest.Fault(testName + "Error: ServiceBinding name does not match");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "Error: ServiceBinding name does not match");
        }
    }

    public void service_addServiceBindingsTest() throws EETest.Fault {
        String testName = "service_addServiceBindingsTest";
        boolean pass = true;
        String serviceName = "testService";
        ServiceBinding sb = null;
        String sbAccessURI = "test service binding";
        int count = 20;
        try {
            int i;
            Service service = this.blm.createService(serviceName);
            ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
            for (int i2 = 0; i2 < count; ++i2) {
                sb = this.blm.createServiceBinding();
                sb.setValidateURI(false);
                sb.setAccessURI(sbAccessURI + i2);
                bindings.add(sb);
            }
            service.addServiceBindings(bindings);
            Collection c = service.getServiceBindings();
            if (c.size() != count) {
                throw new EETest.Fault(testName + "Error: ServiceBinding count does not match");
            }
            ArrayList<String> uris = new ArrayList<String>();
            ArrayList a = new ArrayList(c);
            for (i = 0; i < count; ++i) {
                sb = (ServiceBinding)a.get(i);
                uris.add(sb.getAccessURI());
            }
            for (i = 0; i < count; ++i) {
                if (uris.contains(sbAccessURI + i)) continue;
                throw new EETest.Fault(testName + "Error: ServiceBinding access uri does not match");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void service_removeServiceBindingTest() throws EETest.Fault {
        String testName = "service_removeServiceBindingTest";
        boolean pass = true;
        String serviceName = "testService";
        int count = 20;
        String sburi = "test service binding";
        ServiceBinding sb = null;
        ServiceBinding serviceBinding0 = null;
        try {
            Service service = this.blm.createService(serviceName);
            ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
            serviceBinding0 = this.blm.createServiceBinding();
            TestUtil.logTrace((String)("validate is set to : " + serviceBinding0.getValidateURI()));
            serviceBinding0.setValidateURI(false);
            TestUtil.logTrace((String)("validate is set to : " + serviceBinding0.getValidateURI()));
            serviceBinding0.setAccessURI(sburi + "0");
            bindings.add(serviceBinding0);
            for (int i = 1; i < count; ++i) {
                sb = this.blm.createServiceBinding();
                sb.setValidateURI(false);
                sb.setAccessURI(sburi + i);
                bindings.add(sb);
            }
            service.addServiceBindings(bindings);
            service.removeServiceBinding(serviceBinding0);
            Collection c = service.getServiceBindings();
            ArrayList<String> uris = new ArrayList<String>();
            ArrayList a = new ArrayList(c);
            for (int i = 0; i < c.size(); ++i) {
                sb = (ServiceBinding)a.get(i);
                uris.add(sb.getAccessURI());
                TestUtil.logTrace((String)("found: " + sb.getAccessURI()));
            }
            if (uris.contains(serviceBinding0.getAccessURI())) {
                throw new EETest.Fault(testName + "Error: removed ServiceBinding was found");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void service_removeServiceBindingsTest() throws EETest.Fault {
        String testName = "service_removeServiceBindingsTest";
        boolean pass = true;
        String serviceName = "testService";
        int count = 20;
        String sbURI = "test service binding";
        ServiceBinding sb = null;
        try {
            Service service = this.blm.createService(serviceName);
            ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
            for (int i = 0; i < count; ++i) {
                sb = this.blm.createServiceBinding();
                sb.setValidateURI(false);
                sb.setAccessURI(sbURI + i);
                bindings.add(sb);
            }
            service.addServiceBindings(bindings);
            service.removeServiceBindings(bindings);
            Collection c = service.getServiceBindings();
            if (c.size() != 0) {
                throw new EETest.Fault(testName + "Error: deleted ServiceBindings were returned");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

