/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.common;

import com.sun.ts.lib.util.TestUtil;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RunnableTask
implements Runnable {
    private final String jndiName;
    private final String expectedJndiValue;
    private final String contexualClassName;
    private final long blockTime;

    @Override
    public void run() {
        if (this.blockTime > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(this.blockTime);
            }
            catch (InterruptedException e) {
                TestUtil.logErr((String)"", (Throwable)e);
            }
        }
        boolean jndiPassed = this.lookupEnvRef();
        boolean loadClassPassed = this.loadClass();
        if (!jndiPassed || !loadClassPassed) {
            throw new RuntimeException("jndi test passed: " + jndiPassed + ", class loading test passed: " + loadClassPassed);
        }
    }

    public RunnableTask(String jndiName, String jndiValue, String className, long blockTime) {
        this.contexualClassName = className;
        this.jndiName = jndiName;
        this.expectedJndiValue = jndiValue;
        this.blockTime = blockTime;
    }

    public RunnableTask(String jndiName, String jndiValue, String className) {
        this.contexualClassName = className;
        this.jndiName = jndiName;
        this.expectedJndiValue = jndiValue;
        this.blockTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lookupEnvRef() {
        boolean passed = false;
        InitialContext ctx = null;
        String value = null;
        try {
            ctx = new InitialContext();
            value = (String)ctx.lookup(this.jndiName);
            if (this.expectedJndiValue.equals(value)) {
                passed = true;
            }
        }
        catch (NamingException namingException) {
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
        return passed;
    }

    protected boolean loadClass() {
        boolean passed = false;
        try {
            Class<?> loadedClass = Thread.currentThread().getContextClassLoader().loadClass(this.contexualClassName);
            if (this.contexualClassName == loadedClass.getName()) {
                passed = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return passed;
    }
}

