/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.webservices.allowedmethodstest.bm;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import java.io.Serializable;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.transaction.UserTransaction;

public class TestBeanEJB
implements SessionBean,
TimedObject {
    private SessionContext sctx = null;
    private TSNamingContext nctx = null;
    private UserTransaction ut;
    private String role = "Administrator";
    private Hashtable results = null;
    private boolean SKIP = false;
    private Hashtable table = new Hashtable();
    String[] expected = new String[]{"true", "true", "true", "true", "true", "true", "true", "true", "true", "true", "true", "true", "true", "true", "true", "false", "false"};
    private static final String[] tests = new String[]{"businessMethod"};
    private static final Properties[] methodList = new Properties[]{new Properties()};

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to obtain NamingContext");
        }
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbTimeout(Timer timer) {
        TestUtil.logTrace((String)"ejbTimeout");
    }

    public Hashtable getResults() {
        TestUtil.logTrace((String)"getResults");
        return this.table;
    }

    public boolean businessMethod() {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"businessMethod");
            this.doOperationTests("businessMethod");
            this.results = this.getResults();
            pass = this.checkResults(this.results, "businessMethod", this.expected);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
        return pass;
    }

    private int testIndex(String s) {
        TestUtil.logTrace((String)"testIndex");
        for (int i = 0; i < tests.length; ++i) {
            if (!s.equals(tests[i])) continue;
            return i;
        }
        return -1;
    }

    private void setTestList(int i) {
        TestUtil.logTrace((String)"setTestList");
        methodList[i].setProperty("getEJBHome", "true");
        methodList[i].setProperty("getCallerPrincipal", "true");
        methodList[i].setProperty("isCallerInRole", "true");
        methodList[i].setProperty("getEJBObject", "true");
        methodList[i].setProperty("JNDI_Access", "true");
        methodList[i].setProperty("UserTransaction", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test1", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test2", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test3", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test4", "true");
        methodList[i].setProperty("getEJBLocalHome", "true");
        methodList[i].setProperty("getEJBLocalObject", "true");
        methodList[i].setProperty("getTimerService", "true");
        methodList[i].setProperty("Timer_Service_Methods", "true");
        methodList[i].setProperty("getMessageContext", "true");
        methodList[i].setProperty("getRollbackOnly", "true");
        methodList[i].setProperty("setRollbackOnly", "true");
    }

    private void doOperationTests(String s) {
        TestUtil.logTrace((String)"doOperationTests");
        int i = this.testIndex(s);
        TestUtil.logMsg((String)("index for " + s + " is " + i));
        TestUtil.logMsg((String)("methodList length=" + methodList.length));
        TestUtil.logMsg((String)("tests length=" + tests.length));
        this.setTestList(i);
        TestUtil.logMsg((String)("Operations testing for " + s + " method ..."));
        try {
            this.sctx.getEJBHome();
            TestUtil.logMsg((String)"Operations test: getEJBHome() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBHome", "false");
            TestUtil.logMsg((String)"Operations test: getEJBHome() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBHome", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBHome() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getCallerPrincipal();
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getCallerPrincipal", "false");
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getCallerPrincipal", "unexpected");
            TestUtil.logMsg((String)("Operations test: getCallerPrincipal() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.isCallerInRole(this.role);
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("isCallerInRole", "false");
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("isCallerInRole", "unexpected");
            TestUtil.logMsg((String)("Operations test: isCallerInRole() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBObject();
            TestUtil.logMsg((String)"Operations test: getEJBObject() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBObject", "false");
            TestUtil.logMsg((String)"Operations test: getEJBObject() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBObject", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBObject() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            Context ctx = (Context)this.nctx.lookup("java:comp/env");
            TestUtil.logMsg((String)"Operations test: JNDI_Access - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("JNDI_Access", "false");
            TestUtil.logMsg((String)"Operations test: JNDI_Access - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("JNDI_Access", "unexpected");
            TestUtil.logMsg((String)("Operations test: JNDI_Access - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ut = this.sctx.getUserTransaction();
            TestUtil.logMsg((String)"Operations test: UserTransaction - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().begin();
            TestUtil.logMsg((String)"Operations test: UserTransaction.begin - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test1", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.begin - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test1", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.begin  - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().commit();
            TestUtil.logMsg((String)"Operations test: UserTransaction.commit - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test2", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.commit - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test2", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.commit - not allowed (Unexpected Exception) -" + e));
        }
        try {
            this.sctx.getUserTransaction().getStatus();
            TestUtil.logMsg((String)"Operations test: UserTransaction.getStatus - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test3", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.getStatus - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test3", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.getStatus - not allowed (Unexpected Exception - " + e));
        }
        try {
            this.sctx.getUserTransaction().setTransactionTimeout(5);
            TestUtil.logMsg((String)"Operations test: UserTransaction.setTransactionTimeout - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test4", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.setTransactionTimeout - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test4", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.setTransactionTimeout- not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBLocalHome();
            TestUtil.logMsg((String)"Operations test: getEJBLocalHome() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBLocalHome", "false");
            TestUtil.logMsg((String)"Operations test: getEJBLocalHome() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBLocalHome", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBLocalHome() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBLocalObject();
            TestUtil.logMsg((String)"Operations test: getEJBLocalObject() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBLocalObject", "false");
            TestUtil.logMsg((String)"Operations test: getEJBLocalObject() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBLocalObject", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBLocalObject() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getTimerService();
            TestUtil.logMsg((String)"Operations test: getTimerService() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getTimerService", "false");
            TestUtil.logMsg((String)"Operations test: getTimerService() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getTimerService", "unexpected");
            TestUtil.logMsg((String)("Operations test: getTimerService() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService timesrv = this.sctx.getTimerService();
            Timer tt = timesrv.createTimer(10000L, (Serializable)((Object)"info"));
            TestUtil.logTrace((String)("getTimers:  " + timesrv.getTimers()));
            tt.cancel();
            TestUtil.logMsg((String)"Operations test: Timer_Service_Methods() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("Timer_Service_Methods", "false");
            TestUtil.logMsg((String)"Operations test: Timer_Service_Methods() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("Timer_Service_Methods", "unexpected");
            TestUtil.logMsg((String)("Operations test: Timer_Service_Methods() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getMessageContext();
            TestUtil.logMsg((String)"Operations test: getMessageContext() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getMessageContext", "false");
            TestUtil.logMsg((String)"Operations test: getMessageContext() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getMessageContext", "unexpected");
            TestUtil.logMsg((String)("Operations test: getMessageContext() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getRollbackOnly();
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getRollbackOnly", "false");
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getRollbackOnly", "unexpected");
            TestUtil.logMsg((String)("Operations test: getRollbackOnly() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.setRollbackOnly();
            TestUtil.logMsg((String)"Operations test: setRollbackOnly() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("setRollbackOnly", "false");
            TestUtil.logMsg((String)"Operations test: setRollbackOnly() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("setRollbackOnly", "unexpected");
            TestUtil.logMsg((String)("Operations test: setRollbackOnly() - not allowed (Unexpected Exception) - " + e));
        }
        this.table.put(s, methodList[i]);
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void doTimer(long duration, String info) {
        TestUtil.logTrace((String)"doTimer");
        TimerService ts = this.sctx.getTimerService();
        TestUtil.logTrace((String)"create Timer");
        Timer t = ts.createTimer(duration, (Serializable)((Object)info));
    }

    public boolean getCallerPrincipalTest(String s) {
        TestUtil.logTrace((String)"getCallerPrincipalTest");
        try {
            Principal principal = this.sctx.getCallerPrincipal();
            if (principal != null) {
                TestUtil.logMsg((String)("getCallerPrincipal() returned Principal: " + principal));
                String name = principal.getName();
                if (name.indexOf(s) < 0) {
                    TestUtil.logErr((String)("principal - expected: " + s + ", received: " + name));
                    return false;
                }
                return true;
            }
            TestUtil.logErr((String)"getCallerPrincipal() returned null reference");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private boolean checkResults(Hashtable results, String method, String[] r) {
        TestUtil.logTrace((String)"checkResults");
        TestUtil.logMsg((String)"-----------------------------------------------------");
        boolean pass = true;
        TestUtil.logMsg((String)("Getting results for method: (" + method + ")"));
        if (results == null) {
            TestUtil.logMsg((String)("ERROR: Results object not found for method (" + method + ") ... Skipping"));
            this.SKIP = true;
            return false;
        }
        Properties p = (Properties)results.get(method);
        if (p == null) {
            TestUtil.logMsg((String)("ERROR: Property object not found for method (" + method + ") ... Skipping"));
            this.SKIP = true;
            return false;
        }
        TestUtil.list((Properties)p);
        if (!p.getProperty("getEJBHome").equals(r[0])) {
            TestUtil.logErr((String)"getEJBHome operations test failed");
            pass = false;
        }
        if (!p.getProperty("getCallerPrincipal").equals(r[1])) {
            TestUtil.logErr((String)"getCallerPrincipal operations test failed");
            pass = false;
        }
        if (!p.getProperty("isCallerInRole").equals(r[2])) {
            TestUtil.logErr((String)"isCallerInRole operations test failed");
            pass = false;
        }
        if (!p.getProperty("getEJBObject").equals(r[3])) {
            TestUtil.logErr((String)"getEJBObject operations test failed");
            pass = false;
        }
        if (!p.getProperty("JNDI_Access").equals(r[4])) {
            TestUtil.logErr((String)"JNDI_Access operations test failed");
            pass = false;
        }
        if (!p.getProperty("UserTransaction").equals(r[5])) {
            TestUtil.logErr((String)"UserTransaction operations test failed");
            pass = false;
        }
        if (!p.getProperty("UserTransaction_Methods_Test1").equals(r[6])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test1 operations test failed");
            pass = false;
        }
        if (!p.getProperty("UserTransaction_Methods_Test2").equals(r[7])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test2 operations test failed");
            pass = false;
        }
        if (!p.getProperty("UserTransaction_Methods_Test3").equals(r[8])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test3 operations test failed");
            pass = false;
        }
        if (!p.getProperty("UserTransaction_Methods_Test4").equals(r[9])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test4 operations test failed");
            pass = false;
        }
        if (!p.getProperty("getEJBLocalHome").equals(r[10])) {
            TestUtil.logErr((String)"getEJBLocalHome operations test failed");
            pass = false;
        }
        if (!p.getProperty("getEJBLocalObject").equals(r[11])) {
            TestUtil.logErr((String)"getEJBLocalObject operations test failed");
            pass = false;
        }
        if (!p.getProperty("getTimerService").equals(r[12])) {
            TestUtil.logErr((String)"getTimerService operations test failed");
            pass = false;
        }
        if (!p.getProperty("Timer_Service_Methods").equals(r[13])) {
            TestUtil.logErr((String)"Timer_Service_Methods operations test failed");
            pass = false;
        }
        if (!p.getProperty("getMessageContext").equals(r[14])) {
            TestUtil.logErr((String)"getMessageContext operations test failed");
            pass = false;
        }
        if (!p.getProperty("getRollbackOnly").equals(r[15])) {
            TestUtil.logErr((String)"getRollbackOnly operations test failed");
            pass = false;
        }
        if (!p.getProperty("setRollbackOnly").equals(r[16])) {
            TestUtil.logErr((String)"setRollbackOnly operations test failed");
            pass = false;
        }
        if (pass) {
            TestUtil.logMsg((String)"All operation tests passed as expected ...");
        } else if (this.SKIP) {
            TestUtil.logMsg((String)"ERROR: Unable to obtain test results");
            this.SKIP = false;
        } else {
            TestUtil.logErr((String)"Not All operation tests passed - unexpected ...");
            TestUtil.logMsg((String)"-----------------------------------------------------");
        }
        return pass;
    }
}

