/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.timer.entity.bmp;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.timer.common.TimerImpl;
import com.sun.ts.tests.ejb.ee.timer.entity.bmp.ProxyBean;
import com.sun.ts.tests.ejb.ee.timer.entity.bmp.ProxyBeanHome;
import com.sun.ts.tests.ejb.ee.timer.entity.bmp.TestBean;
import com.sun.ts.tests.ejb.ee.timer.entity.bmp.TestBeanHome;
import java.util.Properties;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;

public class Client
extends EETest {
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private static final String proxyLookup = "java:comp/env/ejb/ProxyBean";
    private static final String queueLookup = "java:comp/env/jms/MyQueue";
    private static final String factoryLookup = "java:comp/env/jms/MyQueueConnectionFactory";
    private TestBeanHome testBeanHome;
    private TestBean testBeanRef;
    private ProxyBeanHome proxyBeanHome;
    private ProxyBean proxyBeanRef;
    private Properties props = new Properties();
    private TSNamingContext jctx;
    private Queue queue;
    private QueueConnectionFactory qcFactory;
    private long ejbTimeout;
    private long msgTimeout;
    private String msg;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private static final String AuthUser = "authuser";
    private String authuser = "";
    private String username = "";
    private String password = "";
    private TSLoginContext lc;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("Setup tests");
        this.props = p;
        this.logMsg("ejb_timeout is " + this.props.getProperty("ejb_timeout"));
        this.logMsg("ejb_wait is " + this.props.getProperty("ejb_wait"));
        try {
            this.authuser = this.props.getProperty(AuthUser);
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            this.jctx = new TSNamingContext();
            this.lc = new TSLoginContext();
            this.lc.login(this.username, this.password);
            this.logMsg("Getting the EJB Home interface for java:comp/env/ejb/ProxyBean");
            this.proxyBeanHome = (ProxyBeanHome)this.jctx.lookup(proxyLookup, ProxyBeanHome.class);
            this.logMsg("Getting the EJB Home interface for java:comp/env/ejb/TestBean");
            this.testBeanHome = (TestBeanHome)this.jctx.lookup(testLookup, TestBeanHome.class);
            this.logMsg("initializing JMS messaging");
            this.queue = (Queue)this.jctx.lookup(queueLookup);
            this.qcFactory = (QueueConnectionFactory)this.jctx.lookup(factoryLookup);
            this.ejbTimeout = Long.parseLong(TestUtil.getProperty((String)"ejb_timeout"));
            this.msgTimeout = Long.parseLong(TestUtil.getProperty((String)"ejb_wait"));
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getInfoStrAndCancelSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:getInfoStrAndCancel");
            testResult = this.testBeanRef.getInfoStrAndCancel(1);
            if (!testResult) {
                throw new EETest.Fault("getInfoStrAndCancelSingleEventTest failed");
            }
            this.logMsg("getInfoStrAndCancelSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("getInfoStrAndCancelSingleEventTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void getInfoStrAndCancelIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:getInfoStrAndCancel");
            testResult = this.testBeanRef.getInfoStrAndCancel(2);
            if (!testResult) {
                throw new EETest.Fault("getInfoStrAndCancelIntervalTest failed");
            }
            this.logMsg("getInfoStrAndCancelIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("getInfoStrAndCancelIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void getInfoStringAndCancelDateTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:getInfoStrAndCancel");
            testResult = this.testBeanRef.getInfoStrAndCancel(3);
            if (!testResult) {
                throw new EETest.Fault("getInfoStrAndCancelDateTest failed");
            }
            this.logMsg("getInfoStrAndCancelDateTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("getInfoStrAndCancelDateTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void getInfoStrAndCancelDateIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:getInfoStrAndCancel");
            testResult = this.testBeanRef.getInfoStrAndCancel(4);
            if (!testResult) {
                throw new EETest.Fault("getInfoStrAndCancelDateIntervalTest failed");
            }
            this.logMsg("getInfoStrAndCancelDateIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("getInfoStrAndCancelDateIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void getInfoClassAndCancelSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:getInfoClassAndCancel");
            testResult = this.testBeanRef.getInfoClassAndCancel(1);
            if (!testResult) {
                throw new EETest.Fault("getInfoClassAndCancelSingleEventTest failed");
            }
            this.logMsg("getInfoClassAndCancelSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("getInfoClassAndCancelSingleEventTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void getInfoClassAndCancelIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:getInfoClassAndCancel");
            testResult = this.testBeanRef.getInfoClassAndCancel(2);
            if (!testResult) {
                throw new EETest.Fault("getInfoClassAndCancelIntervalTest failed");
            }
            this.logMsg("getInfoClassAndCancelIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("getInfoClassAndCancelIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void getInfoClassAndCancelDateTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:getInfoClassAndCancel");
            testResult = this.testBeanRef.getInfoClassAndCancel(3);
            if (!testResult) {
                throw new EETest.Fault("getInfoClassAndCancelDateTest failed");
            }
            this.logMsg("getInfoClassAndCancelDateTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("getInfoClassAndCancelDateTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void verifyTimeoutCallSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:initializeTimer");
            testResult = this.testBeanRef.initializeTimer(1, 1);
            if (testResult) {
                this.logMsg("initializeTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("hello from ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("verifyTimeoutCallSingleEventTest failed");
            }
            this.logMsg("verifyTimeoutCallSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("verifyTimeoutCallSingleEventTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void verifyTimeoutCallIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:initializeTimer");
            testResult = this.testBeanRef.initializeTimer(2, 1);
            if (testResult) {
                this.logMsg("initializeTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("hello from ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("verifyTimeoutCallIntervalTest failed");
            }
            this.logMsg("verifyTimeoutCallIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("verifyTimeoutCallIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void checkedMethodAccessSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:initializeTimer");
            testResult = this.testBeanRef.initializeTimer(1, 2);
            if (testResult) {
                this.logMsg("initializeTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("checked method successfully accessed in ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("checkedMethodAccessSingleEventTest failed");
            }
            this.logMsg("checkedMethodAccessSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkedMethodAccessSingleEventTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void checkedMethodAccessIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:initializeTimer");
            testResult = this.testBeanRef.initializeTimer(2, 2);
            if (testResult) {
                this.logMsg("initializeTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("checked method successfully accessed in ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("checkedMethodAccessIntervalTest failed");
            }
            this.logMsg("checkedMethodAccessIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkedMethodAccessIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void rollbackTxOnCreationSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:createAndRollback");
            testResult = this.testBeanRef.createAndRollback(1);
            if (testResult) {
                this.logMsg("createAndRollback succeeded");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("no valid message received");
                if (testResult) {
                    testResult = this.testBeanRef.verifyTimerIsGone();
                }
            }
            if (!testResult) {
                throw new EETest.Fault("rollbackTxOnCreationSingleEventTest failed");
            }
            this.logMsg("rollbackTxOnCreationSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("rollbackTxOnCreationSingleEventTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void rollbackTxOnCreationIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:createAndRollback");
            testResult = this.testBeanRef.createAndRollback(2);
            if (testResult) {
                this.logMsg("createAndRollback succeeded");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("no valid message received");
                if (testResult) {
                    testResult = this.testBeanRef.verifyTimerIsGone();
                }
            }
            if (!testResult) {
                throw new EETest.Fault("rollbackTxOnCreationIntervalTest failed");
            }
            this.logMsg("rollbackTxOnCreationIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("rollbackTxOnCreationIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void ejbTimeoutRetrySingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:createFlagStoreAndTimer");
            testResult = this.testBeanRef.createFlagStoreAndTimer(1, 3);
            if (testResult) {
                this.logMsg("createFlagStoreAndTimer succeeded");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("ejbTimeout has been successfully retried");
            }
            if (!testResult) {
                throw new EETest.Fault("ejbTimeoutRetrySingleEventTest failed");
            }
            this.logMsg("ejbTimeoutRetrySingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("ejbTimeoutRetrySingleEventTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void ejbTimeoutRetryIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:createFlagStoreAndTimer");
            testResult = this.testBeanRef.createFlagStoreAndTimer(2, 3);
            if (testResult) {
                this.logMsg("createFlagStoreAndTimer succeeded");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("ejbTimeout has been successfully retried");
            }
            if (!testResult) {
                throw new EETest.Fault("ejbTimeoutRetryIntervalTest failed");
            }
            this.logMsg("ejbTimeoutRetryIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("ejbTimeoutRetryIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void rollbackTxInEjbTimeoutSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:createFlagStoreAndTimer");
            testResult = this.testBeanRef.createFlagStoreAndTimer(1, 4);
            if (testResult) {
                this.logMsg("createFlagStoreAndTimer succeeded");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("Transaction has been successfully rolled back in ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("rollbackTxInEjbTimeoutSingleEventTest failed");
            }
            this.logMsg("rollbackTxInEjbTimeoutSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("rollbackTxInEjbTimeoutSingleEventTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void rollbackTxInEjbTimeoutIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:createFlagStoreAndTimer");
            testResult = this.testBeanRef.createFlagStoreAndTimer(2, 4);
            if (testResult) {
                this.logMsg("createFlagStoreAndTimer succeeded");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("Transaction has been successfully rolled back in ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("rollbackTxInEjbTimeoutIntervalTest failed");
            }
            this.logMsg("rollbackTxInEjbTimeoutIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("rollbackTxInEjbTimeoutIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void checkSerializationSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:checkSerialization");
            testResult = this.testBeanRef.isSerializable(1);
            if (!testResult) {
                throw new EETest.Fault("checkSerializationSingleEventTest failed");
            }
            this.logMsg("checkSerializationSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkSerializationSingleEventTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void checkSerializationIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:checkSerialization");
            testResult = this.testBeanRef.isSerializable(2);
            if (!testResult) {
                throw new EETest.Fault("checkSerializationIntervalTest failed");
            }
            this.logMsg("checkSerializationIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkSerializationIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void checkSerializationDateTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:checkSerialization");
            testResult = this.testBeanRef.isSerializable(3);
            if (!testResult) {
                throw new EETest.Fault("checkSerializationDateTest failed");
            }
            this.logMsg("checkSerializationDateTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkSerializationDateTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void checkSerializationInEjbTimeoutSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:initializeTimer");
            testResult = this.testBeanRef.initializeTimer(1, 5);
            if (testResult) {
                this.logMsg("initializeTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("Timer handle successfully serialized in ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("checkSerializationInEjbTimeoutSingleEventTest failed");
            }
            this.logMsg("checkSerializationInEjbTimeoutSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkSerializationInEjbTimeoutSingleEventTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void checkSerializationInEjbTimeoutIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:initializeTimer");
            testResult = this.testBeanRef.initializeTimer(2, 5);
            if (testResult) {
                this.logMsg("initializeTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("Timer handle successfully serialized in ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("checkSerializationInEjbTimeoutIntervalTest failed");
            }
            this.logMsg("checkSerializationInEjbTimeoutIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkSerializationInEjbTimeoutIntervalTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    public void cancelAndRollbackSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB ProxyBean instance");
            this.proxyBeanRef = this.proxyBeanHome.create(this.props);
            boolean testResult = false;
            this.logMsg("Performing EJB ProxyBean setup");
            if (!this.proxyBeanRef.setup()) {
                throw new EETest.Fault("cancelAndRollbackSingleEventTest failed");
            }
            this.logMsg("Execute ProxyBean:cancelAndRollback");
            testResult = this.proxyBeanRef.cancelAndRollback(1);
            if (testResult) {
                this.logMsg("cancelAndRollback succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("hello from ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("cancelAndRollbackSingleEventTest failed");
            }
            this.logMsg("cancelAndRollbackSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("cancelAndRollbackSingleEventTest failed", e);
        }
        finally {
            this.cleanupProxyBean(this.proxyBeanRef);
        }
    }

    public void cancelAndRollbackIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB ProxyBean instance");
            this.proxyBeanRef = this.proxyBeanHome.create(this.props);
            boolean testResult = false;
            this.logMsg("Performing EJB ProxyBean setup");
            if (!this.proxyBeanRef.setup()) {
                throw new EETest.Fault("cancelAndRollbackIntervalTest failed");
            }
            this.logMsg("Execute ProxyBean:cancelAndRollback");
            testResult = this.proxyBeanRef.cancelAndRollback(2);
            if (testResult) {
                this.logMsg("cancelAndRollback succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("hello from ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("cancelAndRollbackIntervalTest failed");
            }
            this.logMsg("cancelAndRollbackIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("cancelAndRollbackIntervalTest failed", e);
        }
        finally {
            this.cleanupProxyBean(this.proxyBeanRef);
        }
    }

    public void goneOnExpirationSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB ProxyBean instance");
            this.proxyBeanRef = this.proxyBeanHome.create(this.props);
            boolean testResult = false;
            if (!this.proxyBeanRef.setup()) {
                throw new EETest.Fault("goneOnExpirationSingleEventTest failed");
            }
            this.logMsg("Execute ProxyBean:initializeTimer");
            testResult = this.proxyBeanRef.initializeTimer(1, 1);
            if (testResult) {
                this.logMsg("initializeTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                this.logMsg("message received is " + this.msg);
                testResult = this.msg.equals("hello from ejbTimeout");
            }
            if (testResult) {
                Thread.currentThread();
                Thread.sleep((this.msgTimeout - this.ejbTimeout) / 2L);
                testResult = this.proxyBeanRef.timerDoesNotExist();
            }
            if (!testResult) {
                throw new EETest.Fault("goneOnExpirationSingleEventTest failed");
            }
            this.logMsg("goneOnExpirationSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("goneOnExpirationSingleEventTest failed", e);
        }
        finally {
            this.cleanupProxyBean(this.proxyBeanRef);
        }
    }

    public void goneOnCancellationSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB ProxyBean instance");
            this.proxyBeanRef = this.proxyBeanHome.create(this.props);
            boolean testResult = false;
            if (!this.proxyBeanRef.setup()) {
                throw new EETest.Fault("goneOnCancellationSingleEventTest failed");
            }
            this.logMsg("Execute ProxyBean:initializeAndCancelTimer");
            testResult = this.proxyBeanRef.initializeAndCancelTimer(1);
            if (testResult) {
                this.logMsg("initializeAndCancelTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                this.logMsg("message is " + this.msg);
                testResult = this.msg.equals("no valid message received");
            }
            if (!testResult) {
                throw new EETest.Fault("goneOnCancellationSingleEventTest failed");
            }
            this.logMsg("goneOnCancellationSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("goneOnCancellationSingleEventTest failed", e);
        }
        finally {
            this.cleanupProxyBean(this.proxyBeanRef);
        }
    }

    public void goneOnCancellationIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB ProxyBean instance");
            this.proxyBeanRef = this.proxyBeanHome.create(this.props);
            boolean testResult = false;
            if (!this.proxyBeanRef.setup()) {
                throw new EETest.Fault("goneOnCancellationIntervalTest failed");
            }
            this.logMsg("Execute ProxyBean:initializeAndCancelTimer");
            testResult = this.proxyBeanRef.initializeAndCancelTimer(2);
            if (testResult) {
                this.logMsg("initializeAndCancelTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                this.logMsg("message is " + this.msg);
                testResult = this.msg.equals("no valid message received");
            }
            if (!testResult) {
                throw new EETest.Fault("goneOnCancellationIntervalTest failed");
            }
            this.logMsg("goneOnCancellationIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("goneOnCancellationIntervalTest failed", e);
        }
        finally {
            this.cleanupProxyBean(this.proxyBeanRef);
        }
    }

    public void goneOnRemovalSingleEventTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB ProxyBean instance");
            this.proxyBeanRef = this.proxyBeanHome.create(this.props);
            boolean testResult = false;
            if (!this.proxyBeanRef.setup()) {
                throw new EETest.Fault("goneOnRemovalSingleEventTest failed");
            }
            this.logMsg("Execute ProxyBean:removeBeanWithTimers");
            testResult = this.proxyBeanRef.removeBeanWithTimers(1);
            if (!testResult) {
                throw new EETest.Fault("goneOnRemovalSingleEventTest failed");
            }
            this.logMsg("goneOnRemovalSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("goneOnRemovalSingleEventTest failed", e);
        }
        finally {
            this.cleanupProxyBean(this.proxyBeanRef);
        }
    }

    public void goneOnRemovalIntervalTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB ProxyBean instance");
            this.proxyBeanRef = this.proxyBeanHome.create(this.props);
            boolean testResult = false;
            if (!this.proxyBeanRef.setup()) {
                throw new EETest.Fault("goneOnRemovalIntervalTest failed");
            }
            this.logMsg("Execute ProxyBean:removeBeanWithTimers");
            testResult = this.proxyBeanRef.removeBeanWithTimers(2);
            if (!testResult) {
                throw new EETest.Fault("goneOnRemovalIntervalTest failed");
            }
            this.logMsg("goneOnRemovalIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("goneOnRemovalIntervalTest failed", e);
        }
        finally {
            this.cleanupProxyBean(this.proxyBeanRef);
        }
    }

    public void goneOnRemovalDateTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB ProxyBean instance");
            this.proxyBeanRef = this.proxyBeanHome.create(this.props);
            boolean testResult = false;
            if (!this.proxyBeanRef.setup()) {
                throw new EETest.Fault("goneOnRemovalDateTest failed");
            }
            this.logMsg("Execute ProxyBean:removeBeanWithTimers");
            testResult = this.proxyBeanRef.removeBeanWithTimers(3);
            if (!testResult) {
                throw new EETest.Fault("goneOnRemovalDateTest failed");
            }
            this.logMsg("goneOnRemovalDateTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("goneOnRemovalDateTest failed", e);
        }
        finally {
            this.cleanupProxyBean(this.proxyBeanRef);
        }
    }

    public void ejbTimeoutAllowedMethodsTest() throws EETest.Fault {
        try {
            this.logMsg("Creating EJB TestBean instance");
            this.testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            boolean testResult = false;
            this.logMsg("Execute TestBean:initializeTimer");
            testResult = this.testBeanRef.initializeTimer(1, 6);
            if (testResult) {
                this.logMsg("initializeTimer succeeded - receiving message");
                this.msg = TimerImpl.getMessage(this.queue, this.qcFactory, this.msgTimeout);
                testResult = this.msg.equals("allowed methods test successful in ejbTimeout");
            }
            if (!testResult) {
                throw new EETest.Fault("ejbTimeoutAllowedMethodsTest failed");
            }
            this.logMsg("ejbTimeoutAllowedMethodsTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("ejbTimeoutAllowedMethodsTest failed", e);
        }
        finally {
            this.cleanupTestBean(this.testBeanRef);
        }
    }

    protected void cleanupTestBean(TestBean testBeanRef) {
        try {
            if (testBeanRef == null) {
                testBeanRef = this.testBeanHome.create(this.props, 1, "expresso", 10.5f);
            }
            testBeanRef.cancelAllTimers();
        }
        catch (Exception e) {
            TimerImpl.handleException("Exception in cancelAllTimers", e);
        }
        if (testBeanRef != null) {
            try {
                testBeanRef.remove();
            }
            catch (Exception e) {
                TimerImpl.handleException("Exception while removing bean", e);
            }
        }
    }

    protected void cleanupProxyBean(ProxyBean proxyBeanRef) {
        try {
            if (proxyBeanRef == null) {
                proxyBeanRef = this.proxyBeanHome.create(this.props);
            }
            proxyBeanRef.cleanup();
        }
        catch (Exception e) {
            TimerImpl.handleException("Exception while cleaning up proxy bean", e);
        }
        if (proxyBeanRef != null) {
            try {
                proxyBeanRef.remove();
            }
            catch (Exception e) {
                TimerImpl.handleException("Exception while removing proxy bean", e);
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        TimerImpl.flushQueue(this.queue, this.qcFactory);
        this.logMsg("cleanup ok");
    }
}

