/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_server.ServletEndpointContext;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_server.ServletEndpointContext.Hello;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private String username = "";
    private String password = "";
    private String unauthUsername = "";
    private String unauthPassword = "";
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String UserNameProp = "user";
    private static final String PasswordProp = "password";
    private static final String unauthUserNameProp = "authuser";
    private static final String unauthPasswordProp = "authpassword";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_server.ServletEndpointContext.";
    private final String NAMESPACEURI = "http://helloservice.org/wsdl";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT_URL = "hellosecureservice.endpoint.1";
    private static final String WSDLLOC_URL = "hellosecureservice.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;
    Hello port = null;
    Stub stub = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getStubJaxrpc() throws Exception {
        TestUtil.logMsg((String)"Get stub from service implementation class using JAXRPC porting instance");
        this.port = (Hello)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_server.ServletEndpointContext.HelloService", "getHelloPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    private void getStub() throws Exception {
        InitialContext ctx = new InitialContext();
        TestUtil.logMsg((String)"Obtained InitialContext");
        TestUtil.logMsg((String)"Lookup java:comp/env/service/servletendpointcontext");
        Service svc = (Service)ctx.lookup("java:comp/env/service/servletendpointcontext");
        TestUtil.logMsg((String)"Obtained service");
        this.port = (Hello)svc.getPort(Hello.class);
        TestUtil.logMsg((String)"Obtained port");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName("http://helloservice.org/wsdl", "HelloService");
        this.PORT_QNAME = new QName("http://helloservice.org/wsdl", "HelloPort");
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.username = p.getProperty(UserNameProp);
            this.password = p.getProperty(PasswordProp);
            this.unauthUsername = p.getProperty(unauthUserNameProp);
            this.unauthPassword = p.getProperty(unauthPasswordProp);
            TestUtil.logMsg((String)("Username=" + this.username + ", Password=" + this.password));
            TestUtil.logMsg((String)("unauthUsername=" + this.unauthUsername + ", unauthPassword=" + this.unauthPassword));
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubJaxrpc();
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url + " ..."));
                this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
                this.stub._setProperty("javax.xml.rpc.security.auth.username", (Object)this.username);
                this.stub._setProperty("javax.xml.rpc.security.auth.password", (Object)this.password);
            } else {
                this.getStub();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void getHttpSessionTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"getHttpSessionTest: test access to HttpSession information");
            TestUtil.logMsg((String)"Invoking RPC method getHttpSessionTest() and expect true ...");
            boolean yes = this.port.getHttpSessionTest();
            if (!yes) {
                TestUtil.logErr((String)"HttpSession information");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getHttpSessionTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getHttpSessionTest failed");
        }
    }

    public void getMessageContextTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"getMessageContextTest: test access to MessageContext information");
            TestUtil.logMsg((String)"Invoking RPC method getMessageContextTest() and expect true ...");
            boolean yes = this.port.getMessageContextTest();
            if (!yes) {
                TestUtil.logErr((String)"MessageContext information");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getMessageContextTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getMessageContextTest failed");
        }
    }

    public void getServletContextTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"getServletContextTest: test access to ServletContext information");
            TestUtil.logMsg((String)"Invoking RPC method getServletContextTest() and expect true ...");
            boolean yes = this.port.getServletContextTest();
            if (!yes) {
                TestUtil.logErr((String)"ServletContext information");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getServletContextTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getServletContextTest failed");
        }
    }

    public void getUserPrincipalTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"getUserPrincipalTest: test access to UserPrincipal information");
            TestUtil.logMsg((String)"Invoking RPC method getUserPrincipalTest() and expect true ...");
            boolean yes = this.port.getUserPrincipalTest();
            if (!yes) {
                TestUtil.logErr((String)"UserPrincipal information");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getUserPrincipalTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getUserPrincipalTest failed");
        }
    }

    public void isUserInRoleTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"isUserInRoleTest: test access to isUserInRole information");
            TestUtil.logMsg((String)"Invoking RPC method isUserInRoleTest() and expect true for Adminstrator role ...");
            boolean yes = this.port.isUserInRoleTest("Administrator");
            if (yes) {
                TestUtil.logMsg((String)"Administrator role - correct");
            } else {
                TestUtil.logErr((String)"Not Administrator role - incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Invoking RPC method isUserInRoleTest() and expect false for Manager role ...");
            yes = this.port.isUserInRoleTest("Manager");
            if (!yes) {
                TestUtil.logMsg((String)"Not Manager role - correct");
            } else {
                TestUtil.logErr((String)"Manager role - incorrect");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("isUserInRoleTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("isUserInRoleTest failed");
        }
    }
}

