/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.metamodel;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.metamodelapi.metamodel.Address;
import com.sun.ts.tests.jpa.core.metamodelapi.metamodel.Employee;
import com.sun.ts.tests.jpa.core.metamodelapi.metamodel.Order;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;

public class Client
extends PMClientBase {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getMetamodel() throws EETest.Fault {
        boolean pass = false;
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            pass = true;
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
        }
        if (!pass) {
            throw new EETest.Fault("getMetamodeltest failed");
        }
    }

    public void getEntities() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            Set orderSet = metaModel.getEntities();
            if (orderSet != null) {
                TestUtil.logTrace((String)"Obtained Non-null Set of EntityType");
                for (EntityType eType : orderSet) {
                    TestUtil.logTrace((String)("entityType Name = " + eType.getName()));
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getEntities Test  failed");
        }
    }

    public void getManagedTypes() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            Set orderSet = metaModel.getManagedTypes();
            if (orderSet != null) {
                TestUtil.logTrace((String)"Obtained Non-null Set of ManagedType");
                for (ManagedType mType : orderSet) {
                    Set attribSet = mType.getDeclaredAttributes();
                    if (attribSet == null) continue;
                    for (Attribute attrib : attribSet) {
                        TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                    }
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getManagedTypes Test  failed");
        }
    }

    public void getEmbeddables() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            Set addrSet = metaModel.getEmbeddables();
            if (addrSet != null) {
                TestUtil.logTrace((String)"Obtained Non-null Set of EmbeddableType");
                for (EmbeddableType eType : addrSet) {
                    Set attribSet = eType.getDeclaredAttributes();
                    if (attribSet == null) continue;
                    for (Attribute attrib : attribSet) {
                        TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                    }
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getEmbeddables Test  failed");
        }
    }

    public void managedType() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            Set attribSet;
            String cActual;
            TestUtil.logMsg((String)"Test entity");
            String expected = "com.sun.ts.tests.jpa.core.metamodelapi.metamodel.Order";
            ManagedType mType = metaModel.managedType(Order.class);
            if (mType != null) {
                ManagedType mTypeOrder = mType;
                cActual = mType.getJavaType().getName();
                if (cActual.equals(expected)) {
                    attribSet = mTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        for (Attribute attrib : attribSet) {
                            TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                        }
                        pass1 = true;
                    } else {
                        TestUtil.logErr((String)"getDeclaredAttributes() returned null");
                    }
                } else {
                    TestUtil.logErr((String)("Expected:" + expected + ", actual:" + cActual));
                }
            }
            TestUtil.logMsg((String)"Test embeddable");
            expected = "com.sun.ts.tests.jpa.core.metamodelapi.metamodel.Address";
            mType = metaModel.managedType(Address.class);
            if (mType != null) {
                ManagedType mTypeAddress = mType;
                cActual = mType.getJavaType().getName();
                if (cActual.equals(expected)) {
                    attribSet = mTypeAddress.getDeclaredAttributes();
                    if (attribSet != null) {
                        for (Attribute attrib : attribSet) {
                            TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                        }
                        pass2 = true;
                    } else {
                        TestUtil.logErr((String)"getDeclaredAttributes() returned null");
                    }
                } else {
                    TestUtil.logErr((String)("Expected:" + expected + ", actual:" + cActual));
                }
            }
            TestUtil.logMsg((String)"Test superclass");
            expected = "com.sun.ts.tests.jpa.core.metamodelapi.metamodel.Employee";
            mType = metaModel.managedType(Employee.class);
            if (mType != null) {
                ManagedType mTypeEmployee = mType;
                cActual = mType.getJavaType().getName();
                if (cActual.equals(expected)) {
                    attribSet = mTypeEmployee.getDeclaredAttributes();
                    if (attribSet != null) {
                        for (Attribute attrib : attribSet) {
                            TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                        }
                        pass3 = true;
                    } else {
                        TestUtil.logErr((String)"getDeclaredAttributes() returned null");
                    }
                } else {
                    TestUtil.logErr((String)("Expected:" + expected + ", actual:" + cActual));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("managedType Test failed");
        }
    }

    public void managedTypeIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            try {
                metaModel.managedType(Client.class);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("managedTypeIllegalArgumentException failed");
        }
    }

    public void entity() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eTypeOrder = metaModel.entity(Order.class);
            if (eTypeOrder != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                Set attribSet = eTypeOrder.getDeclaredAttributes();
                if (attribSet != null) {
                    for (Attribute attrib : attribSet) {
                        TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                    }
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("entity Test  failed");
        }
    }

    public void entityIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            try {
                metaModel.entity(Client.class);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("entityIllegalArgumentException  failed");
        }
    }

    public void embeddable() throws EETest.Fault {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("zipcode");
        expected.add("street");
        expected.add("state");
        expected.add("city");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
                EmbeddableType eTypeOrder = metaModel.embeddable(Address.class);
                if (eTypeOrder != null) {
                    TestUtil.logTrace((String)"Obtained Non-null EmbeddableType");
                    Set attribSet = eTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            TestUtil.logErr((String)"Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            String name = attrib.getName();
                            if (expected.contains(name)) {
                                TestUtil.logTrace((String)("received attribute Name = " + name));
                                continue;
                            }
                            TestUtil.logErr((String)("Received unexpected result" + name));
                            pass = false;
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)"getDeclaredAttributes() returned null");
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)"embeddable() returned null");
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Received unxpected exception", (Throwable)e);
        }
    }

    public void embeddableIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                try {
                    metaModel.embeddable(Client.class);
                    TestUtil.logErr((String)"Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("embeddableIllegalArgumentException failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

