/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_holders.LongHolder;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.xml.rpc.holders.LongHolder;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private static final long myLong = Long.MAX_VALUE;
    private static final long myLongDefault = 0L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void LongHolderConstructorTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"LongHolderConstructorTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via LongHolder() ...");
            LongHolder n = new LongHolder();
            if (n != null) {
                TestUtil.logMsg((String)"LongHolder object created successfully");
            } else {
                TestUtil.logErr((String)"LongHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("LongHolderConstructorTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("LongHolderConstructorTest1 failed");
        }
    }

    public void LongHolderConstructorTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"LongHolderConstructorTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via LongHolder(long) ...");
            LongHolder n = new LongHolder(Long.MAX_VALUE);
            if (n != null) {
                TestUtil.logMsg((String)"LongHolder object created successfully");
            } else {
                TestUtil.logErr((String)"LongHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("LongHolderConstructorTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("LongHolderConstructorTest2 failed");
        }
    }

    public void getValueTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest");
        boolean pass = true;
        if (!this.getValueTest1()) {
            pass = false;
        }
        if (!this.getValueTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getValueTest failed");
        }
    }

    private boolean getValueTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via LongHolder() ...");
            LongHolder n = new LongHolder();
            if (n != null) {
                long v = n.value;
                if (v == 0L) {
                    TestUtil.logMsg((String)"value set as expected to 0");
                } else {
                    TestUtil.logErr((String)("value: expected - 0, received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"LongHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean getValueTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via LongHolder(long) ...");
            LongHolder n = new LongHolder(Long.MAX_VALUE);
            if (n != null) {
                long v = n.value;
                if (Long.MAX_VALUE == v) {
                    TestUtil.logMsg((String)"value set as expected: 9223372036854775807");
                } else {
                    TestUtil.logErr((String)("value: expected - 9223372036854775807, received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"LongHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

