/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.patchtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.patchtests.CommonOperation;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonPatchBuilder;
import javax.json.JsonValue;

public class PatchOperationCopy
extends CommonOperation {
    private final String OPERATION = "COPY";

    PatchOperationCopy() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 6902 copy operation");
        TestUtil.logMsg((String)"Testing RFC 6902 copy operation:");
        this.testCopyStringOnSimpleObject(result);
        this.testCopyStringOnSimpleArray(result);
        this.testCopyIntOnSimpleObject(result);
        this.testCopyIntOnSimpleArray(result);
        this.testCopyBoolOnSimpleObject(result);
        this.testCopyBoolOnSimpleArray(result);
        this.testCopyObjectOnSimpleObject(result);
        this.testCopyObjectOnSimpleArray(result);
        this.testCopyStringOnCompoundObject(result);
        this.testCopyOfNonExistingLocationInObject(result);
        this.testCopyOfNonExistingLocationInArray(result);
        return result;
    }

    private void testCopyStringOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createSimpleObjectCopyStr();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/address", "/name");
    }

    private void testCopyStringOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 2");
        JsonArray in = SimpleValues.createStringArray2();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createStringArray2Copy1to0(), "/1", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createStringArray2Copy0to2(), "/0", "/2");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createStringArray2Copy0to1(), "/0", "/1");
    }

    private void testCopyIntOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createSimpleObjectCopyInt();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/age", "/name");
    }

    private void testCopyIntOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 2");
        JsonArray in = SimpleValues.createIntArray2();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createIntArray2Copy1to0(), "/1", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createIntArray2Copy0to2(), "/0", "/2");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createIntArray2Copy0to1(), "/0", "/1");
    }

    private void testCopyBoolOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createSimpleObjectCopyBool();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/married", "/name");
    }

    private void testCopyBoolOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 2");
        JsonArray in = SimpleValues.createBoolArray2();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createBoolArray2Copy1to0(), "/1", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createBoolArray2Copy0to2(), "/0", "/2");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createBoolArray2Copy0to1(), "/0", "/1");
    }

    private void testCopyObjectOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectObject();
        JsonObject check = SimpleValues.createSimpleObjectCopyObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/wife", "/name");
    }

    private void testCopyObjectOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 2");
        JsonArray in = SimpleValues.createObjectArray2();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createObjectArray2Copy1to0(), "/1", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createObjectArray2Copy0to2(), "/0", "/2");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)SimpleValues.createObjectArray2Copy0to1(), "/0", "/1");
    }

    private void testCopyStringOnCompoundObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on compound JSON object");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonObject check = SimpleValues.createCompoundObjectCopyValue();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/name", "/child/name");
    }

    private void testCopyOfNonExistingLocationInObject(TestResult result) {
        TestUtil.logMsg((String)" - for non existing location in JsonObject");
        JsonObject[] objsIn = new JsonObject[]{SimpleValues.createEmptyObject(), SimpleValues.createSimpleObject(), SimpleValues.createCompoundObject()};
        String[] paths = new String[]{"/address", "/age", "/married", "/wife"};
        Object[] values = new Object[]{"/wife", "/married", "/age", "/address"};
        for (int i = 0; i < objsIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)objsIn[i], paths[j], values[i]);
            }
        }
    }

    private void testCopyOfNonExistingLocationInArray(TestResult result) {
        TestUtil.logMsg((String)" - for non existing location in JsonArray");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createStringArray1(), SimpleValues.createIntArray2(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createObjectArray2()};
        String[] paths = new String[]{"/", "/-1", "/-", "/5", "/0a", "/42", "/address/0"};
        Object[] values = new Object[]{"/0", "/1", "/2", "/5", "/1"};
        for (int i = 0; i < arraysIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)arraysIn[i], paths[j], values[i]);
            }
        }
    }

    @Override
    protected String operationName() {
        return "COPY";
    }

    @Override
    protected JsonPatchBuilder createOperationBuilder(String path, Object value) {
        if (value instanceof String) {
            return Json.createPatchBuilder().copy((String)value, path);
        }
        throw new IllegalArgumentException("Argument \"value\" is not an instance of String");
    }

    @Override
    protected JsonPatchBuilder updateOperationBuilder(JsonPatchBuilder builder, String path, Object value) {
        if (value instanceof String) {
            return builder.copy((String)value, path);
        }
        throw new IllegalArgumentException("Argument \"value\" is not an instance of String");
    }
}

