/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.usertransaction.rollback;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jta.ee.common.Transact;
import java.io.Serializable;
import java.util.Properties;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class UserRollbackClient
extends ServiceEETest
implements Serializable {
    private static final int SLEEPTIME = 2000;
    private static final String testName = "jta.ee.usertransaction.rollback";
    private UserTransaction userTransaction = null;

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            Transact.init();
            this.logTrace("Test environment initialized");
            this.userTransaction = (UserTransaction)Transact.nctx.lookup("java:comp/UserTransaction");
            this.logMsg("User Transaction object is Obtained");
            if (this.userTransaction == null) {
                this.logErr("Unable to get User Transaction Instance : Could not proceed with tests");
                throw new Exception("couldnt proceed further");
            }
            if (this.userTransaction.getStatus() == 0) {
                this.userTransaction.rollback();
            }
        }
        catch (Exception exception) {
            this.logErr("Setup Failed!");
            this.logTrace("Unable to get User Transaction Instance : Could not proceed with tests");
            throw new EETest.Fault("Setup Failed", exception);
        }
    }

    public static void main(String[] args) {
        UserRollbackClient userRollbackClientInst = new UserRollbackClient();
        Status s = userRollbackClientInst.run(args, System.out, System.err);
        s.exit();
    }

    public void testUserRollback001() throws EETest.Fault {
        try {
            if (this.userTransaction.getStatus() == 6) {
                this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
                this.logMsg("Rolling back the transaction");
                this.userTransaction.rollback();
                throw new EETest.Fault("IllegalStateException not thrown as Expected");
            }
            throw new EETest.Fault("Failed to return the status STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegalState) {
            this.logMsg("IllegalStateException was caught as expected!!");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new EETest.Fault("IllegalStateException not thrown as Expected", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new EETest.Fault("IllegalStateException not thrown as Expected", exception);
        }
    }

    public void testUserRollback002() throws EETest.Fault {
        try {
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() == 0) {
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                this.userTransaction.rollback();
            }
            if (this.userTransaction.getStatus() != 6) {
                throw new EETest.Fault("Failed to return the status STATUS_NO_TRANSACTION");
            }
            this.logMsg("UserTransaction Rolledback");
            this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegal) {
            this.logErr("Exception " + illegal.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", illegal);
        }
        catch (SecurityException security) {
            this.logErr("Exception " + security.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", security);
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", exception);
        }
    }

    public void testUserRollback003() throws EETest.Fault {
        try {
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() == 0) {
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                this.userTransaction.commit();
            }
            if (this.userTransaction.getStatus() == 6) {
                this.logMsg("UserTransaction Committed");
                this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
                this.logMsg("Trying to Rollback UserTransaction");
                this.userTransaction.rollback();
                throw new EETest.Fault("IllegalStateException not thrown as Expected");
            }
            throw new EETest.Fault("Failed to return the status STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegalState) {
            this.logMsg("IllegalStateException was caught as expected!!");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new EETest.Fault("IllegalStateException not thrown as Expected", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new EETest.Fault("IllegalStateException not thrown as Expected", exception);
        }
    }

    public void testUserRollback004() throws EETest.Fault {
        try {
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() == 0) {
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                this.userTransaction.rollback();
            }
            if (this.userTransaction.getStatus() == 6) {
                this.logMsg("UserTransaction Rolled back");
                this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
                this.logMsg("Trying to Rollback UserTransaction again");
                this.userTransaction.rollback();
                throw new EETest.Fault("IllegalStateException not thrown as Expected");
            }
            throw new EETest.Fault("Failed to return the status STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegalState) {
            this.logMsg("IllegalStateException was caught as expected!!");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new EETest.Fault("IllegalStateException not thrown as Expected", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new EETest.Fault("IllegalStateException not thrown as Expected", exception);
        }
    }

    public void testUserRollback005() throws EETest.Fault {
        try {
            int status;
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() == 0) {
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                this.userTransaction.rollback();
            }
            if ((status = this.userTransaction.getStatus()) == 5) {
                int count = 0;
                do {
                    this.logTrace("Received STATUS_UNKNOWN. Checking status again.");
                    ++count;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception e) {
                        throw new EETest.Fault(e.getCause());
                    }
                } while ((status = this.userTransaction.getStatus()) == 5 && count < 5);
            }
            if (status != 6) {
                throw new EETest.Fault("Failed to return the status STATUS_NO_TRANSACTION");
            }
            this.logMsg("UserTransaction Rolledback");
            this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegalState) {
            this.logErr("Exception " + illegalState.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", illegalState);
        }
        catch (SecurityException security) {
            this.logErr("Exception " + security.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", security);
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", exception);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            Transact.free();
            try {
                this.userTransaction.rollback();
            }
            catch (Exception exception) {
                throw new EETest.Fault(exception.getCause());
            }
            for (int retries = 1; this.userTransaction.getStatus() != 6 && retries <= 5; ++retries) {
                this.logMsg("cleanup(): retry # " + retries);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    throw new EETest.Fault(e.getCause());
                }
            }
            this.logMsg("Cleanup ok;");
        }
        catch (Exception exception) {
            this.logErr("Cleanup Failed", exception);
            this.logTrace("Could not clean the environment");
        }
    }
}

