/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_synchrec;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

public class MsgBean
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    protected MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queueS = null;
    private QueueSender mSender = null;
    private boolean result = false;

    public MsgBean() {
        TestUtil.logTrace((String)"@MsgBean()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"In Message Bean ======================================EJBCreate");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MY_QUEUE");
            this.queueS = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        long timeout = 10000L;
        QueueSession qSession = null;
        Object messageSent = null;
        TextMessage msgRec = null;
        String mdbMessage = "my mdb message";
        String testName = null;
        Object qSender = null;
        QueueReceiver rcvr = null;
        boolean result = false;
        JmsUtil.initHarnessProps(msg, this.p);
        TestUtil.logTrace((String)"In Message Bean ======================================onMessage");
        try {
            testName = "mdbResponse";
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                throw new EJBException("MDB connection Error!");
            }
            this.qConnection.start();
            qSession = this.qConnection.createQueueSession(true, 0);
            TestUtil.logTrace((String)("will run TestCase: " + testName));
            rcvr = qSession.createReceiver(this.queueR);
            TestUtil.logTrace((String)"Verify the synchronous receive");
            TestUtil.logTrace((String)"HHHHHHHHHHHHH+++++++++  Trying to receive message from the Queue: ");
            msgRec = (TextMessage)rcvr.receive(timeout);
            if (msgRec != null) {
                TestUtil.logTrace((String)"mdb received a msg from MY_QUEUE");
                if (msgRec.getStringProperty("TestCase").equals(mdbMessage)) {
                    TestUtil.logTrace((String)"Success: Correct msg recvd from MY_QUEUE");
                    result = true;
                }
            }
            JmsUtil.sendTestResults(testName, result, qSession, this.queueS);
            TestUtil.logTrace((String)"Mdb test results send to queue reply");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"@MsgBean:setMessageDrivenContext()!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"@ejbRemove()");
    }
}

