/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedQueueSender;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.Queue;

public class ClosedQueueSenderTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedQueueSender.ClosedQueueSenderTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedQueueSenderTests theTests = new ClosedQueueSenderTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseSender() throws Exception {
        this.tool = new JmsTool(0, this.user, this.password, this.mode);
        this.tool.getDefaultQueueConnection().start();
        this.logTrace("Closing queue sender");
        this.tool.getDefaultQueueSender().close();
        this.logTrace("Sender closed");
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void closedQueueSenderCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueSender().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderCloseTest", e);
        }
    }

    public void closedQueueSenderGetDeliveryModeTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultQueueSender().getDeliveryMode();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderGetDeliveryModeTest", e);
        }
    }

    public void closedQueueSenderGetDisableMessageIDTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageID();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderGetDisableMessageIDTest", e);
        }
    }

    public void closedQueueSenderGetDisableMessageTimestampTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageTimestamp();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderGetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueSenderGetPriorityTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getPriority");
            try {
                int foo = this.tool.getDefaultQueueSender().getPriority();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderGetPriorityTest", e);
        }
    }

    public void closedQueueSenderGetTimeToLiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultQueueSender().getTimeToLive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderGetTimeToLiveTest", e);
        }
    }

    public void closedQueueSenderSetDeliveryModeTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setDeliveryMode");
            try {
                this.tool.getDefaultQueueSender().setDeliveryMode(2);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderSetDeliveryModeTest", e);
        }
    }

    public void closedQueueSenderSetDisableMessageIDTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setDisableMessageID");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageID(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderSetDisableMessageIDTest", e);
        }
    }

    public void closedQueueSenderSetDisableMessageTimestampTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageTimestamp(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderSetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueSenderSetPriorityTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setPriority");
            try {
                this.tool.getDefaultQueueSender().setPriority(4);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderSetPriorityTest", e);
        }
    }

    public void closedQueueSenderSetTimeToLiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setTimeToLive");
            try {
                this.tool.getDefaultQueueSender().setTimeToLive(0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderSetTimeToLiveTest", e);
        }
    }

    public void closedQueueSenderGetQueueTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueSender().getQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderGetQueueTest", e);
        }
    }

    public void closedQueueSenderSend1Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call send(Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderSend1Test", e);
        }
    }

    public void closedQueueSenderSend2Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call send(Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderSend2Test", e);
        }
    }

    public void closedQueueSenderSend3Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call send(Queue,Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderSend3Test", e);
        }
    }

    public void closedQueueSenderSend4Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call send(Queue,Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSenderSend4Test", e);
        }
    }
}

