/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.j2w.rpc.literal.R2725;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.sharedclients.simpleclient.SimpleTestClient;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import com.sun.ts.tests.jaxrpc.wsi.utils.SOAPUtils;
import java.util.Properties;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class Client
extends ServiceEETest
implements SOAPRequests {
    private SimpleTestClient client;

    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client = (SimpleTestClient)ClientFactory.getClient(SimpleTestClient.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testVersionMismatchFaultcode() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?> <!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --> <env:Envelope xmlns:env='http://not.soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Body><ns0:helloWorld/></env:Body></env:Envelope>");
            this.client.logMessageInHarness(response);
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateVersionMismatchFaultcode(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
    }

    public void testVersionMismatchFaultcodeWithMustUnderstand() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?><!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --><env:Envelope xmlns:env='http://not.soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Header><foo:Bar xmlns:foo='http://foo.org/bar/' env:actor='http://foo.org/actor' env:mustUnderstand='1'>BAZ</foo:Bar></env:Header><env:Body><ns0:helloWorld/></env:Body></env:Envelope>");
            this.client.logMessageInHarness(response);
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateVersionMismatchFaultcode(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
    }

    public void testVersionMismatchFaultcodeWithNonExistantOperation() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?><!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --><env:Envelope xmlns:env='http://not.soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Body><ns0:nonExistantOperation/></env:Body></env:Envelope>");
            this.client.logMessageInHarness(response);
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateVersionMismatchFaultcode(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
    }

    public void testMustUnderstandFaultcode() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?><!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --><env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Header><foo:Bar xmlns:foo='http://foo.org/bar/' env:actor='http://schemas.xmlsoap.org/soap/actor/next' env:mustUnderstand='1'>BAZ</foo:Bar></env:Header><env:Body><ns0:helloWorld/></env:Body></env:Envelope>");
            this.client.logMessageInHarness(response);
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateMustUnderstandFaultcode(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
    }

    public void testMustUnderstandFaultcodeWithNonExistantOperation() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?><!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --><env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Header><foo:Bar xmlns:foo='http://foo.org/bar/' env:actor='http://schemas.xmlsoap.org/soap/actor/next' env:mustUnderstand='1'>BAZ</foo:Bar></env:Header><env:Body><ns0:nonExistantOperation/></env:Body></env:Envelope>");
            this.client.logMessageInHarness(response);
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateMustUnderstandFaultcode(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
    }

    public void testClientFaultcode() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?> <!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --> <env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Body><ns0:nonExistantOperation/></env:Body></env:Envelope>");
            this.client.logMessageInHarness(response);
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateClientFaultcode(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
    }

    private void validateVersionMismatchFaultcode(SOAPMessage response) throws EETest.Fault, SOAPException {
        if (!SOAPUtils.isVersionMismatchFaultcode(response)) {
            throw new EETest.Fault("Invalid soap:Fault:  faultcode must be \"VersionMismatch\" (BP-R2725)");
        }
    }

    private void validateClientFaultcode(SOAPMessage response) throws EETest.Fault, SOAPException {
        if (!SOAPUtils.isClientFaultcode(response)) {
            throw new EETest.Fault("Invalid soap:Fault:  faultcode must be \"Client\" (BP-R2725)");
        }
    }

    private void validateMustUnderstandFaultcode(SOAPMessage response) throws EETest.Fault, SOAPException {
        if (!SOAPUtils.isMustUnderstandFaultcode(response)) {
            throw new EETest.Fault("Invalid soap:Fault:  faultcode must be \"MustUnderstand\" (BP-R2725)");
        }
    }
}

