/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.packaging.ejb.descriptor;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.ee.packaging.ejb.descriptor.B;
import com.sun.ts.tests.jpa.ee.packaging.ejb.descriptor.C;
import com.sun.ts.tests.jpa.ee.packaging.ejb.descriptor.Stateful3IF;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

@Stateful(name="Stateful3Bean")
@Remote(value={Stateful3IF.class})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class Stateful3Bean
implements Stateful3IF {
    private EntityManager entityManager;
    private EntityManagerFactory emf;
    private Map myMap = new HashMap();
    public SessionContext sessionContext;
    private static final B[] bRef = new B[5];
    private static final C[] cRef = new C[5];

    private EntityManager getEntityManager() {
        TestUtil.logTrace((String)"Look up EntityManagerFactory,get EntityManager");
        try {
            this.emf = (EntityManagerFactory)this.sessionContext.lookup("persistence/MyPersistenceUnit");
            if (this.emf != null) {
                this.entityManager = this.emf.createEntityManager(this.myMap);
            } else {
                TestUtil.logErr((String)"EntityManagerFactory is null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught while setting EntityManager", (Throwable)e);
        }
        return this.entityManager;
    }

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void createTestData() {
        try {
            TestUtil.logTrace((String)"createTestData");
            TestUtil.logTrace((String)"Create 2 B Entities");
            Stateful3Bean.bRef[0] = new B("1", "myB", 1);
            Stateful3Bean.bRef[1] = new B("2", "yourB", 2);
            TestUtil.logTrace((String)"Start to persist Bs ");
            for (B b : bRef) {
                if (b == null) continue;
                this.entityManager.persist((Object)b);
                TestUtil.logTrace((String)("persisted B " + b));
            }
            TestUtil.logTrace((String)"Create 2 C Entities");
            Stateful3Bean.cRef[0] = new C("5", "myC", 5);
            Stateful3Bean.cRef[1] = new C("6", "yourC", 6);
            TestUtil.logTrace((String)"Start to persist Cs ");
            for (Serializable serializable : cRef) {
                if (serializable == null) continue;
                this.entityManager.persist((Object)serializable);
                TestUtil.logTrace((String)("persisted C " + serializable));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected while creating test data:" + e));
        }
    }

    @Override
    public void removeTestData() {
        TestUtil.logTrace((String)"stateful3Bean removeTestData");
        try {
            if (this.entityManager == null || !this.entityManager.isOpen()) {
                this.entityManager = this.getEntityManager();
            }
            this.entityManager.createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.entityManager.createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught while cleaning up:", (Throwable)e);
        }
        finally {
            if (this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.emf.getCache().evictAll();
        TestUtil.logTrace((String)"cleanup complete");
    }

    @Override
    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test1() {
        TestUtil.logTrace((String)"Begin test1");
        boolean pass = false;
        EntityManager em = this.getEntityManager();
        try {
            this.createTestData();
            B anotherB = (B)em.find(B.class, (Object)"1");
            if (anotherB != null) {
                TestUtil.logTrace((String)"anotherB found");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"test1: Unexpected Exception :", (Throwable)e);
        }
        finally {
            try {
                if (em.isOpen()) {
                    em.close();
                }
            }
            catch (IllegalStateException ise) {
                TestUtil.logErr((String)"Unexpected IllegalStateException caught closing EntityManager", (Throwable)ise);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected Exception caught in while closing EntityManager", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test2() {
        TestUtil.logTrace((String)"Begin test2");
        boolean pass = false;
        EntityManager thisEM = this.getEntityManager();
        try {
            if (thisEM.isOpen()) {
                TestUtil.logTrace((String)"EntityManager is OPEN, try close");
                thisEM.close();
            }
            if (!thisEM.isOpen()) {
                TestUtil.logTrace((String)"EntityManager isOpen, returns false as expected");
                pass = true;
            } else {
                TestUtil.logErr((String)"EntityManager isOpen, returns false - unexpected");
            }
        }
        catch (IllegalStateException ise) {
            TestUtil.logErr((String)"Unexpected IllegalStateException caught:", (Throwable)ise);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught:", (Throwable)e);
        }
        return pass;
    }

    @Override
    public boolean test3() {
        TestUtil.logTrace((String)"Begin test3");
        boolean pass = false;
        EntityManager thatEM = this.getEntityManager();
        try {
            if (thatEM.isOpen()) {
                thatEM.close();
            }
            if (!thatEM.isOpen()) {
                thatEM.close();
            }
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"IllegalStateException caught as expected");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught in test3", (Throwable)e);
        }
        return pass;
    }

    @Override
    public boolean test4() {
        TestUtil.logTrace((String)"Begin test4");
        boolean pass = false;
        try {
            EntityManager entityManager = this.getEntityManager();
            entityManager.getTransaction();
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)("Caught Expected Exception :" + e));
            pass = true;
        }
        finally {
            try {
                if (this.entityManager.isOpen()) {
                    this.entityManager.close();
                }
            }
            catch (IllegalStateException ise) {
                TestUtil.logErr((String)"Unexpected IllegalStateException caught closing EntityManager", (Throwable)ise);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected Exception caught while closing EntityManager", (Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test6() {
        TestUtil.logTrace((String)"Begin test6");
        boolean pass = false;
        EntityManager em = this.getEntityManager();
        try {
            this.createTestData();
            C c = (C)em.find(C.class, (Object)"5");
            if (c != null) {
                TestUtil.logTrace((String)"c found");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"test1: Unexpected Exception :", (Throwable)e);
        }
        finally {
            try {
                if (em.isOpen()) {
                    em.close();
                }
            }
            catch (IllegalStateException ise) {
                TestUtil.logErr((String)"Unexpected IllegalStateException caught closing EntityManager", (Throwable)ise);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected Exception caught in while closing EntityManager", (Throwable)e);
            }
        }
        return pass;
    }
}

