/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.api.jakarta.websocket.decodeexception;

import jakarta.websocket.DecodeException;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Test;

public class WSClientIT {
    private static final System.Logger logger = System.getLogger(WSClientIT.class.getName());

    @Test
    public void constructorTest() throws Exception {
        boolean passed = true;
        String reason = "TCK: Cannot decode the message";
        String encoded_message = "xyz for now";
        StringBuilder tmp = new StringBuilder();
        DecodeException dex = new DecodeException(encoded_message, reason);
        if (!encoded_message.equals(dex.getText())) {
            passed = false;
            tmp.append("Expected message ").append(encoded_message).append(", returned").append(dex.getText());
        }
        if (dex.getBytes() != null) {
            passed = false;
            tmp.append("Expected ByteBuffer  to be null, returned").append(dex.getBytes());
        }
        if (!passed) {
            throw new Exception("Test failed: " + tmp.toString());
        }
    }

    @Test
    public void constructorTest1() throws Exception {
        boolean passed = true;
        String reason = "TCK: Cannot decode the message";
        ByteBuffer encoded_message = ByteBuffer.allocate(20);
        encoded_message.put("xyz for now".getBytes());
        DecodeException dex = new DecodeException(encoded_message, reason);
        if (dex.getText() != null) {
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expected encoded_message null, returned" + dex.getText());
        }
        if (!encoded_message.equals(dex.getBytes())) {
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expected ByteBuffer " + encoded_message + ", returned" + dex.getBytes());
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    @Test
    public void constructorTest2() throws Exception {
        boolean passed = true;
        String encoded_message = "xyz for now";
        String reason = "TCK: Cannot decode the message";
        DecodeException dex = new DecodeException(encoded_message, reason, new Throwable("CocntructorTest2"));
        if (!encoded_message.equals(dex.getText())) {
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expected encoded_message " + encoded_message + ", returned" + dex.getText());
        }
        if (dex.getBytes() != null) {
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expected ByteBuffer null, returned" + dex.getBytes());
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    @Test
    public void constructorTest3() throws Exception {
        boolean passed = true;
        String reason = "TCK: Cannot decode the message";
        ByteBuffer encoded_message = ByteBuffer.allocate(20);
        encoded_message.put("xyz for now".getBytes());
        DecodeException dex = new DecodeException(encoded_message, reason, new Throwable("constructorTest3"));
        if (dex.getText() != null) {
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expected encoded_message null, returned" + dex.getText());
        }
        if (!encoded_message.equals(dex.getBytes())) {
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expected ByteBuffer " + encoded_message + ", returned" + dex.getBytes());
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    public void cleanup() {
    }
}

