/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.resource_local;

import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import jakarta.persistence.SynchronizationType;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    private EntityManager entityManager;
    private EntityTransaction entityTransaction;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_resource_local2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupOnly() throws Exception {
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void createEntityManagerSynchronizationTypeIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Properties p = this.getPersistenceUnitProperties();
        logger.log(System.Logger.Level.INFO, "Testing for resource-local entity managers");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)p);
        this.displayMap(emf.getProperties());
        try {
            emf.createEntityManager(SynchronizationType.UNSYNCHRONIZED);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException iae) {
            logger.log(System.Logger.Level.TRACE, "Caught Expected IllegalStateException");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing when EMF is closed");
        emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)p);
        this.displayMap(emf.getProperties());
        try {
            emf.close();
            emf.createEntityManager(SynchronizationType.UNSYNCHRONIZED);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException iae) {
            logger.log(System.Logger.Level.TRACE, "Caught Expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("createEntityManagerSynchronizationTypeIllegalStateExceptionTest failed");
        }
    }

    @AfterEach
    public void cleanupOnly() throws Exception {
        logger.log(System.Logger.Level.TRACE, "cleanupOnly");
        super.cleanup();
        this.removeTestJarFromCP();
    }
}

