/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.resource_local;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.resource_local.A;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.RollbackException;
import jakarta.persistence.SynchronizationType;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());
    private EntityManager entityManager;
    private EntityTransaction entityTransaction;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_resource_local1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test1");
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            pass = this.entityTransaction.isActive();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test1 failed");
        }
    }

    @Test
    public void test2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test2");
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            if (this.entityTransaction.isActive()) {
                this.entityTransaction.begin();
            }
        }
        catch (IllegalStateException iae) {
            logger.log(System.Logger.Level.TRACE, "Caught Expected IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test3");
        boolean pass = false;
        try {
            A newA = new A("3", "test3", 3);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            logger.log(System.Logger.Level.TRACE, "Persist Entity newA");
            this.getEntityManager().persist((Object)newA);
            this.entityTransaction.commit();
            this.entityTransaction.begin();
            logger.log(System.Logger.Level.TRACE, "find newA");
            A modifiedA = (A)this.getEntityManager().find(A.class, (Object)"3");
            if (null != modifiedA && modifiedA.getName().equals("test3")) {
                logger.log(System.Logger.Level.TRACE, "setName");
                modifiedA.setName("test3Modified");
            }
            this.getEntityManager().merge((Object)modifiedA);
            this.entityTransaction.commit();
            A committedA = (A)this.getEntityManager().find(A.class, (Object)"3");
            logger.log(System.Logger.Level.TRACE, "check results");
            if (committedA.getName().equals("test3Modified")) {
                logger.log(System.Logger.Level.TRACE, "PASSED");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test3 failed");
        }
    }

    @Test
    public void test4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test4");
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            if (!this.entityTransaction.isActive()) {
                this.entityTransaction.commit();
            }
        }
        catch (IllegalStateException iae) {
            logger.log(System.Logger.Level.TRACE, "Caught Expected IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test4 failed");
        }
    }

    @Test
    public void test5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test5");
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            A newA = new A("5", "test5", 5);
            this.entityTransaction.begin();
            this.getEntityManager().persist((Object)newA);
            this.entityTransaction.setRollbackOnly();
            this.entityTransaction.commit();
        }
        catch (RollbackException re) {
            logger.log(System.Logger.Level.TRACE, "RollbackException Caught as Expected");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test6");
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            A newA = new A("6", "test6", 6);
            this.entityTransaction.begin();
            this.getEntityManager().persist((Object)newA);
            this.entityTransaction.commit();
            this.entityTransaction.begin();
            A modifiedA = (A)this.getEntityManager().find(A.class, (Object)"6");
            if (null != modifiedA && modifiedA.getName().equals("test6")) {
                modifiedA.setName("test6Modified");
            }
            this.getEntityManager().merge((Object)modifiedA);
            this.entityTransaction.rollback();
            A rolledBackA = (A)this.getEntityManager().find(A.class, (Object)"6");
            if (rolledBackA.getName().equals("test6")) {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test6 failed");
        }
    }

    @Test
    public void test7() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test7");
        boolean pass = false;
        try {
            A newA = new A("7", "test7", 7);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            this.getEntityManager().persist((Object)newA);
            this.entityTransaction.setRollbackOnly();
            if (this.entityTransaction.isActive() && this.entityTransaction.getRollbackOnly()) {
                pass = true;
            }
            this.entityTransaction.rollback();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test7 failed");
        }
    }

    @Test
    public void test8() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test8");
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            if (!this.entityTransaction.isActive()) {
                this.entityTransaction.setRollbackOnly();
                pass = true;
            }
        }
        catch (IllegalStateException iae) {
            logger.log(System.Logger.Level.TRACE, "Caught Expected IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test8 failed");
        }
    }

    @Test
    public void test9() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test9");
        boolean pass = false;
        try {
            A newA = new A("9", "test9", 9);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            this.getEntityManager().persist((Object)newA);
            this.entityTransaction.setRollbackOnly();
            if (this.entityTransaction.isActive() && this.entityTransaction.getRollbackOnly()) {
                pass = true;
            }
            this.entityTransaction.rollback();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test9 failed");
        }
    }

    @Test
    public void test10() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test10");
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            if (!this.entityTransaction.isActive()) {
                this.entityTransaction.getRollbackOnly();
            }
        }
        catch (IllegalStateException iae) {
            logger.log(System.Logger.Level.TRACE, "Caught Expected IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test10 failed");
        }
    }

    @Test
    public void test11() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test11");
        boolean pass = false;
        try {
            A newA = new A("11", "test11", 11);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            this.getEntityManager().persist((Object)newA);
            if (this.entityTransaction.isActive() && !this.entityTransaction.getRollbackOnly()) {
                pass = true;
            }
            this.entityTransaction.rollback();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test11 failed");
        }
    }

    @Test
    public void test12() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test12");
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            pass = this.entityTransaction.isActive();
            this.entityTransaction.rollback();
        }
        catch (PersistenceException e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected PersistenceException Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected PersistenceException rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test12 failed");
        }
    }

    @Test
    public void test13() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test13");
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            pass = !this.entityTransaction.isActive();
        }
        catch (PersistenceException e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected PersistenceException Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected PersistenceException rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test13 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test14() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test14");
        boolean pass = false;
        try {
            A newA = new A("14", "test14", 14);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            this.getEntityManager().persist((Object)newA);
            this.getEntityManager().flush();
            this.entityTransaction.commit();
            A newA2 = new A("14", "test14_2", 14);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            try {
                this.getEntityManager().persist((Object)newA2);
                this.getEntityManager().flush();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.TRACE, "newA2 has the same PK as newA");
                pass = this.entityTransaction.getRollbackOnly();
            }
            this.entityTransaction.rollback();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected PersistenceException rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test14 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test15() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test15");
        boolean pass = false;
        EntityTransaction et = null;
        this.entityManager = this.getEntityManager();
        if (!this.entityManager.isOpen()) {
            this.entityManager = this.getEntityManager();
        }
        try {
            this.entityManager.close();
            if (!this.entityManager.isOpen()) {
                et = this.entityManager.getTransaction();
            }
            if (et != null) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityTransaction returned was null");
            }
        }
        catch (IllegalStateException ise) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception", (Throwable)ise);
        }
        finally {
            try {
                if (et != null) {
                    if (et.isActive()) {
                        et.rollback();
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "EntityTransaction is null");
                }
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected PersistenceException rolling back TX", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("test15 failed");
        }
    }

    @Test
    public void createEntityManagerSynchronizationTypeMapIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Properties p = this.getPersistenceUnitProperties();
        logger.log(System.Logger.Level.INFO, "Testing for resource-local entity managers");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)p);
        this.displayMap(emf.getProperties());
        try {
            emf.createEntityManager(SynchronizationType.UNSYNCHRONIZED, (Map)p);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException iae) {
            logger.log(System.Logger.Level.TRACE, "Caught Expected IllegalStateException");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing when EMF is closed");
        emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)p);
        this.displayMap(emf.getProperties());
        try {
            emf.close();
            emf.createEntityManager(SynchronizationType.UNSYNCHRONIZED, (Map)p);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException iae) {
            logger.log(System.Logger.Level.TRACE, "Caught Expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("createEntityManagerSynchronizationTypeMapIllegalStateExceptionTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "cleanup");
        this.removeTestData();
        logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
        super.cleanup();
        this.removeTestJarFromCP();
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityManager().isOpen()) {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
            try {
                this.getEntityTransaction().begin();
                this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
                this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception re) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
                }
            }
        } else {
            logger.log(System.Logger.Level.TRACE, "EntityManager is closed. No need to remove data");
        }
    }
}

