/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.entityManager;

import jakarta.persistence.Column;
import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedStoredProcedureQueries;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.QueryHint;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.SqlResultSetMappings;
import jakarta.persistence.StoredProcedureParameter;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;

@NamedStoredProcedureQueries(value={@NamedStoredProcedureQuery(name="get-id-firstname-lastname", procedureName="GetEmpIdFNameLNameFromRS", hints={@QueryHint(name="fooname", value="barvalue"), @QueryHint(name="fooname2", value="barvalue2")}, parameters={@StoredProcedureParameter(type=Integer.class, mode=ParameterMode.IN)}, resultSetMappings={"id-firstname-lastname"}), @NamedStoredProcedureQuery(name="get-id-firstname-lastname-refcursor", procedureName="GetEmpIdFNameLNameFromRS", hints={@QueryHint(name="fooname", value="barvalue"), @QueryHint(name="fooname2", value="barvalue2")}, parameters={@StoredProcedureParameter(type=Integer.class, mode=ParameterMode.IN), @StoredProcedureParameter(type=void.class, mode=ParameterMode.REF_CURSOR)}, resultSetMappings={"id-firstname-lastname"})})
@SqlResultSetMappings(value={@SqlResultSetMapping(name="id-firstname-lastname", classes={@ConstructorResult(targetClass=Employee.class, columns={@ColumnResult(name="ID"), @ColumnResult(name="FIRSTNAME"), @ColumnResult(name="LASTNAME")})})})
@Entity
@Table(name="EMPLOYEE")
public class Employee
implements Serializable,
Comparable<Employee> {
    private int id;
    private String firstName;
    private String lastName;
    private Date hireDate;
    private float salary;

    public Employee() {
    }

    public Employee(int id, String firstName, String lastName, Date hireDate, float salary) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.hireDate = hireDate;
        this.salary = salary;
    }

    public Employee(int id, String firstName, String lastName) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Id
    @Column(name="ID")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Column(name="FIRSTNAME")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="HIREDATE")
    @Temporal(value=TemporalType.DATE)
    public Date getHireDate() {
        return this.hireDate;
    }

    public void setHireDate(Date hireDate) {
        this.hireDate = hireDate;
    }

    @Column(name="SALARY")
    public float getSalary() {
        return this.salary;
    }

    public void setSalary(float salary) {
        this.salary = salary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Employee)) {
            return false;
        }
        Employee o1 = (Employee)o;
        boolean result = false;
        if (this.getId() == o1.getId() && this.getFirstName().equals(o1.getFirstName()) && this.getLastName().equals(o1.getLastName()) && this.getHireDate().equals(o1.getHireDate()) && this.getSalary() == o1.getSalary()) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        return this.getId() + this.getFirstName().hashCode() + this.getLastName().hashCode() + this.getHireDate().hashCode() + new Float(this.getSalary()).hashCode();
    }

    @Override
    public int compareTo(Employee emp) {
        int lastCmp = Integer.valueOf(this.getId()).compareTo(emp.getId());
        return lastCmp != 0 ? lastCmp : Integer.valueOf(this.getId()).compareTo(emp.getId());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        if (this.getFirstName() != null) {
            result.append(", first: " + this.getFirstName());
        } else {
            result.append(", first: null");
        }
        if (this.getLastName() != null) {
            result.append(", last: " + this.getLastName());
        } else {
            result.append(", last: null");
        }
        if (this.getHireDate() != null) {
            result.append(", hire: " + this.getHireDate());
        } else {
            result.append(", hire: null");
        }
        result.append(", country: " + this.getSalary());
        result.append("]");
        return result.toString();
    }
}

