/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.entityManager;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.entityManager.A;
import ee.jakarta.tck.persistence.se.entityManager.Employee;
import ee.jakarta.tck.persistence.se.entityManager.Order;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    Properties props = new Properties();
    Map<String, Object> map = new HashMap<String, Object>();
    Order[] orders = new Order[5];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "Employee", pkgName + "Order"};
        return this.createDeploymentJar("jpa_se_entityManager.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupOrderData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupOrderData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createOrderData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanupData");
            this.removeTestData();
            this.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void persistAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            Order order = new Order(6, 666, "desc6");
            this.getEntityManager().persist((Object)order);
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persistAfterClose failed");
        }
    }

    @Test
    public void mergeAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            Order order = new Order(6, 666, "desc6");
            this.getEntityManager().merge((Object)order);
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("mergeAfterClose failed");
        }
    }

    @Test
    public void removeAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            Order order = new Order(6, 666, "desc6");
            this.getEntityManager().remove((Object)order);
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("removeAfterClose failed");
        }
    }

    @Test
    public void findAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().find(Order.class, (Object)0);
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("findAfterClose failed");
        }
    }

    @Test
    public void getReferenceAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().getReference(Order.class, (Object)0);
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("getReferenceAfterClose failed");
        }
    }

    @Test
    public void flushAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().flush();
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("flushAfterClose failed");
        }
    }

    @Test
    public void setFlushModeAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().setFlushMode(FlushModeType.AUTO);
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("setFlushModeAfterClose failed");
        }
    }

    @Test
    public void getFlushModeAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().getFlushMode();
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("getFlushModeAfterClose failed");
        }
    }

    @Test
    public void lockAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            Order order = new Order(6, 666, "desc6");
            this.getEntityManager().lock((Object)order, LockModeType.WRITE);
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("lockAfterClose failed");
        }
    }

    @Test
    public void refreshAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            Order order = new Order(6, 666, "desc6");
            this.getEntityManager().refresh((Object)order);
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshAfterClose failed");
        }
    }

    @Test
    public void clearAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().clear();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("clearAfterClose failed");
        }
    }

    @Test
    public void containsAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            Order order = new Order(6, 666, "desc6");
            this.getEntityManager().contains((Object)order);
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("containsAfterClose failed");
        }
    }

    @Test
    public void createQueryAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createQuery("SELECT Object (orders) FROM Order orders");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("createQueryAfterClose failed");
        }
    }

    @Test
    public void createNamedQueryAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createNamedQuery("CTS NamedQuery");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("createNamedQueryAfterClose failed");
        }
    }

    @Test
    public void createNativeQueryAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createNativeQuery("SELECT o.ID from ORDER o WHERE (o.TOTALPRICE >100");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("createNativeQueryAfterClose failed");
        }
    }

    @Test
    public void joinTransactionAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().joinTransaction();
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("joinTransactionAfterClose failed");
        }
    }

    @Test
    public void getDelegateAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().getDelegate();
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("getDelegateAfterClose failed");
        }
    }

    @Test
    public void closeAfterClose() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().close();
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("closeAfterClose failed");
        }
    }

    @Test
    public void getEntityManagerFactoryIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().getEntityManagerFactory();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getEntityManagerFactoryIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void emGetMetamodelIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().getMetamodel();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException ise) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("emGetMetamodelIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void getCriteriaBuilderIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().getCriteriaBuilder();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
        }
        catch (IllegalStateException ise) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getCriteriaBuilderIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose1Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createNamedQuery("foo", Employee.class);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose1Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose2Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createNamedStoredProcedureQuery("foo");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose2Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose3Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createNativeQuery("Select * from Employee", Employee.class);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose3Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose4Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createNativeQuery("Select * from Employee", "resultSetMapping");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose4Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsAfterClose5Test() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Employee.class);
        this.getEntityManager().close();
        try {
            this.getEntityManager().createQuery(cd);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose5Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsAfterClose6Test() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cbuilder.createQuery(Employee.class);
        this.getEntityManager().close();
        try {
            this.getEntityManager().createQuery(cq);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose6Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsAfterClose7Test() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaUpdate cu = cbuilder.createCriteriaUpdate(Employee.class);
        this.getEntityManager().close();
        try {
            this.getEntityManager().createQuery(cu);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose7Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose8Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createQuery("Select * from Employee", Employee.class);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose8Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose9Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createStoredProcedureQuery("procedureName");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose9Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose10Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createStoredProcedureQuery("procedureName", new Class[]{Employee.class});
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose10Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose11Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createStoredProcedureQuery("procedureName", new String[]{"resultSetMappings"});
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose11Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose12Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().close();
            Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
            this.getEntityManager().detach((Object)emp);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose12Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose13Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().find(Employee.class, (Object)1, LockModeType.NONE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose13Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose14Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().find(Employee.class, (Object)1, LockModeType.NONE, this.map);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose14Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose15Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().find(Employee.class, (Object)1, this.map);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose15Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose16Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().getCriteriaBuilder();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose16Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose17Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().getEntityManagerFactory();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose17Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsAfterClose18Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
        try {
            this.getEntityManager().getLockMode((Object)emp);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose18Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose19Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().getMetamodel();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose19Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose20Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().isJoinedToTransaction();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose20Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsAfterClose21Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
        try {
            this.getEntityManager().lock((Object)emp, LockModeType.NONE, this.map);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose21Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsAfterClose22Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
        try {
            this.getEntityManager().refresh((Object)emp, LockModeType.NONE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose22Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsAfterClose23Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
        try {
            this.getEntityManager().refresh((Object)emp, LockModeType.NONE, this.map);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose23Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsAfterClose24Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
        try {
            this.getEntityManager().refresh((Object)emp, this.map);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose24Test failed");
        }
    }

    @Test
    public void entityManagerMethodsAfterClose25Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().setProperty("foo", (Object)"bar");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsAfterClose25Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose1Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.executeUpdate();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose2Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.getFirstResult();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose3Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.getFlushMode();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose3Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose4Test() throws Exception {
        boolean pass = false;
        logger.log(System.Logger.Level.INFO, "Testing getHints() )");
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.getHints();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose4Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose5Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.getLockMode();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
            } else {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose5Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose6Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.getMaxResults();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose6Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose7Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = ?1");
        query.setParameter(1, (Object)1);
        this.getEntityManager().close();
        try {
            query.getParameter(1);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
            } else {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose7Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose8Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = ?1");
        query.setParameter(1, (Object)1);
        this.getEntityManager().close();
        try {
            query.getParameter(1, Integer.class);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
            } else {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose8Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose9Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.lastName = :name");
        query.setParameter("name", (Object)"Foo");
        this.getEntityManager().close();
        try {
            query.getParameter("name");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
            } else {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose9Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose10Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.lastName = :name");
        query.setParameter("name", (Object)"Foo");
        this.getEntityManager().close();
        try {
            query.getParameter("name", String.class);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
            } else {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose10Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose11Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = ?1");
        query.setParameter(1, (Object)1);
        this.getEntityManager().close();
        try {
            query.getParameters();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
            } else {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose11Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose12Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = ?1");
        query.setParameter(1, (Object)1);
        this.getEntityManager().close();
        try {
            query.getParameterValue(1);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
            } else {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose12Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose13Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = ?1");
        query.setParameter(1, (Object)1);
        Parameter p = query.getParameter(1);
        this.getEntityManager().close();
        try {
            query.getParameterValue(p);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
            } else {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose13Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose14Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = :id");
        query.setParameter("id", (Object)1);
        this.getEntityManager().close();
        try {
            query.getParameterValue("id");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
            } else {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Transaction was not marked for rollback");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose14Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose15Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.getResultList();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose15Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose16Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.getSingleResult();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose16Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose17Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = ?1");
        query.setParameter(1, (Object)1);
        Parameter p = query.getParameter(1);
        this.getEntityManager().close();
        try {
            query.isBound(p);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose17Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose18Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.setFirstResult(1);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose18Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose19Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.setFlushMode(FlushModeType.AUTO);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose19Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose20Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.setHint("foo", (Object)"bar");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose20Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose21Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.setLockMode(LockModeType.NONE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose21Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose22Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        this.getEntityManager().close();
        try {
            query.setMaxResults(1);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose22Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose23Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.hireDate = ?1");
        this.getEntityManager().close();
        try {
            query.setParameter(1, this.getCalDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose23Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose24Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.hireDate = ?1");
        this.getEntityManager().close();
        try {
            query.setParameter(1, this.getUtilDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose24Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose25Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = ?1");
        this.getEntityManager().close();
        try {
            query.setParameter(1, (Object)1);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose25Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose26Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.hireDate = :date");
        query.setParameter("date", this.getCalDate(), TemporalType.DATE);
        Parameter p = query.getParameter("date");
        this.getEntityManager().close();
        try {
            query.setParameter(p, this.getCalDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose26Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose27Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.hireDate = :date");
        query.setParameter("date", this.getCalDate(), TemporalType.DATE);
        Parameter p = query.getParameter("date", Date.class);
        this.getEntityManager().close();
        try {
            query.setParameter(p, this.getUtilDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose27Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose28Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = :id");
        query.setParameter("id", (Object)1);
        Parameter p = query.getParameter("id");
        this.getEntityManager().close();
        try {
            query.setParameter(p, (Object)1);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose28Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose29Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.hireDate = :date");
        this.getEntityManager().close();
        try {
            query.setParameter("date", this.getCalDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose29Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose30Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.hireDate = :date");
        this.getEntityManager().close();
        try {
            query.setParameter("date", this.getUtilDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose30Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryMethodsAfterClose31Test() throws Exception {
        boolean pass = false;
        Query query = this.getEntityManager().createQuery("select e.id from Employee e where e.id = :id");
        this.getEntityManager().close();
        try {
            query.setParameter("id", (Object)1);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("queryMethodsAfterClose31Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose1Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.getResultList();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose2Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.getSingleResult();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose3Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setFirstResult(1);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose3Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose4Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setFlushMode(FlushModeType.AUTO);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose4Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose5Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setHint("foo", (Object)"bar");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose5Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose6Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setLockMode(LockModeType.NONE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose6Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose7Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setMaxResults(1);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose7Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose8Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        TypedQuery tquery = this.getEntityManager().createQuery("SELECT a FROM A a WHERE (a.basicCalendar = ?1)", A.class);
        this.getEntityManager().close();
        try {
            tquery.setParameter(1, this.getCalDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose8Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose9Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        TypedQuery tquery = this.getEntityManager().createQuery("SELECT a FROM A a WHERE (a.basicDate = ?1)", A.class);
        this.getEntityManager().close();
        try {
            tquery.setParameter(1, this.getUtilDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose9Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose10Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        TypedQuery tquery = this.getEntityManager().createQuery("SELECT a FROM A a WHERE (a.id = ?1)", A.class);
        this.getEntityManager().close();
        try {
            tquery.setParameter(1, (Object)"1");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose10Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose11Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        ParameterExpression param1 = cbuilder.parameter(Calendar.class);
        cquery.where((Expression)cbuilder.equal((Expression)a.get("basicCalendar"), (Expression)param1));
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setParameter((Parameter)param1, this.getCalDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose11Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose12Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        ParameterExpression param1 = cbuilder.parameter(Date.class);
        cquery.where((Expression)cbuilder.equal((Expression)a.get("basicDate"), (Expression)param1));
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setParameter((Parameter)param1, this.getUtilDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose12Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose13Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        ParameterExpression param1 = cbuilder.parameter(String.class);
        cquery.where((Expression)cbuilder.equal((Expression)a.get("id"), (Expression)param1));
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setParameter((Parameter)param1, (Object)"1");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose13Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose14Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        ParameterExpression param1 = cbuilder.parameter(Calendar.class, "calDate");
        cquery.where((Expression)cbuilder.equal((Expression)a.get("basicCalendar"), (Expression)param1));
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setParameter("calDate", this.getCalDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose14Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose15Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        ParameterExpression param1 = cbuilder.parameter(Date.class, "utilDate");
        cquery.where((Expression)cbuilder.equal((Expression)a.get("basicDate"), (Expression)param1));
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setParameter("utilDate", this.getUtilDate(), TemporalType.DATE);
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose15Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typedQueryMethodsAfterClose16Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(A.class);
        Root a = cquery.from(A.class);
        cquery.select((Selection)a);
        ParameterExpression param1 = cbuilder.parameter(String.class, "idParam");
        cquery.where((Expression)cbuilder.equal((Expression)a.get("id"), (Expression)param1));
        TypedQuery tquery = this.getEntityManager().createQuery(cquery);
        this.getEntityManager().close();
        try {
            tquery.setParameter("idParam", (Object)"1");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("typedQueryMethodsAfterClose16Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback18Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.getEntityManager().close();
        try {
            this.getEntityManager().getCriteriaBuilder();
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback18Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback19Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.getEntityManager().close();
        try {
            this.getEntityManager().getDelegate();
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback19Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback20Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.getEntityManager().close();
        try {
            this.getEntityManager().getEntityManagerFactory();
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback20Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback22Test() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.getEntityManager().close();
        try {
            this.getEntityManager().getMetamodel();
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback22Test failed");
        }
    }

    @Test
    public void storedProcedureQueryMethodsAfterClose1Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("storedProcedureQueryMethodsAfterClose1Test failed");
        }
    }

    @Test
    public void storedProcedureQueryMethodsAfterClose2Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS");
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("storedProcedureQueryMethodsAfterClose2Test failed");
        }
    }

    @Test
    public void storedProcedureQueryMethodsAfterClose3Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("storedProcedureQueryMethodsAfterClose3Test failed");
        }
    }

    @Test
    public void storedProcedureQueryMethodsAfterClose4Test() throws Exception {
        boolean pass = false;
        this.getEntityManager().close();
        try {
            this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("storedProcedureQueryMethodsAfterClose4Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Orders");
            this.orders[0] = new Order(1, 111, "desc1");
            this.orders[1] = new Order(2, 222, "desc2");
            this.orders[2] = new Order(3, 333, "desc3");
            this.orders[3] = new Order(4, 444, "desc4");
            this.orders[4] = new Order(5, 555, "desc5");
            for (Order o : this.orders) {
                logger.log(System.Logger.Level.TRACE, "Persisting order:" + o.toString());
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

