/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.se.repeatable.secondarytable;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.se.repeatable.secondarytable.HardwareProduct;
import ee.jakarta.tck.persistence.jpa22.se.repeatable.secondarytable.Product;
import ee.jakarta.tck.persistence.jpa22.se.repeatable.secondarytable.SoftwareProduct;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 22L;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFile = new String[]{};
        String[] classes = new String[]{pkgName + "HardwareProduct", pkgName + "Product", pkgName + "SoftwareProduct"};
        return this.createDeploymentJar("jpa_se_repeatable_secondarytable.jar", pkgNameWithoutSuffix, classes, "persistence.xml", xmlFile);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void subClassInheritsCacheableTrue() throws Exception {
        boolean pass3;
        boolean pass2;
        boolean pass1;
        block12: {
            pass1 = false;
            pass2 = false;
            pass3 = false;
            if (this.cachingSupported) {
                try {
                    EntityManager em2 = this.getEntityManager();
                    EntityTransaction et = this.getEntityTransaction();
                    et.begin();
                    Product product = new Product("1", 101);
                    em2.persist((Object)product);
                    logger.log(System.Logger.Level.TRACE, "persisted Product " + product);
                    SoftwareProduct sp = new SoftwareProduct();
                    sp.setId("2");
                    sp.setRevisionNumber(1.0);
                    sp.setQuantity(202);
                    em2.persist((Object)sp);
                    logger.log(System.Logger.Level.TRACE, "persisted SoftwareProduct " + sp);
                    HardwareProduct hp = new HardwareProduct();
                    hp.setId("3");
                    hp.setModelNumber(3);
                    hp.setQuantity(303);
                    em2.persist((Object)hp);
                    logger.log(System.Logger.Level.TRACE, "persisted HardwareProduct " + hp);
                    em2.flush();
                    et.commit();
                    EntityManagerFactory emf = this.getEntityManagerFactory();
                    Cache cache = emf.getCache();
                    if (cache != null) {
                        boolean b1 = cache.contains(Product.class, (Object)"1");
                        if (b1) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b1 + ", therefore cache does contain Product " + product);
                            pass1 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b1 + ", therefore cache does not contain Product " + product);
                        }
                        boolean b2 = cache.contains(SoftwareProduct.class, (Object)"2");
                        if (!b2) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b2 + ", therefore cache does not contain SoftwareProduct " + sp);
                            pass2 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b2 + ", therefore cache does contain SoftwareProduct " + sp);
                        }
                        boolean b3 = cache.contains(HardwareProduct.class, (Object)"3");
                        if (b3) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b3 + ", therefore cache does contain HardwareProduct " + hp);
                            pass3 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b3 + ", therefore cache does not contain HardwareProduct " + hp);
                        }
                        break block12;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
                pass3 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("subClassInheritsCacheableTrue failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_DETAILS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

