/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.generator;

import ee.jakarta.tck.persistence.core.types.generator.Client;
import ee.jakarta.tck.persistence.core.types.generator.DataTypes;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends Client {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());
    private DataTypes d0;
    private DataTypes d1;
    private DataTypes d2;
    private DataTypes d3;
    private DataTypes d4;
    private DataTypes d5;
    private DataTypes d6;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", pkgName + "DataTypes3", pkgName + "DataTypes4"};
        return this.createDeploymentJar("jpa_core_types_generator1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        block4: {
            logger.log(System.Logger.Level.TRACE, "setup");
            try {
                super.setup();
                this.createDeployment();
                String s = System.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    logger.log(System.Logger.Level.INFO, "db.supports.sequence:" + this.supports_sequence);
                    if (this.supports_sequence) {
                        this.createSequenceGenerator();
                        this.removeTestData();
                        this.createTestData();
                    }
                    break block4;
                }
                logger.log(System.Logger.Level.ERROR, "The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new Exception("setupDataTypes2 failed");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
                throw new Exception("Setup failed:", e);
            }
        }
    }

    @Test
    public void generatorTypeTest1() throws Exception {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Character newChar = Character.valueOf('b');
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    logger.log(System.Logger.Level.TRACE, "Doing a find of id: " + id);
                    this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d1) {
                        if (this.d1.getCharacterData().equals(Character.valueOf('a'))) {
                            this.d1.setCharacterData(newChar);
                        }
                        this.getEntityManager().merge((Object)this.d1);
                        this.getEntityManager().flush();
                        if (this.d1.getCharacterData().equals(newChar)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new Exception("generatorTypeTest1 failed");
        }
    }

    @Test
    public void generatorTypeTest2() throws Exception {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Short newShort = 101;
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    logger.log(System.Logger.Level.TRACE, "Doing a find of id: " + id);
                    this.d2 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d2) {
                        if (this.d2.getShortData().equals((short)100)) {
                            this.d2.setShortData(newShort);
                        }
                        this.getEntityManager().merge((Object)this.d2);
                        this.getEntityManager().flush();
                        if (this.d2.getShortData().equals(newShort)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new Exception("generatorTypeTest2 failed");
        }
    }

    @Test
    public void generatorTypeTest3() throws Exception {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Integer newInt = 500;
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    logger.log(System.Logger.Level.TRACE, "Doing a find of id: " + id);
                    this.d3 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d3) {
                        if (this.d3.getIntegerData().equals(500)) {
                            this.d3.setIntegerData(newInt);
                        }
                        this.getEntityManager().merge((Object)this.d3);
                        this.getEntityManager().flush();
                        if (this.d3.getIntegerData().equals(newInt)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new Exception("generatorTypeTest3 failed");
        }
    }

    @Test
    public void generatorTypeTest4() throws Exception {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Long newLong = 600L;
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    logger.log(System.Logger.Level.TRACE, "Doing a find of id: " + id);
                    this.d4 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d4) {
                        if (this.d4.getLongData().equals(300L)) {
                            this.d4.setLongData(newLong);
                        }
                        this.getEntityManager().merge((Object)this.d4);
                        this.getEntityManager().flush();
                        if (this.d4.getLongData().equals(newLong)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new Exception("generatorTypeTest4 failed");
        }
    }

    @Test
    public void generatorTypeTest5() throws Exception {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Double newDbl = 80.0;
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    logger.log(System.Logger.Level.TRACE, "Doing a find of id: " + id);
                    this.d5 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d5) {
                        if (this.d5.getDoubleData().equals(50.0)) {
                            this.d5.setDoubleData(newDbl);
                        }
                        this.getEntityManager().merge((Object)this.d5);
                        this.getEntityManager().flush();
                        if (this.d5.getDoubleData().equals(newDbl)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new Exception("generatorTypeTest5 failed");
        }
    }

    @Test
    public void generatorTypeTest6() throws Exception {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Float newFloat = Float.valueOf(3.0f);
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    logger.log(System.Logger.Level.TRACE, "Doing a find of id: " + id);
                    this.d6 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d6) {
                        if (this.d6.getFloatData().equals(Float.valueOf(1.0f))) {
                            this.d6.setFloatData(newFloat);
                        }
                        this.getEntityManager().merge((Object)this.d6);
                        this.getEntityManager().flush();
                        if (this.d6.getFloatData().equals(newFloat)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new Exception("generatorTypeTest6 failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "in createTestData");
            logger.log(System.Logger.Level.TRACE, "new DataType");
            this.d0 = new DataTypes(Character.valueOf('a'), (short)100, 500, 300L, 50.0, Float.valueOf(1.0f));
            logger.log(System.Logger.Level.TRACE, "Persist DataType");
            this.getEntityManager().persist((Object)this.d0);
            logger.log(System.Logger.Level.TRACE, "DataType id:" + this.d0.getId());
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
    }
}

