/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.annotations;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.annotations.Address;
import ee.jakarta.tck.persistence.core.relationship.annotations.AnnualReview;
import ee.jakarta.tck.persistence.core.relationship.annotations.Company;
import ee.jakarta.tck.persistence.core.relationship.annotations.Insurance;
import ee.jakarta.tck.persistence.core.relationship.annotations.Person;
import ee.jakarta.tck.persistence.core.relationship.annotations.Project;
import ee.jakarta.tck.persistence.core.relationship.annotations.Team;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final Address[] aRef = new Address[5];
    private static final AnnualReview[] rRef = new AnnualReview[10];
    private static final Company[] cRef = new Company[5];
    private static final Insurance[] insRef = new Insurance[5];
    private static final Person[] pRef = new Person[20];
    private static final Project[] projRef = new Project[10];
    private static final Team[] tRef = new Team[10];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Address", pkgName + "AnnualReview", pkgName + "Company", pkgName + "Insurance", pkgName + "Person", pkgName + "Project", pkgName + "Team"};
        return this.createDeploymentJar("jpa_core_relationship_annotations.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void annotationMappingTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationMappingTest1");
        boolean pass = false;
        try {
            this.createPeople();
            this.createProjects();
            this.getEntityTransaction().begin();
            pRef[0].setProject(projRef[2]);
            projRef[2].setProjectLead(pRef[0]);
            this.getEntityManager().merge((Object)pRef[0]);
            this.getEntityManager().merge((Object)projRef[2]);
            Person newPerson = (Person)this.getEntityManager().find(Person.class, (Object)1);
            if (newPerson.getProject().getName().equals("Asp")) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMappingTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMappingPersistTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationMappingPersistTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.createPeople(false);
            this.createProjects(false);
            pRef[0].setProject(projRef[2]);
            projRef[2].setProjectLead(pRef[0]);
            this.getEntityManager().persist((Object)pRef[0]);
            this.getEntityTransaction().commit();
            Person personFound = (Person)this.getEntityManager().find(Person.class, (Object)pRef[0].getPersonId());
            Project projectFound = (Project)this.getEntityManager().find(Project.class, (Object)projRef[2].getProjId());
            if (personFound != null && projectFound != null) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to find persisted Person or Project:  personFound: " + personFound + ", projectFound: " + projectFound);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMappingPersistTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMappingTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationMappingTest2");
        boolean pass1 = true;
        boolean pass2 = false;
        int foundTeam1 = 0;
        int foundTeam2 = 0;
        String[] expectedTeam1 = new String[]{"Engineering", "Marketing", "Sales"};
        String[] expectedTeam2 = new String[]{"Accounting", "Training"};
        try {
            this.createTeams();
            this.createCompany();
            this.getEntityTransaction().begin();
            tRef[0].setCompany(cRef[0]);
            tRef[1].setCompany(cRef[0]);
            tRef[2].setCompany(cRef[0]);
            Vector<Team> v1 = new Vector<Team>();
            v1.add(tRef[0]);
            v1.add(tRef[1]);
            v1.add(tRef[2]);
            cRef[0].setTeams(v1);
            tRef[3].setCompany(cRef[1]);
            tRef[4].setCompany(cRef[1]);
            Vector<Team> v2 = new Vector<Team>();
            v2.add(tRef[3]);
            v2.add(tRef[4]);
            cRef[1].setTeams(v2);
            this.getEntityManager().merge((Object)tRef[0]);
            this.getEntityManager().merge((Object)tRef[1]);
            this.getEntityManager().merge((Object)tRef[2]);
            this.getEntityManager().merge((Object)tRef[3]);
            this.getEntityManager().merge((Object)tRef[4]);
            this.getEntityManager().merge((Object)cRef[0]);
            this.getEntityManager().merge((Object)cRef[1]);
            this.getEntityManager().flush();
            Company c1 = (Company)this.getEntityManager().find(Company.class, (Object)25501L);
            Collection<Team> t1 = c1.getTeams();
            Company c2 = (Company)this.getEntityManager().find(Company.class, (Object)37560L);
            Collection<Team> t2 = c2.getTeams();
            if (t1.size() != 3 || t2.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "annotationMappingTest2: Did not get expected results.Team1 Collection Expected 3 references, got: " + t1.size() + ", Team2 Collection Expected 2 references, got: " + t2.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Team> i1 = t1.iterator();
                block11: while (i1.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Team 1 Collection for expected Teams");
                    Team o1 = i1.next();
                    for (int l = 0; l < 3; ++l) {
                        if (!expectedTeam1[l].equals(o1.getName())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Team 1:" + o1.getName());
                        ++foundTeam1;
                        continue block11;
                    }
                }
                Iterator<Team> i2 = t2.iterator();
                block13: while (i2.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Team 2 Collection for expected Teams");
                    Team o2 = i2.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedTeam2[l].equals(o2.getName())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Team 2:" + o2.getName());
                        ++foundTeam2;
                        continue block13;
                    }
                }
            }
            if (foundTeam1 != 3 || foundTeam2 != 2) {
                logger.log(System.Logger.Level.ERROR, "annotationMappingTest2: Did not get expected results");
                pass2 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass2) {
            throw new Exception("annotationMappingTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMappingTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationMappingTest3");
        boolean pass = false;
        try {
            this.createTeams();
            this.createCompany();
            this.getEntityTransaction().begin();
            tRef[0].setCompany(cRef[0]);
            tRef[1].setCompany(cRef[0]);
            Vector<Team> v1 = new Vector<Team>();
            v1.add(tRef[0]);
            v1.add(tRef[1]);
            cRef[0].setTeams(v1);
            tRef[2].setCompany(cRef[1]);
            tRef[3].setCompany(cRef[1]);
            tRef[4].setCompany(cRef[1]);
            Vector<Team> v2 = new Vector<Team>();
            v2.add(tRef[2]);
            v2.add(tRef[3]);
            v2.add(tRef[4]);
            cRef[1].setTeams(v2);
            this.getEntityManager().merge((Object)tRef[0]);
            this.getEntityManager().merge((Object)tRef[1]);
            this.getEntityManager().merge((Object)tRef[2]);
            this.getEntityManager().merge((Object)tRef[3]);
            this.getEntityManager().merge((Object)tRef[4]);
            this.getEntityManager().merge((Object)cRef[0]);
            this.getEntityManager().merge((Object)cRef[1]);
            this.getEntityManager().flush();
            Team t1 = (Team)this.getEntityManager().find(Team.class, (Object)1);
            Team t2 = (Team)this.getEntityManager().find(Team.class, (Object)2);
            Team t3 = (Team)this.getEntityManager().find(Team.class, (Object)3);
            Team t4 = (Team)this.getEntityManager().find(Team.class, (Object)4);
            Team t5 = (Team)this.getEntityManager().find(Team.class, (Object)5);
            if (t1.getCompany().getCompanyId() == 25501L && t2.getCompany().getCompanyId() == 25501L && t3.getCompany().getCompanyId() == 37560L && t4.getCompany().getCompanyId() == 37560L && t5.getCompany().getCompanyId() == 37560L) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMappingTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMappingTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationMappingTest4");
        boolean pass = false;
        try {
            this.createAddress();
            this.createCompany();
            this.getEntityTransaction().begin();
            cRef[0].setAddress(aRef[0]);
            cRef[1].setAddress(aRef[1]);
            this.getEntityManager().merge((Object)cRef[0]);
            this.getEntityManager().merge((Object)cRef[1]);
            this.getEntityManager().flush();
            Company c1 = (Company)this.getEntityManager().find(Company.class, (Object)25501L);
            Company c2 = (Company)this.getEntityManager().find(Company.class, (Object)37560L);
            if (c1.getAddress().getCity().equals("Burlington") && c2.getAddress().getCity().equals("Santa Clara")) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "annotationMappingTest4: Did not get expected resultsExpected: Burlington and Santa Clara, got: " + c1.getAddress().getCity() + c2.getAddress().getCity());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMappingTest4 failed");
        }
    }

    @Test
    public void annotationMappingTest5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationMappingTest5");
        boolean pass = false;
        try {
            this.createTeams();
            this.createPeople();
            this.getEntityTransaction().begin();
            pRef[1].setTeam(tRef[0]);
            pRef[3].setTeam(tRef[1]);
            pRef[5].setTeam(tRef[2]);
            pRef[7].setTeam(tRef[3]);
            pRef[9].setTeam(tRef[4]);
            pRef[2].setTeam(tRef[4]);
            pRef[4].setTeam(tRef[3]);
            pRef[6].setTeam(tRef[2]);
            pRef[8].setTeam(tRef[1]);
            pRef[10].setTeam(tRef[0]);
            for (int i = 1; i < 11; ++i) {
                this.getEntityManager().merge((Object)pRef[i]);
            }
            this.getEntityManager().flush();
            if (pRef[1].getTeam() == tRef[0] && pRef[10].getTeam() == tRef[0] && pRef[3].getTeam() == tRef[1] && pRef[8].getTeam() == tRef[1] && pRef[5].getTeam() == tRef[2] && pRef[6].getTeam() == tRef[2] && pRef[7].getTeam() == tRef[3] && pRef[4].getTeam() == tRef[3] && pRef[9].getTeam() == tRef[4] && pRef[2].getTeam() == tRef[4]) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMappingTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMappingTest6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationMappingTest6");
        boolean pass1 = true;
        boolean pass2 = false;
        int foundProject1 = 0;
        int foundProject2 = 0;
        Long[] expectedResults1 = new Long[]{123456789L, 345678901L, 567890123L};
        Long[] expectedResults2 = new Long[]{234567890L, 345678901L, 456789012L};
        try {
            this.createPeople();
            this.createProjects();
            this.getEntityTransaction().begin();
            pRef[5].getProjects().add(projRef[0]);
            pRef[5].getProjects().add(projRef[2]);
            pRef[5].getProjects().add(projRef[4]);
            this.getEntityManager().merge((Object)pRef[5]);
            pRef[8].getProjects().add(projRef[1]);
            pRef[8].getProjects().add(projRef[2]);
            pRef[8].getProjects().add(projRef[3]);
            this.getEntityManager().merge((Object)pRef[8]);
            projRef[0].getPersons().add(pRef[5]);
            this.getEntityManager().merge((Object)projRef[0]);
            projRef[1].getPersons().add(pRef[8]);
            this.getEntityManager().merge((Object)projRef[1]);
            projRef[2].getPersons().add(pRef[5]);
            this.getEntityManager().merge((Object)projRef[2]);
            projRef[2].getPersons().add(pRef[8]);
            this.getEntityManager().merge((Object)projRef[2]);
            projRef[3].getPersons().add(pRef[8]);
            this.getEntityManager().merge((Object)projRef[3]);
            projRef[4].getPersons().add(pRef[5]);
            this.getEntityManager().merge((Object)projRef[4]);
            this.getEntityManager().flush();
            Person p1 = (Person)this.getEntityManager().find(Person.class, (Object)6);
            Person p2 = (Person)this.getEntityManager().find(Person.class, (Object)9);
            Collection<Project> projCol1 = p1.getProjects();
            Collection<Project> projCol2 = p2.getProjects();
            if (projCol1.size() != 3 || projCol2.size() != 3) {
                logger.log(System.Logger.Level.ERROR, "annotationMappingTest6: Did not get expected results.Expected 3 Projects for Karen Tegan (PK 6) , got: " + projCol1.size() + ", Expected 2 Projects for William Keaton (PK 9), got: " + projCol2.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Project> i1 = projCol1.iterator();
                block11: while (i1.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Karen Tegan Projects");
                    Project o1 = i1.next();
                    for (int l = 0; l < 3; ++l) {
                        if (!expectedResults1[l].equals(o1.getProjId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Project for Karen Tegan: " + o1.getName());
                        ++foundProject1;
                        continue block11;
                    }
                }
                Iterator<Project> i2 = projCol2.iterator();
                block13: while (i2.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for William Keaton Projects");
                    Project o2 = i2.next();
                    for (int l = 0; l < 3; ++l) {
                        if (!expectedResults2[l].equals(o2.getProjId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Project for William Keaton: " + o2.getName());
                        ++foundProject2;
                        continue block13;
                    }
                }
            }
            if (foundProject1 != 3 || foundProject2 != 3) {
                logger.log(System.Logger.Level.ERROR, "annotationMappingTest6: Did not get expected results");
                pass2 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            Vector<Person> nullPersonCol = new Vector<Person>();
            projRef[0].setPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[0]);
            projRef[1].setPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[1]);
            projRef[2].setPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[2]);
            projRef[3].setPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[3]);
            projRef[4].setPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[4]);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("annotationMappingTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMappingTest7() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationMappingTest7");
        boolean pass1 = true;
        boolean pass2 = false;
        Vector<AnnualReview> v1 = null;
        Vector<AnnualReview> v2 = null;
        Vector<AnnualReview> v3 = null;
        Vector<AnnualReview> v4 = null;
        int foundCol1 = 0;
        int foundCol2 = 0;
        int foundCol3 = 0;
        int foundCol4 = 0;
        int foundCol5 = 0;
        Integer[] expectedCol1 = new Integer[]{1, 2, 3, 4};
        Integer[] expectedCol2 = new Integer[]{5, 6};
        Integer[] expectedCol3 = new Integer[]{3, 8};
        Integer[] expectedCol4 = new Integer[]{4, 7};
        Integer[] expectedCol5 = new Integer[]{1, 2, 3, 4};
        try {
            this.createReviews();
            this.createPeople();
            this.getEntityTransaction().begin();
            v1 = new Vector<AnnualReview>();
            v1.add(rRef[0]);
            v1.add(rRef[1]);
            v1.add(rRef[2]);
            v1.add(rRef[3]);
            v2 = new Vector<AnnualReview>();
            v2.add(rRef[4]);
            v2.add(rRef[5]);
            v3 = new Vector<AnnualReview>();
            v3.add(rRef[2]);
            v3.add(rRef[7]);
            v4 = new Vector<AnnualReview>();
            v4.add(rRef[3]);
            v4.add(rRef[6]);
            pRef[11].setAnnualReviews(v1);
            pRef[13].setAnnualReviews(v2);
            pRef[15].setAnnualReviews(v3);
            pRef[17].setAnnualReviews(v4);
            pRef[19].setAnnualReviews(v1);
            this.getEntityManager().merge((Object)pRef[11]);
            this.getEntityManager().merge((Object)pRef[13]);
            this.getEntityManager().merge((Object)pRef[15]);
            this.getEntityManager().merge((Object)pRef[17]);
            this.getEntityManager().merge((Object)pRef[19]);
            this.getEntityManager().flush();
            Person p1 = (Person)this.getEntityManager().find(Person.class, (Object)12);
            Person p2 = (Person)this.getEntityManager().find(Person.class, (Object)14);
            Person p3 = (Person)this.getEntityManager().find(Person.class, (Object)16);
            Person p4 = (Person)this.getEntityManager().find(Person.class, (Object)18);
            Person p5 = (Person)this.getEntityManager().find(Person.class, (Object)20);
            Collection<AnnualReview> col1 = p1.getAnnualReviews();
            Collection<AnnualReview> col2 = p2.getAnnualReviews();
            Collection<AnnualReview> col3 = p3.getAnnualReviews();
            Collection<AnnualReview> col4 = p4.getAnnualReviews();
            Collection<AnnualReview> col5 = p5.getAnnualReviews();
            if (col1.size() != 4 || col2.size() != 2 || col3.size() != 2 || col4.size() != 2 || col5.size() != 4) {
                logger.log(System.Logger.Level.ERROR, "annotationMappingTest7: Did not get expected results.Expected 4 reviews for Mary Macy (PK 12) , got: " + col1.size() + ", Expected 2 reviews for Julie OClaire (PK 14), got: " + col2.size() + ", Expected 2 reviews for Kellie Lee (PK 16), got: " + col3.size() + ", Expected 2 reviews for Mark Francis (PK 18), got: " + col4.size() + ", Expected 4 reviews for Katy Hughes (PK 20), got: " + col5.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<AnnualReview> i1 = col1.iterator();
                block11: while (i1.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Mary Macy Reviews");
                    AnnualReview o1 = i1.next();
                    for (int l = 0; l < 5; ++l) {
                        if (!expectedCol1[l].equals(o1.getService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Mary Macy Annual Review for Service Year: " + o1.getService());
                        ++foundCol1;
                        continue block11;
                    }
                }
                Iterator<AnnualReview> i2 = col2.iterator();
                block13: while (i2.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Julie OClaire Reviews");
                    AnnualReview o2 = i2.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedCol2[l].equals(o2.getService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Julie OClaire Annual Review for Service Year: " + o2.getService());
                        ++foundCol2;
                        continue block13;
                    }
                }
                Iterator<AnnualReview> i3 = col3.iterator();
                block15: while (i3.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Kellie Lee Reviews");
                    AnnualReview o3 = i3.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedCol3[l].equals(o3.getService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Kellie Lee Annual Review for Service Year: " + o3.getService());
                        ++foundCol3;
                        continue block15;
                    }
                }
                Iterator<AnnualReview> i4 = col4.iterator();
                block17: while (i4.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Mark Francis Reviews");
                    AnnualReview o4 = i4.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedCol4[l].equals(o4.getService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Mark Francis Annual Review for Service Year: " + o4.getService());
                        ++foundCol4;
                        continue block17;
                    }
                }
                Iterator<AnnualReview> i5 = col5.iterator();
                block19: while (i5.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Katy Hughes Reviews");
                    AnnualReview o5 = i5.next();
                    for (int l = 0; l < 5; ++l) {
                        if (!expectedCol5[l].equals(o5.getService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Katy Hughes Annual Review for Service Year: " + o5.getService());
                        ++foundCol5;
                        continue block19;
                    }
                }
            }
            if (foundCol1 != 4 || foundCol2 != 2 || foundCol3 != 2 || foundCol4 != 2 || foundCol5 != 4) {
                logger.log(System.Logger.Level.ERROR, "annotationMappingTest7: Did not get expected results");
                pass2 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("annotationMappingTest7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMappingTest8() throws Exception {
        boolean pass1 = true;
        boolean pass2 = false;
        int foundInsurance1 = 0;
        int foundInsurance2 = 0;
        int foundInsurance3 = 0;
        Integer[] expectedResults1 = new Integer[]{1, 3};
        Integer[] expectedResults2 = new Integer[]{2, 3};
        Integer[] expectedResults3 = new Integer[]{1, 2, 3};
        try {
            this.createPeople();
            this.createInsurance();
            this.getEntityTransaction().begin();
            pRef[2].getInsurance().add(insRef[0]);
            pRef[2].getInsurance().add(insRef[2]);
            this.getEntityManager().merge((Object)pRef[2]);
            pRef[12].getInsurance().add(insRef[1]);
            pRef[12].getInsurance().add(insRef[2]);
            this.getEntityManager().merge((Object)pRef[12]);
            pRef[16].getInsurance().add(insRef[0]);
            pRef[16].getInsurance().add(insRef[1]);
            pRef[16].getInsurance().add(insRef[2]);
            this.getEntityManager().merge((Object)pRef[16]);
            this.getEntityManager().flush();
            Person p1 = (Person)this.getEntityManager().find(Person.class, (Object)3);
            Person p2 = (Person)this.getEntityManager().find(Person.class, (Object)13);
            Person p3 = (Person)this.getEntityManager().find(Person.class, (Object)17);
            Collection<Insurance> insCol1 = p1.getInsurance();
            Collection<Insurance> insCol2 = p2.getInsurance();
            Collection<Insurance> insCol3 = p3.getInsurance();
            if (insCol1.size() != 2 || insCol2.size() != 2 || insCol3.size() != 3) {
                logger.log(System.Logger.Level.ERROR, "annotationMappingTest8: Did not get expected results.Expected 2 Insurance Carriers for Shelly McGowan (PK 3) , got: " + insCol1.size() + ", Expected 2 Insurance Carriers for Cheng Fang (PK 13) , got: " + insCol2.size() + ", Expected 3 Insurance Carriers for Nicole Martin (PK 17), got: " + insCol3.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Insurance> i1 = insCol1.iterator();
                block11: while (i1.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Insurance Carriers for Shelly McGowan");
                    Insurance o1 = i1.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedResults1[l].equals(o1.getInsId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Insurance Carrier for Shelly McGowan: " + o1.getCarrier());
                        ++foundInsurance1;
                        continue block11;
                    }
                }
                Iterator<Insurance> i2 = insCol2.iterator();
                block13: while (i2.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Insurance Carriers for Cheng Fang");
                    Insurance o2 = i2.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedResults2[l].equals(o2.getInsId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Insurance Carrier for Cheng Fang: " + o2.getCarrier());
                        ++foundInsurance2;
                        continue block13;
                    }
                }
                Iterator<Insurance> i3 = insCol3.iterator();
                block15: while (i3.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Insurance Carriers for Nicole Martin");
                    Insurance o3 = i3.next();
                    for (int l = 0; l < 3; ++l) {
                        if (!expectedResults3[l].equals(o3.getInsId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Insurance Carrier for Nicole Martin: " + o3.getCarrier());
                        ++foundInsurance3;
                        continue block15;
                    }
                }
            }
            if (foundInsurance1 != 2 || foundInsurance2 != 2 || foundInsurance3 != 3) {
                logger.log(System.Logger.Level.ERROR, "annotationMappingTest8: Did not get expected results");
                pass2 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("annotationMappingTest8 failed");
        }
    }

    private void createPeople() throws Exception {
        this.createPeople(true);
    }

    private void createPeople(boolean persist) throws Exception {
        logger.log(System.Logger.Level.TRACE, "CreatePeople(persist=" + persist + ")");
        logger.log(System.Logger.Level.TRACE, "Create 20 People");
        Client.pRef[0] = new Person(1, "Alan", "Frechette");
        Client.pRef[1] = new Person(2, "Arthur", "Frechette");
        Client.pRef[2] = new Person(3, "Shelly", "McGowan");
        Client.pRef[3] = new Person(4, "Robert", "Bissett");
        Client.pRef[4] = new Person(5, "Stephen", "DMilla");
        Client.pRef[5] = new Person(6, "Karen", "Tegan");
        Client.pRef[6] = new Person(7, "Stephen", "Cruise");
        Client.pRef[7] = new Person(8, "Irene", "Caruso");
        Client.pRef[8] = new Person(9, "William", "Keaton");
        Client.pRef[9] = new Person(10, "Kate", "Hudson");
        Client.pRef[10] = new Person(11, "Jonathan", "Smith");
        Client.pRef[11] = new Person(12, "Mary", "Macy");
        Client.pRef[12] = new Person(13, "Cheng", "Fang");
        Client.pRef[13] = new Person(14, "Julie", "OClaire");
        Client.pRef[14] = new Person(15, "Steven", "Rich");
        Client.pRef[15] = new Person(16, "Kellie", "Lee");
        Client.pRef[16] = new Person(17, "Nicole", "Martin");
        Client.pRef[17] = new Person(18, "Mark", "Francis");
        Client.pRef[18] = new Person(19, "Will", "Forrest");
        Client.pRef[19] = new Person(20, "Katy", "Hughes");
        if (persist) {
            logger.log(System.Logger.Level.TRACE, "Start to persist people ");
            this.getEntityTransaction().begin();
            for (Person p : pRef) {
                if (p == null) continue;
                this.getEntityManager().persist((Object)p);
                logger.log(System.Logger.Level.TRACE, "Persisting person " + p);
            }
            this.getEntityTransaction().commit();
        }
    }

    private void createTeams() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 5 Teams");
        Client.tRef[0] = new Team(1, "Engineering");
        Client.tRef[1] = new Team(2, "Marketing");
        Client.tRef[2] = new Team(3, "Sales");
        Client.tRef[3] = new Team(4, "Accounting");
        Client.tRef[4] = new Team(5, "Training");
        logger.log(System.Logger.Level.TRACE, "Start to persist teams ");
        this.getEntityTransaction().begin();
        for (Team t : tRef) {
            if (t == null) continue;
            this.getEntityManager().persist((Object)t);
            logger.log(System.Logger.Level.TRACE, "persisted team " + t);
        }
        this.getEntityTransaction().commit();
    }

    private void createInsurance() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 3 Insurance Carriers");
        Client.insRef[0] = new Insurance(1, "Prudential");
        Client.insRef[1] = new Insurance(2, "Cigna");
        Client.insRef[2] = new Insurance(3, "Sentry");
        logger.log(System.Logger.Level.TRACE, "Start to persist insurance ");
        this.getEntityTransaction().begin();
        for (Insurance i : insRef) {
            if (i == null) continue;
            this.getEntityManager().persist((Object)i);
            logger.log(System.Logger.Level.TRACE, "persisted insurance " + i);
        }
        this.getEntityTransaction().commit();
    }

    private void createProjects() throws Exception {
        this.createProjects(true);
    }

    private void createProjects(boolean persist) throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 5 Projects (persist=" + persist + ")");
        Client.projRef[0] = new Project(123456789L, "Sidewinder", new BigDecimal("20500.0"));
        Client.projRef[1] = new Project(234567890L, "Boa", new BigDecimal("75000.0"));
        Client.projRef[2] = new Project(345678901L, "Asp", new BigDecimal("500000.0"));
        Client.projRef[3] = new Project(456789012L, "King Cobra", new BigDecimal("250000.0"));
        Client.projRef[4] = new Project(567890123L, "Python", new BigDecimal("1000.0"));
        if (persist) {
            logger.log(System.Logger.Level.TRACE, "Start to persist projects ");
            this.getEntityTransaction().begin();
            for (Project p : projRef) {
                if (p == null) continue;
                this.getEntityManager().persist((Object)p);
                logger.log(System.Logger.Level.TRACE, "persisted project " + p);
            }
            this.getEntityTransaction().commit();
        }
    }

    private void createCompany() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 2 Companies");
        Client.cRef[0] = new Company(25501L, "American Gifts");
        Client.cRef[1] = new Company(37560L, "Planet Earth");
        logger.log(System.Logger.Level.TRACE, "Start to persist companies ");
        this.getEntityTransaction().begin();
        for (Company c : cRef) {
            if (c == null) continue;
            this.getEntityManager().persist((Object)c);
            logger.log(System.Logger.Level.TRACE, "persisted company " + c);
        }
        this.getEntityTransaction().commit();
    }

    private void createAddress() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 2 Addresses");
        Client.aRef[0] = new Address("100", "1 Network Drive", "Burlington", "MA", "01803");
        Client.aRef[1] = new Address("200", "4150 Network Drive", "Santa Clara", "CA", "95054");
        logger.log(System.Logger.Level.TRACE, "Start to persist addresses ");
        this.getEntityTransaction().begin();
        for (Address a : aRef) {
            if (a == null) continue;
            this.getEntityManager().persist((Object)a);
            logger.log(System.Logger.Level.TRACE, "persisted address " + a);
        }
        this.getEntityTransaction().commit();
    }

    private void createReviews() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 5 Addresses");
        Client.rRef[0] = new AnnualReview(1, 1);
        Client.rRef[1] = new AnnualReview(2, 2);
        Client.rRef[2] = new AnnualReview(3, 3);
        Client.rRef[3] = new AnnualReview(4, 4);
        Client.rRef[4] = new AnnualReview(5, 5);
        Client.rRef[5] = new AnnualReview(6, 6);
        Client.rRef[6] = new AnnualReview(7, 7);
        Client.rRef[7] = new AnnualReview(8, 8);
        logger.log(System.Logger.Level.TRACE, "Start to persist annual reviews ");
        this.getEntityTransaction().begin();
        for (AnnualReview a : rRef) {
            if (a == null) continue;
            this.getEntityManager().persist((Object)a);
            logger.log(System.Logger.Level.TRACE, "persisted annual reviews " + a);
        }
        this.getEntityTransaction().commit();
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PROJECT_PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PERSON_INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PERSON_ANNUALREVIEW").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM ANNUALREVIEW").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM TEAM").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM COMPANY").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM ADDRESS").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

